/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class TargaRLECodec
extends BaseCodec {
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("Targa RLE compression not currently supported");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        long fp = in.getFilePointer();
        ByteArrayOutputStream output = new ByteArrayOutputStream(options.maxBytes);
        int nread = 0;
        BufferedInputStream s = new BufferedInputStream(in, 262144);
        int bpp = options.bitsPerSample / 8;
        while (output.size() < options.maxBytes) {
            byte n = (byte)(s.read() & 0xFF);
            ++nread;
            if (n >= 0) {
                byte[] b = new byte[bpp * (n + 1)];
                s.read(b);
                nread += bpp * n + 1;
                output.write(b);
                b = null;
                continue;
            }
            if (n == -128) continue;
            int len = (n & 0x7F) + 1;
            byte[] inp = new byte[bpp];
            s.read(inp);
            nread += bpp;
            for (int i = 0; i < len; ++i) {
                output.write(inp);
            }
        }
        in.seek(fp + (long)nread);
        return output.toByteArray();
    }
}

