/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.encryption;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.client.encryption.FailedPGPIntegrityCheck;
import ch.systemsx.cisd.cifex.rpc.client.encryption.PGPLiteralDataGenerator;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOverwriteStrategy;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;

public class OpenPGPSymmetricKeyEncryption {
    public static final String PGP_FILE_EXTENSION = ".pgp";
    public static final String CLEAR_PREFIX = "CLEAR_";
    private static final String ARMORED_PGP_HEADER = "-----BEGIN PGP MESSAGE-----";

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static File encrypt(File inFile, File outFile, String passPhrase, final boolean overwriteOutFile) {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            FileUtilities.checkInputFile(inFile);
            FileUtilities.checkOutputFile(outFile, new IFileOverwriteStrategy(){

                @Override
                public boolean overwriteAllowed(File outputFile) {
                    return overwriteOutFile;
                }
            });
            FileInputStream inStream = null;
            File actualOutFile = outFile.getCanonicalFile();
            if (inFile.getCanonicalFile().equals(actualOutFile)) {
                actualOutFile = new File(actualOutFile.getParent(), String.valueOf(actualOutFile.getName()) + PGP_FILE_EXTENSION);
            }
            OutputStream outStream = OpenPGPSymmetricKeyEncryption.getPGPOutStream(inFile, actualOutFile, passPhrase, closeables);
            try {
                inStream = new FileInputStream(inFile);
                IOUtils.copyLarge((InputStream)inStream, (OutputStream)outStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                OpenPGPSymmetricKeyEncryption.closeInReverseOrder(closeables, false);
                outStream.close();
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStream);
            OpenPGPSymmetricKeyEncryption.closeInReverseOrder(closeables, false);
            outStream.close();
            return actualOutFile;
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    private static OutputStream getPGPOutStream(File inFile, File outFile, String passPhrase, List<Closeable> closeables) throws NoSuchProviderException, PGPException, FileNotFoundException {
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(7, true, new SecureRandom(), "BC");
        encryptedDataGenerator.addMethod(passPhrase.toCharArray());
        FileOutputStream outStream = new FileOutputStream(outFile);
        closeables.add(outStream);
        try {
            OutputStream encryptingOutStream = encryptedDataGenerator.open((OutputStream)outStream, inFile.length() + (long)OpenPGPSymmetricKeyEncryption.getPGPLiteralDataHeaderLength('b', inFile));
            closeables.add(encryptingOutStream);
            PGPLiteralDataGenerator literalData = new PGPLiteralDataGenerator();
            OutputStream pgpOutStream = literalData.open(encryptingOutStream, 'b', inFile.getName(), inFile.length(), new Date(inFile.lastModified()));
            closeables.add(pgpOutStream);
            return pgpOutStream;
        }
        catch (Exception ex) {
            OpenPGPSymmetricKeyEncryption.closeInReverseOrder(closeables, true);
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static void closeInReverseOrder(List<Closeable> closeables, boolean quietOnException) {
        ListIterator<Closeable> it = closeables.listIterator(closeables.size());
        while (it.hasPrevious()) {
            try {
                Closeable closeable = it.previous();
                closeable.close();
            }
            catch (IOException ex) {
                if (quietOnException) continue;
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private static int getPGPLiteralDataHeaderLength(char fileType, File file) throws IOException {
        CountingOutputStream outStream = new CountingOutputStream((OutputStream)new NullOutputStream());
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        try {
            literalDataGenerator.open((OutputStream)outStream, fileType, file.getName(), file.length(), new Date(file.lastModified()));
        }
        finally {
            literalDataGenerator.close();
        }
        return outStream.getCount();
    }

    public static File decrypt(File inFile, String outFileNameOrNull, String passPhrase, final boolean overwriteOutFile) {
        return OpenPGPSymmetricKeyEncryption.decrypt(inFile, outFileNameOrNull, passPhrase, new IFileOverwriteStrategy(){

            @Override
            public boolean overwriteAllowed(File outputFile) {
                return overwriteOutFile;
            }
        });
    }

    public static File decrypt(File inFile, String outFileNameOrNull, String passPhrase, IFileOverwriteStrategy fileOverwriteStrategy) {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            PGPPBEEncryptedData encryptedData = OpenPGPSymmetricKeyEncryption.getPGPEncryptedData(inFile, closeables);
            PGPLiteralData literalData = OpenPGPSymmetricKeyEncryption.getLiteralData(encryptedData, passPhrase);
            closeables.add(literalData.getInputStream());
            String directory = inFile.getParent();
            String outFileName = outFileNameOrNull == null ? literalData.getFileName() : outFileNameOrNull;
            File outFile = new File(directory, outFileName).getCanonicalFile();
            FileUtilities.checkInputFile(inFile);
            FileUtilities.checkOutputFile(outFile, fileOverwriteStrategy);
            if (inFile.getCanonicalFile().equals(outFile)) {
                outFile = new File(outFile.getParentFile(), CLEAR_PREFIX + outFileName);
            }
            FileOutputStream outStream = new FileOutputStream(outFile);
            try {
                InputStream literalDataStream = literalData.getInputStream();
                IOUtils.copyLarge((InputStream)literalDataStream, (OutputStream)outStream);
                OpenPGPSymmetricKeyEncryption.checkIntegrity(encryptedData, inFile);
            }
            finally {
                outStream.close();
            }
            File file = outFile;
            return file;
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
        finally {
            OpenPGPSymmetricKeyEncryption.closeInReverseOrder(closeables, true);
        }
    }

    private static void checkIntegrity(PGPPBEEncryptedData encryptedData, File inFile) {
        try {
            if (encryptedData.isIntegrityProtected() && !encryptedData.verify()) {
                throw new FailedPGPIntegrityCheck(inFile);
            }
        }
        catch (PGPException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static PGPLiteralData getLiteralData(PGPPBEEncryptedData encryptedData, String passPhrase) throws PGPException, NoSuchProviderException, IOException {
        InputStream decryptedDataStream = encryptedData.getDataStream(passPhrase.toCharArray(), "BC");
        PGPObjectFactory pgpFactory = new PGPObjectFactory(decryptedDataStream);
        Object openPGPObject = pgpFactory.nextObject();
        if (openPGPObject instanceof PGPCompressedData) {
            PGPCompressedData compressedData = (PGPCompressedData)openPGPObject;
            pgpFactory = new PGPObjectFactory(compressedData.getDataStream());
            openPGPObject = pgpFactory.nextObject();
        }
        return (PGPLiteralData)openPGPObject;
    }

    private static PGPPBEEncryptedData getPGPEncryptedData(File inFile, List<Closeable> closeables) throws FileNotFoundException, IOException, PGPException {
        try {
            FileInputStream pgpIn;
            switch (OpenPGPSymmetricKeyEncryption.getPGPMessageType(inFile)) {
                case BINARY: {
                    pgpIn = new FileInputStream(inFile);
                    break;
                }
                case ARMORED: {
                    pgpIn = new ArmoredInputStream((InputStream)new FileInputStream(inFile));
                    break;
                }
                default: {
                    throw new PGPException("No PGP file.");
                }
            }
            closeables.add(pgpIn);
            PGPObjectFactory pgpFactory = new PGPObjectFactory((InputStream)pgpIn);
            Object openPGPObject = pgpFactory.nextObject();
            PGPEncryptedDataList encryptedDataList = openPGPObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)openPGPObject : (PGPEncryptedDataList)pgpFactory.nextObject();
            PGPPBEEncryptedData encryptedData = (PGPPBEEncryptedData)encryptedDataList.get(0);
            closeables.add(encryptedData.getInputStream());
            return encryptedData;
        }
        catch (Exception ex) {
            if (ex instanceof PGPException) {
                throw (PGPException)((Object)ex);
            }
            throw new PGPException("Cannot decrypt file", ex);
        }
    }

    private static PGP_MESSAGE_TYPE getPGPMessageType(File inFile) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        try {
            byte[] buf = new byte[ARMORED_PGP_HEADER.length()];
            ((InputStream)in).read(buf, 0, buf.length);
            if ((buf[0] & 0x80) != 0) {
                PGP_MESSAGE_TYPE pGP_MESSAGE_TYPE = PGP_MESSAGE_TYPE.BINARY;
                return pGP_MESSAGE_TYPE;
            }
            PGP_MESSAGE_TYPE pGP_MESSAGE_TYPE = new String(buf).equals(ARMORED_PGP_HEADER) ? PGP_MESSAGE_TYPE.ARMORED : PGP_MESSAGE_TYPE.NONE;
            return pGP_MESSAGE_TYPE;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static enum PGP_MESSAGE_TYPE {
        BINARY,
        ARMORED,
        NONE;

    }
}

