/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.server.AbstractCIFEXServiceServlet;
import ch.systemsx.cisd.cifex.server.business.FileInformation;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.dto.FileContent;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.shared.basic.Constants;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class FileDownloadServlet
extends AbstractCIFEXServiceServlet {
    private static final long serialVersionUID = 1L;

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, InvalidSessionException {
        IUserActionLog log = this.domainModel.getBusinessContext().getUserActionLogHttp();
        UserDTO requestUser = this.getUserDTO(request);
        String fileIdParameter = request.getParameter("fileId");
        if (StringUtils.isNotBlank((String)fileIdParameter)) {
            InputStream inputStream = null;
            ServletOutputStream outputStream = null;
            try {
                try {
                    long fileId = Long.parseLong(fileIdParameter);
                    IFileManager fileManager = this.domainModel.getFileManager();
                    FileInformation fileInfo = fileManager.getFileInformation(fileId);
                    if (!fileInfo.isFileAvailable()) {
                        log.logDownloadFileFailedNotFound(fileInfo.getFileDTO());
                        throw new UserFailureException(fileInfo.getErrorMessage());
                    }
                    if (!fileManager.isAllowedAccess(requestUser, fileInfo.getFileDTO())) {
                        log.logDownloadFileFailedNotAuthorized(fileInfo.getFileDTO());
                        throw UserFailureException.fromTemplate(Constants.getErrorMessageForFileNotFound(fileId), new Object[0]);
                    }
                    FileContent fileOutput = fileManager.getFileContent(fileInfo.getFileDTO());
                    Long size = fileOutput.getBasicFile().getSize();
                    if (size != null) {
                        if (size <= Integer.MAX_VALUE) {
                            response.setContentLength(size.intValue());
                        } else {
                            response.addHeader("Content-Length", Long.toString(size));
                        }
                    }
                    response.setContentType("application/x-unknown");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileOutput.getBasicFile().getName() + "\"");
                    inputStream = fileOutput.getInputStream();
                    outputStream = response.getOutputStream();
                    log.logDownloadFileStart(fileInfo.getFileDTO(), 0L);
                    boolean success = false;
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        success = true;
                    }
                    finally {
                        log.logDownloadFileFinished(fileInfo.getFileDTO(), success);
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ServletException(String.format("Given file id '%s' is not a number.", fileIdParameter), (Throwable)ex);
                }
                catch (InvalidSessionException ex) {
                    throw new ServletException(ex.getMessage(), (Throwable)ex);
                }
                catch (UserFailureException ex) {
                    this.operationLog.error((Object)String.format("Problem while accessing file id '%s'.", fileIdParameter), (Throwable)ex);
                    throw new ServletException(ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

