/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.Script;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.ISqlScriptProvider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class SqlScriptProvider
implements ISqlScriptProvider {
    static final String GENERIC = "generic";
    private static final String DUMP_FILENAME = ".DUMP";
    private static final String SQL_FILE_TYPE = ".sql";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SqlScriptProvider.class);
    private final List<String> schemaScriptRootFolders;
    private final String databaseEngineCode;

    public SqlScriptProvider(List<String> schemaScriptRootFolders, String databaseEngineCode) {
        if (schemaScriptRootFolders.isEmpty()) {
            throw new IllegalArgumentException("Unspecified script root folders.");
        }
        this.schemaScriptRootFolders = schemaScriptRootFolders;
        this.databaseEngineCode = databaseEngineCode;
    }

    @Override
    public boolean isDumpRestore(String version) {
        return this.getDumprestoreFile(version).exists();
    }

    @Override
    public void markAsDumpRestorable(String version) {
        try {
            FileUtils.touch((File)this.getDumprestoreFile(version));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private File getDumprestoreFile(String version) {
        return new File(this.getDumpFolder(version), DUMP_FILENAME);
    }

    @Override
    public File getDumpFolder(String version) {
        return new File(this.getSpecificScriptFolder(this.schemaScriptRootFolders.get(this.schemaScriptRootFolders.size() - 1)), version);
    }

    @Override
    public Script tryGetSchemaScript(String version) {
        return this.tryLoadScript("schema-" + version + SQL_FILE_TYPE, version);
    }

    @Override
    public Script tryGetFunctionScript(String version) {
        return this.tryLoadScript("function-" + version + SQL_FILE_TYPE, version);
    }

    @Override
    public Script tryGetDomainsScript(String version) {
        return this.tryLoadScript("domains-" + version + SQL_FILE_TYPE, version);
    }

    @Override
    public Script tryGetGrantsScript(String version) {
        return this.tryLoadScript("grants-" + version + SQL_FILE_TYPE, version);
    }

    @Override
    public Script tryGetDataScript(String version) {
        return this.tryLoadScript("data-" + version + SQL_FILE_TYPE, version);
    }

    @Override
    public Script tryGetMigrationScript(String fromVersion, String toVersion) {
        String scriptName = "migration-" + fromVersion + "-" + toVersion + SQL_FILE_TYPE;
        return this.tryLoadScript(scriptName, toVersion, "migration");
    }

    @Override
    public Script tryGetFunctionMigrationScript(String fromVersion, String toVersion) {
        String scriptName = "function_migration-" + fromVersion + "-" + toVersion + SQL_FILE_TYPE;
        return this.tryLoadScript(scriptName, toVersion, "migration");
    }

    private Script tryLoadScript(String scriptName, String scriptVersion) {
        return this.tryLoadScript(scriptName, scriptVersion, scriptVersion);
    }

    private Script tryLoadScript(String scriptName, String scriptVersion, String prefix) {
        for (String rootFolder : this.schemaScriptRootFolders) {
            Script script = this.tryPrimLoadScript(String.valueOf(this.getSpecificScriptFolder(rootFolder)) + "/" + prefix, scriptName, scriptVersion);
            if (script != null) {
                return script;
            }
            script = this.tryPrimLoadScript(String.valueOf(this.getGenericScriptFolder(rootFolder)) + "/" + prefix, scriptName, scriptVersion);
            if (script == null) continue;
            return script;
        }
        return null;
    }

    private Script tryPrimLoadScript(String scriptFolder, String scriptName, String scriptVersion) {
        String scriptPath = String.valueOf(scriptFolder) + "/" + scriptName;
        String resource = "/" + scriptPath;
        String script = FileUtilities.loadToString(this.getClass(), resource);
        if (script == null) {
            File file = new File(scriptFolder, scriptName);
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)("Resource '" + resource + "' could not be found. Trying '" + file.getPath() + "'."));
            }
            if (!file.exists()) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug((Object)("File '" + file.getPath() + "' does not exist."));
                }
                return null;
            }
            script = FileUtilities.loadToString(file);
        }
        return new Script(scriptPath, script, scriptVersion);
    }

    private String getGenericScriptFolder(String rootFolder) {
        return String.valueOf(rootFolder) + "/" + GENERIC;
    }

    private String getSpecificScriptFolder(String rootFolder) {
        return String.valueOf(rootFolder) + "/" + this.databaseEngineCode;
    }
}

