/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.spi.util.DefaultDataObjectBinding;
import net.lemnik.eodsql.spi.util.MapDataObjectBinding;
import net.lemnik.eodsql.spi.util.TypeMapperDataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataObjectBinding<T> {
    private static final Map<Class<?>, Class<? extends DataObjectBinding<?>>> KNOWN_BINDINGS = new IdentityHashMap();
    private static Constructor<? extends DataObjectBinding> DEFAULT_BINDING_CONSTRUCTOR = null;
    public static final String[] NO_KEY_COLUMNS;
    private BindingType bindingType = BindingType.NORMAL_BINDING;
    private Class<T> objectType = null;

    private static void addStringObjectMapBinding() {
        DataObjectBinding.setDataObjectBinding(MapDataObjectBinding.getStringObjectMapObjectType(), MapDataObjectBinding.class);
        DataObjectBinding.setDataObjectBinding(Map.class, MapDataObjectBinding.class);
    }

    protected DataObjectBinding() {
    }

    private Class<T> getObjectTypeImpl(TypeVariable[] typeVariableArray) {
        for (TypeVariable typeVariable : typeVariableArray) {
            if (!typeVariable.getName().equals("T")) continue;
            Type type = typeVariable.getBounds()[0];
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (!(type instanceof Class)) continue;
            return (Class)type;
        }
        return null;
    }

    private static <T> DataObjectBinding<T> createDefaultDataObjectBinding(Class<T> clazz, BindingType bindingType) {
        if (DEFAULT_BINDING_CONSTRUCTOR != null) {
            try {
                DataObjectBinding dataObjectBinding = DEFAULT_BINDING_CONSTRUCTOR.newInstance(clazz);
                return DataObjectBinding.trySetBindingType(dataObjectBinding, bindingType);
            }
            catch (InstantiationException instantiationException) {
                throw new EoDException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EoDException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EoDException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new EoDException(invocationTargetException);
            }
        }
        if (QueryTool.getTypeMap().containsKey(clazz)) {
            return new TypeMapperDataObjectBinding<T>(QueryTool.getTypeMap().get(clazz), clazz);
        }
        DefaultDataObjectBinding.validate(clazz);
        DefaultDataObjectBinding<T> defaultDataObjectBinding = new DefaultDataObjectBinding<T>(clazz);
        return DataObjectBinding.trySetBindingType(defaultDataObjectBinding, bindingType);
    }

    private static <T> DataObjectBinding<T> trySetBindingType(DataObjectBinding<T> dataObjectBinding, BindingType bindingType) {
        if (!dataObjectBinding.setBindingType(bindingType)) {
            return null;
        }
        return dataObjectBinding;
    }

    public Class<T> getObjectType() {
        if (this.objectType == null) {
            Class<?> clazz = this.getClass();
            TypeVariable[] typeVariableArray = clazz.getTypeParameters();
            if (typeVariableArray == null || typeVariableArray.length == 0) {
                throw new IllegalArgumentException("No type parameters specified on class " + clazz.getName());
            }
            this.objectType = this.getObjectTypeImpl(typeVariableArray);
        }
        return this.objectType;
    }

    protected void setObjectType(Class<T> clazz) {
        this.objectType = clazz;
    }

    public T unmarshall(ResultSet resultSet) throws SQLException, EoDException {
        T t = this.newInstance();
        this.unmarshall(resultSet, t);
        return t;
    }

    public BindingType getBindingType() {
        return this.bindingType;
    }

    public boolean setBindingType(BindingType bindingType) {
        this.bindingType = bindingType;
        return true;
    }

    public boolean isRubberstampCapable() {
        return true;
    }

    public boolean isUpdateCapable() {
        return true;
    }

    public T newInstance() throws EoDException {
        try {
            return this.getObjectType().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EoDException("Cannot instantiate type: " + this.getObjectType().getName() + ". Make sure it has a public default constrcutor.", illegalAccessException);
        }
    }

    public String[] getKeyColumnNames() {
        return NO_KEY_COLUMNS;
    }

    public String toString() {
        switch (this.bindingType) {
            case FIRST_COLUMN_BINDING: 
            case KEYS_BINDING: {
                return this.getClass().getName() + ":" + this.objectType.getName() + Arrays.toString(this.getKeyColumnNames());
            }
        }
        return this.getClass().getName() + ":" + this.objectType.getName();
    }

    public abstract void unmarshall(ResultSet var1, T var2) throws SQLException, EoDException;

    public abstract void marshall(T var1, ResultSet var2) throws SQLException, EoDException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setDataObjectBinding(Class<T> clazz, Class<? extends DataObjectBinding<T>> clazz2) throws IllegalArgumentException {
        Object object;
        try {
            object = clazz2.getConstructor(new Class[0]);
            if (!Modifier.isPublic(((Constructor)object).getModifiers())) {
                throw new IllegalArgumentException("DataObjectBinding classes must have a default (null) constructor");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("DataObjectBinding classes must have a default (null) constructor", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("DataObjectBinding classes must have a default (null) constructor", securityException);
        }
        object = DataObjectBinding.class;
        synchronized (DataObjectBinding.class) {
            KNOWN_BINDINGS.put(clazz, clazz2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static <T> DataObjectBinding<T> getDataObjectBinding(Class<T> clazz, BindingType bindingType) throws EoDException {
        Class<DataObjectBinding<?>> clazz2 = KNOWN_BINDINGS.get(clazz);
        if (clazz2 == null) {
            return DataObjectBinding.createDefaultDataObjectBinding(clazz, bindingType);
        }
        try {
            DataObjectBinding<?> dataObjectBinding = clazz2.newInstance();
            if (dataObjectBinding.getObjectType() == null) {
                dataObjectBinding.setObjectType(clazz);
            }
            return DataObjectBinding.trySetBindingType(dataObjectBinding, bindingType);
        }
        catch (InstantiationException instantiationException) {
            throw new EoDException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EoDException(illegalAccessException);
        }
    }

    public static void setDefaultDataObjectBinding(Class<? extends DataObjectBinding> clazz) throws IllegalArgumentException {
        try {
            Constructor<? extends DataObjectBinding> constructor = clazz.getConstructor(Class.class);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("The constructor of the Default-DataObjectBinding class must be public.");
            }
            DEFAULT_BINDING_CONSTRUCTOR = constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("The Default-DataObjectBinding class must have a public Constructor(Class<?>)", noSuchMethodException);
        }
    }

    public static void validate(Class<?> clazz) throws InvalidDataTypeException {
        if (!KNOWN_BINDINGS.containsKey(clazz)) {
            if (DEFAULT_BINDING_CONSTRUCTOR != null) {
                try {
                    DEFAULT_BINDING_CONSTRUCTOR.newInstance(clazz);
                }
                catch (InstantiationException instantiationException) {
                    throw new InvalidDataTypeException("Cannot create Default-DataObjectBinding for type.", clazz);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InvalidDataTypeException("Cannot create Default-DataObjectBinding for type.", clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidDataTypeException("Cannot create Default-DataObjectBinding for type.", clazz);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof InvalidDataTypeException) {
                        throw (InvalidDataTypeException)invocationTargetException.getTargetException();
                    }
                    throw new InvalidDataTypeException("Cannot create Default-DataObjectBinding for type.", clazz);
                }
            } else if (!QueryTool.getTypeMap().containsKey(clazz)) {
                DefaultDataObjectBinding.validate(clazz);
            }
        }
    }

    static {
        DataObjectBinding.addStringObjectMapBinding();
        NO_KEY_COLUMNS = new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BindingType {
        NORMAL_BINDING,
        KEYS_BINDING,
        FIRST_COLUMN_BINDING;

    }
}

