/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.impl;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.etlserver.registrator.api.impl.AbstractTransactionalCommand;
import java.io.File;

public class MkdirsCommand
extends AbstractTransactionalCommand {
    private static final long serialVersionUID = 1L;
    private final String directoryAbsoutePath;

    public MkdirsCommand(String directoryAbsoutePath) {
        this.directoryAbsoutePath = directoryAbsoutePath;
    }

    @Override
    public void execute() {
        File src = new File(this.directoryAbsoutePath);
        IFileOperations fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        fileOperations.mkdirs(src);
    }

    @Override
    public void rollback() {
        File src = new File(this.directoryAbsoutePath);
        if (!src.exists()) {
            return;
        }
        IFileOperations fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        fileOperations.delete(src);
        if (src.exists()) {
            MkdirsCommand.getOperationLog().error((Object)("Could not delete directory '" + src + "'."));
        }
    }

    public String toString() {
        return "MkdirsCommand [directoryAbsoutePath=" + this.directoryAbsoutePath + "]";
    }
}

