/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DatastoreServiceDescriptionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionProvider;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Util;
import java.util.List;

public class ReportingPluginSelectionWidget
extends DropDownList<DatastoreServiceDescriptionModel, DatastoreServiceDescription> {
    public static final String METADATA = "Overview";
    private static final DatastoreServiceDescriptionModel METADATA_MODEL = DatastoreServiceDescriptionModel.createFakeReportingServiceModel("Overview");
    private final IViewContext<?> viewContext;

    public ReportingPluginSelectionWidget(IViewContext<?> viewContext, IIdHolder ownerIdOrNull) {
        super(viewContext, String.valueOf(ownerIdOrNull != null ? ownerIdOrNull.getId().toString() : "") + "_data-set_reporting-plugins", "button_process", "label", "report", "reports");
        this.setAutoSelectFirst(true);
        this.viewContext = viewContext;
        this.addPostRefreshCallback(this.createHideOnNoServicesAction());
    }

    private IDataRefreshCallback createHideOnNoServicesAction() {
        return new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                ListStore modelsStore = ReportingPluginSelectionWidget.this.getStore();
                if (modelsStore.getCount() > 0) {
                    ReportingPluginSelectionWidget.this.show();
                } else {
                    ReportingPluginSelectionWidget.this.hide();
                }
            }
        };
    }

    public void selectMetadataPlugin() {
        this.setValue(METADATA_MODEL);
    }

    @Override
    protected List<DatastoreServiceDescriptionModel> convertItems(List<DatastoreServiceDescription> result) {
        List<DatastoreServiceDescriptionModel> models = DatastoreServiceDescriptionModel.convert(result, null);
        models.add(0, METADATA_MODEL);
        return models;
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<DatastoreServiceDescription>> callback) {
        this.viewContext.getCommonService().listDataStoreServices(DataStoreServiceKind.QUERIES, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }

    public void setValue(DatastoreServiceDescriptionModel value) {
        DatastoreServiceDescriptionModel oldValue = (DatastoreServiceDescriptionModel)((Object)this.getValue());
        super.setValue((ModelData)value);
        if (Util.equalWithNull((Object)((Object)oldValue), (Object)((Object)value))) {
            SelectionChangedEvent se = new SelectionChangedEvent((SelectionProvider)this, this.getSelection());
            this.fireEvent(Events.SelectionChange, (BaseEvent)se);
        }
    }
}

