/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.openbis.common.spring.IUncheckedMultipartFile;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public abstract class AttachmentRegistrationHelper {
    private static final long MAX_ATTACHMENT_SIZE = 0x10000000L;

    public abstract void register(Collection<NewAttachment> var1);

    public final void process(String sessionKey, HttpSession httpSession, List<NewAttachment> attachmentsOrNull) {
        UploadedFilesBean uploadedFiles = null;
        try {
            try {
                uploadedFiles = (UploadedFilesBean)httpSession.getAttribute(sessionKey);
                this.abortIfMaxSizeExceeded(uploadedFiles);
                Map<String, NewAttachment> attachmentMap = this.createAttachmentMap(attachmentsOrNull);
                this.fillContent(uploadedFiles, attachmentMap);
                this.register(attachmentMap.values());
            }
            catch (UserFailureException e) {
                throw UserFailureExceptionTranslator.translate(e);
            }
        }
        finally {
            if (uploadedFiles != null) {
                uploadedFiles.deleteTransferredFiles();
            }
            if (httpSession != null) {
                httpSession.removeAttribute(sessionKey);
            }
        }
    }

    private Map<String, NewAttachment> createAttachmentMap(List<NewAttachment> attachmentsOrNull) {
        HashMap<String, NewAttachment> result = new HashMap<String, NewAttachment>();
        if (attachmentsOrNull != null) {
            for (NewAttachment attachment : attachmentsOrNull) {
                result.put(attachment.getFileName(), attachment);
            }
        }
        return result;
    }

    private void abortIfMaxSizeExceeded(UploadedFilesBean uploadedFiles) {
        if (uploadedFiles != null) {
            for (IUncheckedMultipartFile multipartFile : uploadedFiles.iterable()) {
                long fileSize = multipartFile.getSize();
                if (fileSize <= 0x10000000L) continue;
                String maxSizeString = FileUtilities.byteCountToDisplaySize(0x10000000L);
                String fileSizeString = FileUtilities.byteCountToDisplaySize(fileSize);
                String errorMessage = String.format("The file %s(%s) is larger than the configured maximum (%s).", multipartFile.getOriginalFilename(), fileSizeString, maxSizeString);
                throw new UserFailureException(errorMessage);
            }
        }
    }

    private void fillContent(UploadedFilesBean uploadedFiles, Map<String, NewAttachment> attachments) {
        if (uploadedFiles != null) {
            for (IUncheckedMultipartFile multipartFile : uploadedFiles.iterable()) {
                String fileName = multipartFile.getOriginalFilename();
                byte[] content = multipartFile.getBytes();
                NewAttachment attachmentOrNull = attachments.get(fileName);
                if (attachmentOrNull == null) continue;
                attachmentOrNull.setContent(content);
            }
        }
    }
}

