/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.LongArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.StringArrayMapper;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

@ShouldFlattenCollections(value=false)
public class ExperimentListPredicate
extends AbstractSpacePredicate<List<Experiment>> {
    private static final int ARRAY_SIZE_LIMIT = 999;
    private final IExperimentToSpaceQuery experimentToSpaceQuery = (IExperimentToSpaceQuery)QueryTool.getManagedQuery(IExperimentToSpaceQuery.class);

    @Override
    public String getCandidateDescription() {
        return "experiment";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<Experiment> experiments) {
        ArrayList<Long> ids = new ArrayList<Long>(experiments.size());
        ArrayList<String> permIds = new ArrayList<String>(experiments.size());
        for (Experiment experiment : experiments) {
            if (experiment.getId() == null) {
                throw new AuthorizationFailureException("id is undefined.");
            }
            ids.add(experiment.getId());
            if (experiment.getPermId() == null) {
                throw new AuthorizationFailureException("permId is undefined.");
            }
            permIds.add(experiment.getPermId());
            ExperimentIdentifier spaceIdentifier = new ExperimentIdentifierFactory(experiment.getIdentifier()).createIdentifier();
            String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceIdentifier);
            DatabaseInstancePE databaseInstance = this.getDatabaseInstance(spaceIdentifier);
            Status status = this.evaluate(person, allowedRoles, databaseInstance, spaceCode);
            if (Status.OK.equals(status)) continue;
            return status;
        }
        for (Long spaceId : this.getExperimentSpaceIds(ids, permIds)) {
            Status status = this.evaluate(person, allowedRoles, spaceId);
            if (Status.OK.equals(status)) continue;
            return status;
        }
        return Status.OK;
    }

    private Collection<Long> getExperimentSpaceIds(List<Long> ids, List<String> permIds) {
        if (ids.size() != permIds.size()) {
            throw new IllegalArgumentException("Expect to get the same number of ids and permIds.");
        }
        int size = ids.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size > 999) {
            HashSet<Long> spaceIds = new HashSet<Long>(size);
            int startIdx = 0;
            while (startIdx < size) {
                List<Long> idSubList = ids.subList(startIdx, Math.min(size, startIdx + 999));
                List<String> permIdSubList = permIds.subList(startIdx, Math.min(size, startIdx + 999));
                spaceIds.addAll(this.experimentToSpaceQuery.getExperimentSpaceIds(this.toArray(idSubList), permIdSubList.toArray(new String[permIdSubList.size()])));
                startIdx += 999;
            }
            return spaceIds;
        }
        return this.experimentToSpaceQuery.getExperimentSpaceIds(this.toArray(ids), permIds.toArray(new String[size]));
    }

    private long[] toArray(List<Long> list) {
        long[] result = new long[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = list.get(i);
            ++i;
        }
        return result;
    }

    public static interface IExperimentToSpaceQuery
    extends BaseQuery {
        @Select(sql="select distinct space_id from projects p left join experiments e on e.proj_id = p.id where e.id = any(?{1}) union select distinct space_id from projects p left join experiments e on e.proj_id = p.id where e.perm_id = any(?{2})", parameterBindings={LongArrayMapper.class, StringArrayMapper.class})
        public List<Long> getExperimentSpaceIds(long[] var1, String[] var2);
    }
}

