/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.util.ArrayList;
import java.util.List;

@ShouldFlattenCollections(value=false)
public class SampleUpdatesCollectionPredicate
extends AbstractPredicate<List<SampleUpdatesDTO>> {
    private final SampleTechIdCollectionPredicate sampleTechIdCollectionPredicate = new SampleTechIdCollectionPredicate(false);
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate();
    private final SampleOwnerIdentifierCollectionPredicate sampleOwnerIdentifierCollectionPredicate = new SampleOwnerIdentifierCollectionPredicate(false);

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.sampleTechIdCollectionPredicate.init(provider);
        this.spacePredicate.init(provider);
        this.sampleOwnerIdentifierCollectionPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "sample updates collection";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<SampleUpdatesDTO> value) {
        if (SampleUpdatesCollectionPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        IServiceConversationProgressListener progressListener = ServiceConversationsThreadContext.getProgressListener();
        ArrayList<TechId> techIds = new ArrayList<TechId>(value.size());
        ArrayList<SampleOwnerIdentifier> sampleIdentifiers = new ArrayList<SampleOwnerIdentifier>(value.size());
        int index = 0;
        for (SampleUpdatesDTO sampleUpdates : value) {
            Status result;
            ExperimentIdentifier expId;
            TechId sampleId = sampleUpdates.getSampleIdOrNull();
            if (sampleId != null) {
                techIds.add(sampleId);
            }
            if ((expId = sampleUpdates.getExperimentIdentifierOrNull()) != null && !(result = this.spacePredicate.doEvaluation(person, allowedRoles, expId)).isOK()) {
                return result;
            }
            SampleIdentifier sampleIdentifier = sampleUpdates.getSampleIdentifier();
            if (sampleIdentifier != null) {
                sampleIdentifiers.add(sampleIdentifier);
            }
            progressListener.update("authorizeSampleUpdates", value.size(), ++index);
        }
        Status result = this.sampleTechIdCollectionPredicate.doEvaluation(person, allowedRoles, techIds);
        if (!result.isOK()) {
            return result;
        }
        return this.sampleOwnerIdentifierCollectionPredicate.doEvaluation(person, allowedRoles, (List<SampleOwnerIdentifier>)sampleIdentifiers);
    }
}

