/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractDataSetBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.DataSetCodeId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.DataSetTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.IDataSetId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SourceType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.FileFormatTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewLinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.types.DataSetTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

@Friend(toClasses={DataPE.class})
public class DataBO
extends AbstractDataSetBusinessObject
implements IDataBO {
    private DataPE data;
    private DataStorePE dataStore;
    static final String DATA_SET_TYPE = "dataSetType";
    static final String PROPERTY_TYPES = "dataSetType.dataSetTypePropertyTypesInternal";

    public DataBO(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, relationshipService, conversationClient, managedPropertyEvaluatorFactory);
    }

    public DataBO(IDAOFactory daoFactory, Session exampleSession, IEntityPropertiesConverter propertiesConverter, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, exampleSession, propertiesConverter, relationshipService, conversationClient, managedPropertyEvaluatorFactory);
    }

    @Override
    public DataPE tryFindByDataSetId(IDataSetId dataSetId) {
        if (dataSetId == null) {
            throw new IllegalArgumentException("Data set id cannot be null");
        }
        if (dataSetId instanceof DataSetCodeId) {
            DataSetCodeId codeId = (DataSetCodeId)dataSetId;
            return this.getDataDAO().tryToFindDataSetByCode(codeId.getCode());
        }
        if (dataSetId instanceof DataSetTechIdId) {
            DataSetTechIdId techIdId = (DataSetTechIdId)dataSetId;
            return (DataPE)this.getDataDAO().tryGetByTechId(new TechId(techIdId.getTechId()), new String[0]);
        }
        throw new IllegalArgumentException("Unsupported data set id: " + dataSetId);
    }

    @Override
    public DataPE tryGetData() {
        return this.data;
    }

    @Override
    public DataPE getData() {
        return this.data;
    }

    @Override
    public void loadByCode(String dataSetCode) {
        this.loadByCode(dataSetCode, true, false);
    }

    private void loadByCode(String dataSetCode, boolean withPropertyTypes, boolean lockForUpdate) {
        this.data = this.getDataDAO().tryToFindFullDataSetByCode(dataSetCode, withPropertyTypes, lockForUpdate);
    }

    @Override
    public void loadDataByTechId(TechId datasetId) {
        String[] connections = new String[]{PROPERTY_TYPES, DATA_SET_TYPE};
        this.data = (DataPE)this.getDataDAO().tryGetByTechId(datasetId, connections);
        if (this.data == null) {
            throw new UserFailureException(String.format("Data set with ID '%s' does not exist.", datasetId));
        }
        HibernateUtils.initialize(this.data.getDataSetType().getDataSetTypePropertyTypes());
    }

    @Override
    public void enrichWithParentsAndExperiment() {
        if (this.data != null) {
            this.enrichWithParentsAndExperiment(this.data);
        }
    }

    @Override
    public void enrichWithChildren() {
        if (this.data != null) {
            this.enrichWithChildren(this.data);
        }
    }

    @Override
    public final void enrichWithProperties() {
        if (this.data != null) {
            HibernateUtils.initialize(this.data.getProperties());
        }
    }

    @Override
    public void enrichWithContainedDataSets() {
        if (this.data != null && this.data.isContainer()) {
            HibernateUtils.initialize(this.data.getContainedDataSets());
        }
    }

    @Override
    public void define(NewExternalData newData, SamplePE sample, SourceType sourceType) {
        assert (sample != null) : "Undefined sample.";
        boolean isContainer = newData instanceof NewContainerDataSet;
        boolean isLink = newData instanceof NewLinkDataSet;
        if (isContainer) {
            this.define((NewContainerDataSet)newData, sourceType);
        } else if (isLink) {
            this.define((NewLinkDataSet)newData, sourceType);
        } else {
            this.define(newData, sourceType);
        }
        ExperimentPE experiment = sample.getExperiment();
        RelationshipUtils.setSampleForDataSet(this.data, sample, this.session);
        RelationshipUtils.setExperimentForDataSet(this.data, experiment, this.session);
        this.setParentDataSets(experiment, newData);
    }

    @Override
    public void define(NewExternalData newData, ExperimentPE experiment, SourceType sourceType) {
        assert (experiment != null) : "Undefined experiment.";
        boolean isContainer = newData instanceof NewContainerDataSet;
        boolean isLink = newData instanceof NewLinkDataSet;
        if (isContainer) {
            this.define((NewContainerDataSet)newData, sourceType);
        } else if (isLink) {
            this.define((NewLinkDataSet)newData, sourceType);
        } else {
            this.define(newData, sourceType);
        }
        RelationshipUtils.setExperimentForDataSet(this.data, experiment, this.session);
        this.setParentDataSets(experiment, newData);
    }

    private void setParentDataSets(ExperimentPE experiment, NewExternalData newData) {
        List<String> parentDataSetCodes = newData.getParentDataSetCodes();
        HashSet<DataPE> parentsToAdd = new HashSet<DataPE>();
        if (parentDataSetCodes != null) {
            for (String parentCode : parentDataSetCodes) {
                DataPE parent = this.getOrCreateData(parentCode, experiment);
                parentsToAdd.add(parent);
            }
        }
        this.replaceParents(this.data, parentsToAdd, false);
    }

    @Override
    public void setContainedDataSets(ExperimentPE experiment, NewContainerDataSet newData) {
        List<String> containedDataSetCodes;
        SpacePE newComponentsSpace;
        SpacePE containerSpace = this.data.getSpace();
        if (!containerSpace.equals(newComponentsSpace = experiment.getProject().getSpace())) {
            throw UserFailureException.fromTemplate("Contained data sets need to be in the same space ('%s') as the container.", containerSpace.getCode());
        }
        if (experiment.equals(this.data.getExperiment()) && (containedDataSetCodes = newData.getContainedDataSetCodes()) != null) {
            PersonPE modifier = this.findPerson();
            for (String containedCode : containedDataSetCodes) {
                DataPE contained = this.getOrCreateData(containedCode, experiment);
                this.data.addComponent(contained, modifier);
                this.checkSameSpace(this.data, contained);
            }
        }
    }

    private void define(NewExternalData newData, SourceType sourceType) {
        assert (newData != null) : "Undefined data.";
        DataSetType dataSetType = newData.getDataSetType();
        assert (dataSetType != null) : "Undefined data set type.";
        FileFormatType fileFormatType = newData.getFileFormatType();
        assert (fileFormatType != null) : "Undefined file format type.";
        String location = newData.getLocation();
        assert (location != null) : "Undefined location.";
        LocatorType locatorType = newData.getLocatorType();
        assert (locatorType != null) : "Undefined location type.";
        assert (sourceType != null) : "Undefined source type.";
        ExternalDataPE externalData = new ExternalDataPE();
        externalData.setDataProducerCode(newData.getDataProducerCode());
        externalData.setProductionDate(newData.getProductionDate());
        externalData.setCode(newData.getCode());
        externalData.setDataSetType(this.getDataSetType(dataSetType, DataSetKind.PHYSICAL));
        externalData.setFileFormatType(this.getFileFomatType(fileFormatType));
        externalData.setComplete(newData.getComplete());
        externalData.setShareId(newData.getShareId());
        externalData.setLocation(location);
        externalData.setSize(newData.getSize());
        externalData.setSpeedHint(newData.getSpeedHint());
        externalData.setStorageFormatVocabularyTerm(this.tryToFindStorageFormatTerm(newData.getStorageFormat()));
        externalData.setLocatorType(this.getLocatorTypeDAO().tryToFindLocatorTypeByCode(locatorType.getCode()));
        PersonPE registrator = this.tryToGetRegistrator(newData);
        externalData.setRegistrator(registrator);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)externalData, registrator);
        this.dataStore = this.getDataStoreDAO().tryToFindDataStoreByCode(newData.getDataStoreCode());
        externalData.setDataStore(this.dataStore);
        this.defineDataSetProperties(externalData, DataBO.convertToDataSetProperties(newData.getDataSetProperties()));
        externalData.setDerived(sourceType == SourceType.DERIVED);
        this.data = externalData;
    }

    private void define(NewContainerDataSet newData, SourceType sourceType) {
        assert (newData != null) : "Undefined data.";
        DataSetType dataSetType = newData.getDataSetType();
        assert (dataSetType != null) : "Undefined data set type.";
        assert (sourceType != null) : "Undefined source type.";
        DataPE dataPE = new DataPE();
        dataPE.setDataProducerCode(newData.getDataProducerCode());
        dataPE.setProductionDate(newData.getProductionDate());
        dataPE.setCode(newData.getCode());
        dataPE.setDataSetType(this.getDataSetType(dataSetType, DataSetKind.CONTAINER));
        PersonPE registrator = this.tryToGetRegistrator(newData);
        dataPE.setRegistrator(registrator);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataPE, registrator);
        this.dataStore = this.getDataStoreDAO().tryToFindDataStoreByCode(newData.getDataStoreCode());
        dataPE.setDataStore(this.dataStore);
        this.defineDataSetProperties(dataPE, DataBO.convertToDataSetProperties(newData.getDataSetProperties()));
        dataPE.setDerived(sourceType == SourceType.DERIVED);
        this.data = dataPE;
    }

    private void define(NewLinkDataSet newData, SourceType sourceType) {
        assert (newData != null) : "Undefined data.";
        DataSetType dataSetType = newData.getDataSetType();
        assert (dataSetType != null) : "Undefined data set type.";
        assert (sourceType != null) : "Undefined source type.";
        LinkDataPE dataPE = new LinkDataPE();
        dataPE.setExternalCode(newData.getExternalCode());
        String code = newData.getExternalDataManagementSystemCode();
        ExternalDataManagementSystemPE externalDMS = this.getExternalDataManagementSystemDAO().tryToFindExternalDataManagementSystemByCode(code);
        dataPE.setExternalDataManagementSystem(externalDMS);
        dataPE.setDataProducerCode(newData.getDataProducerCode());
        dataPE.setProductionDate(newData.getProductionDate());
        dataPE.setCode(newData.getCode());
        dataPE.setDataSetType(this.getDataSetType(dataSetType, DataSetKind.LINK));
        dataPE.setRegistrator(this.tryToGetRegistrator(newData));
        this.dataStore = this.getDataStoreDAO().tryToFindDataStoreByCode(newData.getDataStoreCode());
        dataPE.setDataStore(this.dataStore);
        this.defineDataSetProperties(dataPE, DataBO.convertToDataSetProperties(newData.getDataSetProperties()));
        dataPE.setDerived(sourceType == SourceType.DERIVED);
        this.data = dataPE;
    }

    private PersonPE tryToGetRegistrator(NewExternalData newData) {
        String userId = newData.getUserId();
        if (userId != null) {
            return this.getPersonDAO().tryFindPersonByUserId(userId);
        }
        String userEMail = newData.getUserEMail();
        if (userEMail == null) {
            return null;
        }
        List<PersonPE> persons = this.getPersonDAO().listPersons();
        for (PersonPE person : persons) {
            if (!userEMail.equalsIgnoreCase(person.getEmail())) continue;
            return person;
        }
        return null;
    }

    private VocabularyTermPE tryToFindStorageFormatTerm(StorageFormat storageFormat) {
        IVocabularyDAO vocabularyDAO = this.getVocabularyDAO();
        VocabularyPE vocabulary = vocabularyDAO.tryFindVocabularyByCode("$STORAGE_FORMAT");
        Set<VocabularyTermPE> terms = vocabulary.getTerms();
        for (VocabularyTermPE term : terms) {
            if (!storageFormat.getCode().equals(term.getCode())) continue;
            return term;
        }
        return null;
    }

    private final DataSetTypePE getDataSetType(DataSetType dataSetType, DataSetKind expectedDataSetKind) {
        String dataSetTypeCode = dataSetType.getCode();
        DataSetTypePE dataSetTypeOrNull = this.getDataSetTypeDAO().tryToFindDataSetTypeByCode(dataSetTypeCode);
        if (dataSetTypeOrNull == null) {
            throw UserFailureException.fromTemplate("There is no data set type with code '%s'", dataSetTypeCode);
        }
        String dataSetKind = dataSetTypeOrNull.getDataSetKind();
        if (!dataSetKind.equals(expectedDataSetKind.toString())) {
            String dataSetKinAsString = dataSetKind.toString();
            throw new UserFailureException("Data set type " + dataSetTypeCode + " is not a " + (Object)((Object)expectedDataSetKind) + " data set type but " + (dataSetKinAsString.startsWith("E") ? "an " : "a ") + dataSetKinAsString + " data set type.");
        }
        return dataSetTypeOrNull;
    }

    private final FileFormatTypePE getFileFomatType(FileFormatType fileFormatType) {
        String fileFormatTypeCode = fileFormatType.getCode();
        FileFormatTypePE fileFormatTypeOrNull = this.getFileFormatTypeDAO().tryToFindFileFormatTypeByCode(fileFormatTypeCode);
        if (fileFormatTypeOrNull == null) {
            throw UserFailureException.fromTemplate("There is no file format type with code '%s'", fileFormatTypeCode);
        }
        return fileFormatTypeOrNull;
    }

    private final DataPE getOrCreateData(String dataSetCode, ExperimentPE experiment) {
        assert (dataSetCode != null) : "Unspecified parent data set code.";
        IDataDAO dataDAO = this.getDataDAO();
        DataPE result = dataDAO.tryToFindDataSetByCode(dataSetCode);
        if (result == null) {
            result = new DataPE();
            result.setDataStore(this.dataStore);
            result.setCode(dataSetCode);
            String code = DataSetTypeCode.UNKNOWN.getCode();
            result.setDataSetType(this.getDataSetTypeDAO().tryToFindDataSetTypeByCode(code));
            RelationshipUtils.setExperimentForDataSet(result, experiment, this.session);
            result.setPlaceholder(true);
            dataDAO.createDataSet(result, this.findPerson());
        }
        return result;
    }

    @Override
    public void save() throws UserFailureException {
        String dataCode;
        assert (this.data != null) : "Undefined external data.";
        IDataDAO dataDAO = this.getDataDAO();
        DataPE placeholder = dataDAO.tryToFindDataSetByCode(dataCode = this.data.getCode());
        if (placeholder == null) {
            dataDAO.createDataSet(this.data, this.findPerson());
        } else {
            if (!placeholder.isPlaceholder()) {
                throw new UserFailureException("Already existing data set for code '" + dataCode + "' can not be updated by data set " + placeholder);
            }
            this.validateParentsRelationshipGraph(this.data, this.data.getParents());
            if (this.data.isContainer()) {
                List<String> componentCodes = Code.extractCodes(this.data.getContainedDataSets());
                this.validateContainerRelationshipGraph(componentCodes);
            }
            this.data.setPlaceholder(false);
            this.data.setId(HibernateUtils.getId(placeholder));
            this.data.setRegistrationDate(new Date());
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)this.data, this.findPerson());
            dataDAO.updateDataSet(this.data, this.findPerson());
        }
        this.entityPropertiesConverter.checkMandatoryProperties(this.data.getProperties(), this.data.getDataSetType());
    }

    @Override
    public void addPropertiesToDataSet(String dataSetCode, List<NewProperty> properties) {
        this.loadByCode(dataSetCode);
        this.updatePropertiesPreservingExisting(properties);
        this.entityPropertiesConverter.checkMandatoryProperties(this.data.getProperties(), this.data.getDataSetType());
        this.validateAndSave();
    }

    private void updatePropertiesPreservingExisting(List<NewProperty> properties) {
        Set<DataSetPropertyPE> existingProperties = this.data.getProperties();
        Set<String> propertyUpdatesCodes = this.extractPropertyCodesToUpdate(properties, existingProperties);
        List<NewProperty> propertyUpdates = this.extractNewPropertiesToUpdate(properties, propertyUpdatesCodes);
        DataSetTypePE type = this.data.getDataSetType();
        PersonPE registrator = this.findPerson();
        this.data.setProperties(this.entityPropertiesConverter.updateProperties(existingProperties, type, Arrays.asList(DataBO.convertToDataSetProperties(propertyUpdates)), registrator, propertyUpdatesCodes));
    }

    private List<NewProperty> extractNewPropertiesToUpdate(List<NewProperty> properties, Set<String> propertiesToUpdate) {
        ArrayList<NewProperty> newPropertiesToUpdate = new ArrayList<NewProperty>();
        for (NewProperty np : properties) {
            if (!propertiesToUpdate.contains(np.getPropertyCode())) continue;
            newPropertiesToUpdate.add(np);
        }
        return newPropertiesToUpdate;
    }

    private Set<String> extractPropertyCodesToUpdate(List<NewProperty> properties, Set<DataSetPropertyPE> existingProperties) {
        HashSet<String> propertiesToUpdate = new HashSet<String>();
        for (NewProperty np : properties) {
            propertiesToUpdate.add(np.getPropertyCode());
        }
        for (DataSetPropertyPE ep : existingProperties) {
            propertiesToUpdate.remove(ep.getEntityTypePropertyType().getPropertyType().getCode());
        }
        return propertiesToUpdate;
    }

    @Override
    public void update(DataSetUpdatesDTO updates) {
        SampleIdentifier sampleIdentifierOrNull;
        this.loadDataByTechId(updates.getDatasetId());
        if (updates.getVersion() != this.data.getVersion()) {
            DataBO.throwModifiedEntityException("Data set");
        }
        if ((sampleIdentifierOrNull = updates.getSampleIdentifierOrNull()) != null) {
            this.updateSample(this.data, updates.getSampleIdentifierOrNull());
        } else {
            this.data.setSample(null);
            this.updateExperiment(this.data, updates.getExperimentIdentifierOrNull());
        }
        this.setParents(this.data, this.asListOrNull(updates.getModifiedParentDatasetCodesOrNull()));
        this.setMetaprojects(this.data, updates.getMetaprojectsOrNull());
        this.updateContainer(updates.getModifiedContainerDatasetCodeOrNull());
        this.updateComponents(updates.getModifiedContainedDatasetCodesOrNull());
        this.updateFileFormatType(this.data, updates.getFileFormatTypeCode());
        this.updateProperties(this.data.getEntityType(), updates.getProperties(), this.data, this.data);
        if (this.data.getContainer() != null) {
            this.checkSameSpace(this.data.getContainer(), this.data);
        }
        if (this.data.getContainedDataSets() != null) {
            this.checkSameSpace(this.data, this.data.getContainedDataSets());
        }
        this.entityPropertiesConverter.checkMandatoryProperties(this.data.getProperties(), this.data.getDataSetType());
        this.validateAndSave();
    }

    private List<String> asListOrNull(String[] arrayOrNull) {
        if (arrayOrNull == null) {
            return null;
        }
        return Arrays.asList(arrayOrNull);
    }

    private void validateAndSave() {
        try {
            this.getDataDAO().validateAndSaveUpdatedEntity(this.data);
        }
        catch (DataAccessException ex) {
            DataBO.throwException(ex, String.format("Data Set '%s'", this.data.getCode()));
        }
    }

    private void updateContainer(String modifiedContainerDatasetCodeOrNull) {
        if (modifiedContainerDatasetCodeOrNull == null) {
            return;
        }
        this.updateContainer(this.data, modifiedContainerDatasetCodeOrNull);
    }

    private void updateComponents(String[] modifiedContainedDatasetCodesOrNull) {
        if (modifiedContainedDatasetCodesOrNull == null) {
            return;
        }
        if (modifiedContainedDatasetCodesOrNull.length > 0 && !this.data.isContainer()) {
            throw new UserFailureException("Data set '" + this.data.getCode() + " is not a container data set, and cannot contain other data sets.");
        }
        ArrayList<DataPE> currentComponents = new ArrayList<DataPE>(this.data.getContainedDataSets());
        this.removeComponents(currentComponents);
        Set<String> currentCodes = DataBO.extractCodes(currentComponents);
        Set<String> newCodes = DataBO.asSet(this.asListOrNull(modifiedContainedDatasetCodesOrNull));
        HashSet<String> brandNewCodes = new HashSet<String>(newCodes);
        brandNewCodes.removeAll(currentCodes);
        this.validateContainerRelationshipGraph(brandNewCodes);
        Set<DataPE> newComponents = this.findDataSetsByCodes(newCodes);
        this.addComponents(newComponents);
    }

    private void validateContainerRelationshipGraph(Collection<String> componentCodes) {
        if (componentCodes.isEmpty()) {
            return;
        }
        if (componentCodes.contains(this.data.getCode())) {
            throw new UserFailureException("Data set '" + this.data.getCode() + "' cannot contain itself as a component neither directly nor via subordinate components.");
        }
        Set<DataPE> components = this.findDataSetsByCodes(componentCodes);
        for (DataPE componentDataSet : components) {
            if (!componentDataSet.isContainer()) continue;
            List<DataPE> containedDataSets = componentDataSet.getContainedDataSets();
            this.validateContainerRelationshipGraph(Code.extractCodes(containedDataSets));
        }
    }

    private void addComponents(Collection<DataPE> componentsToAdd) {
        for (DataPE component : componentsToAdd) {
            this.relationshipService.assignDataSetToContainer(this.session, component, this.data);
        }
    }

    private void removeComponents(Collection<DataPE> componentsToRemove) {
        for (DataPE component : componentsToRemove) {
            this.relationshipService.removeDataSetFromContainer(this.session, component);
        }
    }

    private final void defineDataSetProperties(DataPE dataSet, IEntityProperty[] newProperties) {
        String dataSetTypeCode = dataSet.getDataSetType().getCode();
        List properties = this.entityPropertiesConverter.convertProperties(newProperties, dataSetTypeCode, this.findPerson());
        for (DataSetPropertyPE property : properties) {
            dataSet.addProperty(property);
        }
    }

    private static IEntityProperty[] convertToDataSetProperties(List<NewProperty> list) {
        IEntityProperty[] result = new IEntityProperty[list.size()];
        int i = 0;
        while (i < list.size()) {
            result[i] = DataBO.convertProperty(list.get(i));
            ++i;
        }
        return result;
    }

    private static IEntityProperty convertProperty(NewProperty newProperty) {
        EntityProperty result = new EntityProperty();
        result.setValue(newProperty.getValue());
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(newProperty.getPropertyCode());
        result.setPropertyType(propertyType);
        return result;
    }

    @Override
    public void updateStatuses(List<String> dataSetCodes, DataSetArchivingStatus newStatus, boolean newPresentInArchive) {
        this.getDataDAO().updateDataSetStatuses(dataSetCodes, newStatus, newPresentInArchive);
    }

    @Override
    public boolean compareAndSetDataSetStatus(DataSetArchivingStatus oldStatus, DataSetArchivingStatus newStatus, boolean newPresentInArchive) {
        if (this.data == null || !this.data.isExternalData()) {
            return false;
        }
        ExternalDataPE externalData = this.data.tryAsExternalData();
        if (externalData.getStatus() != oldStatus) {
            return false;
        }
        this.updateStatuses(Arrays.asList(this.data.getCode()), newStatus, newPresentInArchive);
        return true;
    }

    @Override
    public void updateManagedProperty(IManagedProperty managedProperty) {
        Set<DataSetPropertyPE> existingProperties = this.data.getProperties();
        DataSetTypePE type = this.data.getDataSetType();
        PersonPE registrator = this.findPerson();
        this.data.setProperties(this.entityPropertiesConverter.updateManagedProperty(existingProperties, type, managedProperty, registrator));
    }

    @Override
    public void setStorageConfirmed() {
        ExternalDataPE externalData = this.data.tryAsExternalData();
        if (externalData != null) {
            externalData.setStorageConfirmation(true);
        }
    }

    @Override
    public boolean isStorageConfirmed() {
        ExternalDataPE externalData = this.data.tryAsExternalData();
        if (externalData != null) {
            return externalData.isStorageConfirmation();
        }
        return true;
    }
}

