/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.common.xml.XMLInfraStructure;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IPropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.VocabularyBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertyTypeUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.XmlUtils;
import java.util.Collections;
import javax.xml.validation.Schema;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.w3c.dom.Document;

public final class PropertyTypeBO
extends VocabularyBO
implements IPropertyTypeBO {
    private PropertyTypePE propertyTypePE;

    public PropertyTypeBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public final void define(PropertyType propertyType) throws UserFailureException {
        assert (propertyType != null) : "Unspecified property type.";
        this.propertyTypePE = new PropertyTypePE();
        this.propertyTypePE.setDatabaseInstance(this.getHomeDatabaseInstance());
        this.propertyTypePE.setCode(propertyType.getCode());
        this.propertyTypePE.setLabel(propertyType.getLabel());
        this.propertyTypePE.setDescription(propertyType.getDescription());
        DataTypePE dataTypePE = this.getDataTypeCode(propertyType.getDataType());
        this.propertyTypePE.setType(dataTypePE);
        MaterialTypePE materialType = this.tryGetMaterialType(propertyType.getMaterialType());
        this.propertyTypePE.setMaterialType(materialType);
        this.propertyTypePE.setRegistrator(this.findPerson());
        this.propertyTypePE.setManagedInternally(propertyType.isManagedInternally());
        this.propertyTypePE.setInternalNamespace(propertyType.isInternalNamespace());
        if (DataTypeCode.CONTROLLEDVOCABULARY.equals(dataTypePE.getCode())) {
            VocabularyPE vocabularyPE;
            Vocabulary vocabulary = propertyType.getVocabulary();
            if (vocabulary.getId() == null) {
                if (!StringUtils.isBlank(vocabulary.getCode())) {
                    String vocabularyCode = CodeConverter.tryToBusinessLayer(vocabulary.getCode(), vocabulary.isInternalNamespace());
                    this.tryLoad(vocabularyCode);
                }
            } else {
                this.loadVocabularyDataByTechId(TechId.create(vocabulary));
            }
            if ((vocabularyPE = this.tryGetVocabulary()) == null) {
                throw new UserFailureException("Vocabulary not selected");
            }
            this.propertyTypePE.setVocabulary(vocabularyPE);
        }
        this.propertyTypePE.setSchema(propertyType.getSchema());
        this.propertyTypePE.setTransformation(propertyType.getTransformation());
        this.validateXmlDocumentValues();
    }

    private void validateXmlDocumentValues() {
        PropertyTypeBO.validateXML(this.propertyTypePE.getSchema(), "XML Schema", XmlUtils.XML_SCHEMA_XSD_FILE_RESOURCE);
        PropertyTypeBO.validateXML(this.propertyTypePE.getTransformation(), "XSLT", XmlUtils.XSLT_XSD_FILE_RESOURCE);
    }

    private static void validateXML(String xmlValue, String xmlName, String schemaFilePath) {
        if (StringUtils.isBlank(xmlValue)) {
            return;
        }
        Document document = XmlUtils.parseXmlDocument(xmlValue);
        Schema schema = XMLInfraStructure.createSchema(schemaFilePath);
        try {
            XmlUtils.validate(document, schema);
        }
        catch (Exception e) {
            throw UserFailureException.fromTemplate("Provided %s isn't valid. %s", xmlName, e.getMessage());
        }
    }

    private MaterialTypePE tryGetMaterialType(MaterialType materialType) {
        if (materialType != null) {
            EntityTypePE entityType = this.getEntityTypeDAO(EntityKind.MATERIAL).tryToFindEntityTypeByCode(materialType.getCode());
            return (MaterialTypePE)entityType;
        }
        return null;
    }

    private DataTypePE getDataTypeCode(DataType dataType) {
        DataTypePE dataTypePE = null;
        try {
            dataTypePE = this.getPropertyTypeDAO().getDataTypeByCode(dataType.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw UserFailureException.fromTemplate("Unknow data type code '%s'.", dataType);
        }
        assert (dataTypePE != null) : "Can not be null reaching this point.";
        return dataTypePE;
    }

    @Override
    public final void save() throws UserFailureException {
        assert (this.propertyTypePE != null) : "Property type not defined.";
        try {
            this.getPropertyTypeDAO().createPropertyType(this.propertyTypePE);
        }
        catch (DataAccessException e) {
            PropertyTypeBO.throwException(e, String.format("Property type '%s'.", this.propertyTypePE.getCode()));
        }
    }

    @Override
    public void update(IPropertyTypeUpdates updates) {
        this.loadDataByTechId(TechId.create(updates));
        this.propertyTypePE.setDescription(updates.getDescription());
        this.propertyTypePE.setLabel(updates.getLabel());
        this.propertyTypePE.setSchema(updates.getSchema());
        this.propertyTypePE.setTransformation(updates.getTransformation());
        this.validateAndSave();
    }

    private void validateAndSave() {
        this.validateXmlDocumentValues();
        this.getPropertyTypeDAO().validateAndSaveUpdatedEntity(this.propertyTypePE);
    }

    @Override
    public final PropertyTypePE getPropertyType() {
        assert (this.propertyTypePE != null) : "Property type not defined.";
        return this.propertyTypePE;
    }

    @Override
    public void loadDataByTechId(TechId propertyTypeId) {
        try {
            this.propertyTypePE = (PropertyTypePE)this.getPropertyTypeDAO().getByTechId(propertyTypeId);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    private void loadVocabularyDataByTechId(TechId vocabularyId) {
        super.loadDataByTechId(vocabularyId);
    }

    @Override
    public void deleteByTechId(TechId propertyTypeId, String reason) throws UserFailureException {
        this.loadDataByTechId(propertyTypeId);
        try {
            this.getPropertyTypeDAO().delete(this.propertyTypePE);
            this.getEventDAO().persist(PropertyTypeBO.createDeletionEvent(this.propertyTypePE, this.session.tryGetPerson(), reason));
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            PropertyTypeBO.throwEntityInUseException(String.format("Property Type '%s'", this.propertyTypePE.getCode()), null);
        }
        catch (DataAccessException ex) {
            PropertyTypeBO.throwException(ex, String.format("Property Type '%s'", this.propertyTypePE.getCode()));
        }
    }

    public static EventPE createDeletionEvent(PropertyTypePE propertyTypePE, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.PROPERTY_TYPE);
        event.setIdentifiers(Collections.singletonList(propertyTypePE.getCode()));
        event.setDescription(PropertyTypeBO.getDeletionDescription(propertyTypePE));
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    private static String getDeletionDescription(PropertyTypePE propertyTypePE) {
        return String.format("%s", propertyTypePE.getCode());
    }
}

