/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.api.v1;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.plugin.query.client.api.v1.IQueryApiFacade;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.IQueryApiServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.AggregationServiceDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableModel;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.ReportDescription;
import java.util.List;
import java.util.Map;

class QueryApiFacade
implements IQueryApiFacade {
    private final IQueryApiServer service;
    private final IGeneralInformationService generalInformationService;
    private final String sessionToken;
    private final int serviceMajorVersion;
    private final int serviceMinorVersion;

    QueryApiFacade(IQueryApiServer service, IGeneralInformationService generalInformationService, String sessionToken) {
        this.service = service;
        this.generalInformationService = generalInformationService;
        this.sessionToken = sessionToken;
        this.serviceMajorVersion = this.service.getMajorVersion();
        this.serviceMinorVersion = this.service.getMinorVersion();
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void logout() {
        this.service.logout(this.sessionToken);
    }

    @Override
    public IGeneralInformationService getGeneralInformationService() {
        return this.generalInformationService;
    }

    @Override
    public List<QueryDescription> listQueries() {
        return this.service.listQueries(this.sessionToken);
    }

    @Override
    public QueryTableModel executeQuery(long queryID, Map<String, String> parameterBindings) {
        return this.service.executeQuery(this.sessionToken, queryID, parameterBindings);
    }

    @Override
    public List<ReportDescription> listTableReportDescriptions() {
        return this.service.listTableReportDescriptions(this.sessionToken);
    }

    @Override
    public QueryTableModel createReportFromDataSets(ReportDescription reportDescription, List<String> dataSetCodes) {
        return this.service.createReportFromDataSets(this.sessionToken, reportDescription.getDataStoreCode(), reportDescription.getKey(), dataSetCodes);
    }

    @Override
    public List<AggregationServiceDescription> listAggregationServices() {
        this.checkMinimalServerVersion(1, 3);
        return this.service.listAggregationServices(this.sessionToken);
    }

    @Override
    public QueryTableModel createReportFromAggregationService(AggregationServiceDescription serviceDescription, Map<String, Object> parameters) {
        this.checkMinimalServerVersion(1, 3);
        return this.service.createReportFromAggregationService(this.sessionToken, serviceDescription.getDataStoreCode(), serviceDescription.getServiceKey(), parameters);
    }

    private void checkMinimalServerVersion(int majorVersion, int minorVersion) {
        if (this.serviceMajorVersion <= majorVersion && this.serviceMinorVersion < minorVersion) {
            StringBuilder sb = new StringBuilder();
            sb.append("The service \"listAggregationServices\" is not available on this server.");
            sb.append(" Server version must be greater than 1.3");
            sb.append(" (server version is ");
            sb.append(this.serviceMajorVersion);
            sb.append(".");
            sb.append(this.serviceMinorVersion);
            throw new UnsupportedOperationException(sb.toString());
        }
    }
}

