/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveControllers;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.Files;
import de.schlichtherle.io.Streams;
import de.schlichtherle.io.util.Paths;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

public class File
extends java.io.File {
    private static final long serialVersionUID = 3617072883686191745L;
    private static final Set roots;
    private static final String uncPrefix;
    private static boolean lenient;
    private static ArchiveDetector defaultDetector;
    private final java.io.File delegate;
    private final ArchiveDetector detector;
    private transient File innerArchive;
    private String innerEntryName;
    private File enclArchive;
    private String enclEntryName;
    private transient ArchiveController controller;
    static final /* synthetic */ boolean $assertionsDisabled;

    public File(java.io.File template) {
        this(template, defaultDetector);
    }

    public File(java.io.File template, ArchiveDetector detector) {
        super(template.getPath());
        if (template instanceof File) {
            File file = (File)template;
            this.delegate = file.delegate;
            this.detector = file.detector;
            this.enclArchive = file.enclArchive;
            this.enclEntryName = file.enclEntryName;
            this.innerArchive = file.isArchive() ? this : file.innerArchive;
            this.innerEntryName = file.innerEntryName;
            this.controller = file.controller;
        } else {
            this.delegate = template;
            this.detector = detector;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(String path) {
        this(path, defaultDetector);
    }

    public File(String path, ArchiveDetector detector) {
        super(path);
        this.delegate = new java.io.File(path);
        this.detector = detector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(String parent, String child) {
        this(parent, child, defaultDetector);
    }

    public File(String parent, String child, ArchiveDetector detector) {
        super(parent, child);
        this.delegate = new java.io.File(parent, child);
        this.detector = detector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(java.io.File parent, String child) {
        this(parent, child, null);
    }

    public File(java.io.File parent, String child, ArchiveDetector detector) {
        super(parent, child);
        this.delegate = new java.io.File(parent, child);
        if (parent instanceof File) {
            File smartParent = (File)parent;
            this.detector = detector != null ? detector : smartParent.detector;
            this.init(smartParent);
        } else {
            this.detector = detector != null ? detector : defaultDetector;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public File(URI uri) {
        this(uri, (ArchiveDetector)ArchiveDetector.ALL);
    }

    File(URI uri, ArchiveDetector detector) {
        super(File.unjarFileURI(uri));
        this.delegate = new java.io.File(super.getPath());
        this.detector = detector;
        this.init(uri);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static URI unjarFileURI(URI uri) {
        try {
            String scheme = uri.getScheme();
            String ssp = Paths.normalize(uri.getSchemeSpecificPart(), '/');
            return File.unjarFileURI0(new URI(scheme, ssp, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uri + ": Not a valid (possibly jared) file URI!");
        }
    }

    private static URI unjarFileURI0(URI uri) throws URISyntaxException {
        String scheme = uri.getScheme();
        if ("jar".equalsIgnoreCase(scheme)) {
            String rssp = uri.getRawSchemeSpecificPart();
            int i = rssp.endsWith("!") ? rssp.length() - 1 : rssp.lastIndexOf("!/");
            if (i <= 0) {
                return File.unjarFileURI(new URI(rssp));
            }
            URI subURI = new URI(rssp.substring(0, i) + rssp.substring(i + 1));
            String subScheme = subURI.getScheme();
            if ("jar".equalsIgnoreCase(subScheme)) {
                URI processedSubURI = File.unjarFileURI0(subURI);
                if (processedSubURI != subURI) {
                    return processedSubURI;
                }
            } else if ("file".equalsIgnoreCase(subScheme)) {
                return subURI;
            }
        } else if ("file".equalsIgnoreCase(scheme)) {
            return uri;
        }
        throw new URISyntaxException(uri.toString(), "Not a valid (possibly jared) file URI!");
    }

    public File(java.io.File delegate, File innerArchive, ArchiveDetector detector) {
        super(delegate.getPath());
        if (!$assertionsDisabled && !File.parameters(delegate, innerArchive, detector)) {
            throw new AssertionError();
        }
        this.delegate = delegate;
        String path = delegate.getPath();
        if (innerArchive != null) {
            int innerArchivePathLength = innerArchive.getPath().length();
            if (path.length() == innerArchivePathLength) {
                this.detector = innerArchive.detector;
                this.innerArchive = this;
                this.innerEntryName = "";
                this.enclArchive = innerArchive.enclArchive;
                this.enclEntryName = innerArchive.enclEntryName;
                this.controller = ArchiveControllers.get(this);
            } else {
                this.detector = detector;
                this.innerArchive = this.enclArchive = innerArchive;
                this.innerEntryName = this.enclEntryName = path.substring(innerArchivePathLength + 1).replace(separatorChar, '/');
            }
        } else {
            this.detector = detector;
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static boolean parameters(java.io.File delegate, File innerArchive, ArchiveDetector detector) throws AssertionError {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && delegate instanceof File) {
            throw new AssertionError();
        }
        if (innerArchive != null) {
            if (!$assertionsDisabled && !innerArchive.isArchive()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !Files.contains(innerArchive.getPath(), delegate.getPath())) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && detector == null) {
            throw new AssertionError();
        }
        return true;
    }

    public File(File template, java.io.File delegate, File enclArchive) {
        super(delegate.getPath());
        if (!$assertionsDisabled && !File.parameters(template, delegate, enclArchive)) {
            throw new AssertionError();
        }
        this.delegate = delegate;
        this.detector = template.detector;
        this.enclArchive = enclArchive;
        this.enclEntryName = template.enclEntryName;
        this.innerArchive = template.isArchive() ? this : enclArchive;
        this.innerEntryName = template.innerEntryName;
        this.controller = template.controller;
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static boolean parameters(File template, java.io.File delegate, File enclArchive) throws AssertionError {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && delegate instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && template == null) {
            throw new AssertionError();
        }
        String delegatePath = delegate.getPath();
        java.io.File normalizedTemplate = Files.normalize(template);
        String normalizedTemplatePath = normalizedTemplate.getPath();
        String normalizedTemplateBase = normalizedTemplate.getName();
        if (separatorChar != '/') {
            delegatePath = delegatePath.toLowerCase();
            normalizedTemplatePath = normalizedTemplatePath.toLowerCase();
            normalizedTemplateBase = normalizedTemplateBase.toLowerCase();
        }
        if (!(".".equals(normalizedTemplateBase) || "..".equals(normalizedTemplateBase) || normalizedTemplatePath.startsWith("." + separator) || normalizedTemplatePath.startsWith(".." + separator))) {
            if (!$assertionsDisabled && !delegatePath.endsWith(normalizedTemplatePath)) {
                throw new AssertionError((Object)"delegate and template must identify the same file or directory!");
            }
            if (enclArchive != null) {
                if (!$assertionsDisabled && !enclArchive.isArchive()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !enclArchive.isParentOf(delegate)) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    private void init(File ancestor) {
        String path = super.getPath();
        if (!$assertionsDisabled && ancestor != null && !path.startsWith(ancestor.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(path)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.detector == null) {
            throw new AssertionError();
        }
        StringBuffer enclEntryNameBuf = new StringBuffer(path.length());
        this.init(ancestor, this.detector, 0, path, enclEntryNameBuf, new String[2]);
        String string = this.enclEntryName = enclEntryNameBuf.length() > 0 ? enclEntryNameBuf.toString() : null;
        if (this.innerArchive == this) {
            this.innerEntryName = "";
            this.controller = ArchiveControllers.get(this);
        } else if (this.innerArchive == this.enclArchive) {
            this.innerEntryName = this.enclEntryName;
        }
    }

    private void init(File ancestor, ArchiveDetector detector, int skip, String path, StringBuffer enclEntryNameBuf, String[] split) {
        if (path == null) {
            if (!$assertionsDisabled && this.enclArchive != null) {
                throw new AssertionError();
            }
            enclEntryNameBuf.setLength(0);
            return;
        }
        Paths.split(path, separatorChar, split);
        String parent = split[0];
        String base = split[1];
        if (base.length() != 0 && !".".equals(base)) {
            if ("..".equals(base)) {
                ++skip;
            } else if (skip > 0) {
                --skip;
            } else {
                boolean isArchive;
                if (ancestor != null) {
                    int ancestorPathLen;
                    int pathLen = path.length();
                    if (pathLen == (ancestorPathLen = ancestor.getPath().length())) {
                        this.enclArchive = ancestor.innerArchive;
                        if (!ancestor.isArchive()) {
                            if (ancestor.isEntry()) {
                                if (enclEntryNameBuf.length() > 0) {
                                    enclEntryNameBuf.insert(0, '/');
                                    enclEntryNameBuf.insert(0, ancestor.enclEntryName);
                                } else {
                                    if (!$assertionsDisabled && this.enclArchive != ancestor.enclArchive) {
                                        throw new AssertionError();
                                    }
                                    enclEntryNameBuf.append(ancestor.enclEntryName);
                                }
                            } else {
                                if (!$assertionsDisabled && this.enclArchive != null) {
                                    throw new AssertionError();
                                }
                                enclEntryNameBuf.setLength(0);
                            }
                        } else if (enclEntryNameBuf.length() <= 0) {
                            if (!$assertionsDisabled && this.enclArchive != ancestor) {
                                throw new AssertionError();
                            }
                            this.innerArchive = this;
                            this.enclArchive = ancestor.enclArchive;
                            if (ancestor.enclEntryName != null) {
                                enclEntryNameBuf.append(ancestor.enclEntryName);
                            }
                        }
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (pathLen < ancestorPathLen) {
                        detector = ancestor.detector;
                        ancestor = ancestor.enclArchive;
                    }
                }
                boolean bl = isArchive = detector.getArchiveDriver(path) != null;
                if (enclEntryNameBuf.length() > 0) {
                    if (isArchive) {
                        this.enclArchive = detector.createFile(path);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    enclEntryNameBuf.insert(0, '/');
                    enclEntryNameBuf.insert(0, base);
                } else {
                    if (isArchive) {
                        this.innerArchive = this;
                    }
                    enclEntryNameBuf.append(base);
                }
            }
        }
        this.init(ancestor, detector, skip, parent, enclEntryNameBuf, split);
    }

    private void init(URI uri) {
        if (!$assertionsDisabled && uri == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.detector == null) {
            throw new AssertionError();
        }
        this.init(uri, 0, Paths.cutTrailingSeparators(uri.getSchemeSpecificPart(), '/'), new String[2]);
        if (this.innerArchive == this) {
            this.controller = ArchiveControllers.get(this);
        }
    }

    private void init(URI uri, int skip, String path, String[] split) {
        String scheme = uri.getScheme();
        if (path == null || !"jar".equalsIgnoreCase(scheme)) {
            if (!$assertionsDisabled && this.enclArchive != null) {
                throw new AssertionError();
            }
            this.enclEntryName = null;
            return;
        }
        Paths.split(path, '/', split);
        String parent = split[0];
        String base = split[1];
        if (base.length() != 0 && !".".equals(base)) {
            if ("..".equals(base)) {
                ++skip;
            } else if (skip > 0) {
                --skip;
            } else {
                boolean isArchive;
                int baseEnd = base.length() - 1;
                boolean bl = isArchive = base.charAt(baseEnd) == '!';
                if (this.enclEntryName != null) {
                    if (isArchive) {
                        this.enclArchive = this.detector.createFile(File.createURI(scheme, path));
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                            this.innerEntryName = this.enclEntryName;
                        }
                        return;
                    }
                    this.enclEntryName = base + "/" + this.enclEntryName;
                } else if (isArchive) {
                    this.innerArchive = this;
                    this.innerEntryName = "";
                    int i = parent.indexOf(58);
                    if (!$assertionsDisabled && i < 0) {
                        throw new AssertionError();
                    }
                    scheme = parent.substring(0, i);
                    if (!$assertionsDisabled && !scheme.matches("[a-zA-Z]+")) {
                        throw new AssertionError();
                    }
                    if (i == parent.length() - 1) {
                        return;
                    }
                    uri = File.createURI(parent.substring(0, i), parent.substring(i + 1));
                    this.enclEntryName = base.substring(0, baseEnd);
                    parent = uri.getSchemeSpecificPart();
                } else {
                    this.enclEntryName = base;
                }
            }
        }
        this.init(uri, skip, parent, split);
    }

    private static URI createURI(String scheme, String ssp) throws IllegalArgumentException {
        try {
            return new URI(scheme, ssp, null);
        }
        catch (URISyntaxException syntaxError) {
            IllegalArgumentException iae = new IllegalArgumentException(syntaxError.toString());
            iae.initCause(syntaxError);
            throw iae;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if ("".equals(this.innerEntryName)) {
            if (!$assertionsDisabled && "" == this.innerEntryName) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.controller != null) {
                throw new AssertionError();
            }
            this.innerArchive = this;
            this.innerEntryName = "";
            this.controller = ArchiveControllers.get(this);
        }
        try {
            this.invariants();
        }
        catch (AssertionError ex) {
            throw (InvalidObjectException)new InvalidObjectException(((Throwable)((Object)ex)).toString()).initCause((Throwable)((Object)ex));
        }
    }

    private boolean invariants() {
        if (this.delegate == null) {
            throw new AssertionError();
        }
        if (this.delegate instanceof File) {
            throw new AssertionError();
        }
        if (!this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (this.detector == null) {
            throw new AssertionError();
        }
        if (this.innerArchive != null != (this.innerEntryName != null)) {
            throw new AssertionError();
        }
        if (this.enclArchive != null != (this.enclEntryName != null)) {
            throw new AssertionError();
        }
        if (this.enclArchive == this) {
            throw new AssertionError();
        }
        if (!((this.innerArchive == this && this.innerEntryName == "" && !this.innerEntryName.equals(this.enclEntryName) && this.controller != null) ^ (this.innerArchive == this.enclArchive && this.innerEntryName == this.enclEntryName && this.controller == null))) {
            throw new AssertionError();
        }
        if (this.enclArchive != null && (!Files.contains(this.enclArchive.getPath(), this.delegate.getParentFile().getPath()) || this.enclEntryName.length() <= 0 || separatorChar != '/' && this.enclEntryName.indexOf(separatorChar) != -1)) {
            throw new AssertionError();
        }
        return true;
    }

    public static void umount() throws ArchiveException {
        ArchiveControllers.umount("", false, true, false, true, true);
    }

    public static void umount(boolean closeStreams) throws ArchiveException {
        ArchiveControllers.umount("", false, closeStreams, false, closeStreams, true);
    }

    public static void umount(boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams) throws ArchiveException {
        ArchiveControllers.umount("", waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, true);
    }

    public static void umount(File archive) throws ArchiveException {
        File.umount(archive, false, true, false, true);
    }

    public static void umount(File archive, boolean closeStreams) throws ArchiveException {
        File.umount(archive, false, closeStreams, false, closeStreams);
    }

    public static void umount(File archive, boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams) throws ArchiveException {
        if (!archive.isArchive()) {
            throw new IllegalArgumentException(archive.getPath() + " (not an archive)");
        }
        if (archive.getEnclArchive() != null) {
            throw new IllegalArgumentException(archive.getPath() + " (not a top level archive)");
        }
        ArchiveControllers.umount(archive.getCanOrAbsPath(), waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, true);
    }

    public static void update() throws ArchiveException {
        ArchiveControllers.umount("", false, true, false, true, false);
    }

    public static void update(boolean closeStreams) throws ArchiveException {
        ArchiveControllers.umount("", false, closeStreams, false, closeStreams, false);
    }

    public static void update(boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams) throws ArchiveException {
        ArchiveControllers.umount("", waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, false);
    }

    public static void update(File archive) throws ArchiveException {
        File.update(archive, false, true, false, true);
    }

    public static void update(File archive, boolean closeStreams) throws ArchiveException {
        File.update(archive, false, closeStreams, false, closeStreams);
    }

    public static void update(File archive, boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams) throws ArchiveException {
        if (!archive.isArchive()) {
            throw new IllegalArgumentException(archive.getPath() + " (not an archive)");
        }
        if (archive.getEnclArchive() != null) {
            throw new IllegalArgumentException(archive.getPath() + " (not a top level archive)");
        }
        ArchiveControllers.umount(archive.getCanOrAbsPath(), waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, false);
    }

    public static ArchiveStatistics getLiveArchiveStatistics() {
        return ArchiveControllers.getLiveArchiveStatistics();
    }

    public static boolean isLenient() {
        return lenient;
    }

    public static void setLenient(boolean lenient) {
        File.lenient = lenient;
    }

    public static ArchiveDetector getDefaultArchiveDetector() {
        return defaultDetector;
    }

    public static void setDefaultArchiveDetector(ArchiveDetector detector) {
        if (detector == null) {
            throw new NullPointerException();
        }
        defaultDetector = detector;
    }

    public java.io.File getParentFile() {
        java.io.File parent = this.delegate.getParentFile();
        if (parent == null) {
            return null;
        }
        if (!$assertionsDisabled && !super.getName().equals(this.delegate.getName())) {
            throw new AssertionError();
        }
        if (this.enclArchive != null && this.enclArchive.getPath().length() == parent.getPath().length()) {
            if (!$assertionsDisabled && !this.enclArchive.getPath().equals(parent.getPath())) {
                throw new AssertionError();
            }
            return this.enclArchive;
        }
        return this.detector.createFile(parent, this.enclArchive);
    }

    public File getNonArchivedParentFile() {
        File enclArchive = this.enclArchive;
        return enclArchive != null ? enclArchive.getNonArchivedParentFile() : (File)this.getParentFile();
    }

    public java.io.File getAbsoluteFile() {
        File enclArchive = this.enclArchive;
        if (enclArchive != null) {
            enclArchive = (File)enclArchive.getAbsoluteFile();
        }
        return this.detector.createFile(this, this.delegate.getAbsoluteFile(), enclArchive);
    }

    public File getNormalizedAbsoluteFile() {
        File enclArchive = this.enclArchive;
        if (enclArchive != null) {
            enclArchive = enclArchive.getNormalizedAbsoluteFile();
        }
        return this.detector.createFile(this, Files.normalize(this.delegate.getAbsoluteFile()), enclArchive);
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize(this.getAbsolutePath(), separatorChar);
    }

    public File getNormalizedFile() {
        java.io.File normalizedFile = Files.normalize(this);
        if (!$assertionsDisabled && normalizedFile == null) {
            throw new AssertionError();
        }
        if (normalizedFile == this) {
            return this;
        }
        if (!$assertionsDisabled && normalizedFile instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.enclArchive != null && Files.normalize(this.enclArchive) != this.enclArchive) {
            throw new AssertionError();
        }
        return this.detector.createFile(this, normalizedFile, this.enclArchive);
    }

    public String getNormalizedPath() {
        return Paths.normalize(this.getPath(), separatorChar);
    }

    public java.io.File getCanonicalFile() throws IOException {
        File enclArchive = this.enclArchive;
        if (enclArchive != null) {
            enclArchive = (File)enclArchive.getCanonicalFile();
        }
        return this.detector.createFile(this, this.delegate.getCanonicalFile(), enclArchive);
    }

    public final File getCanOrAbsFile() {
        File enclArchive = this.enclArchive;
        if (enclArchive != null) {
            enclArchive = enclArchive.getCanOrAbsFile();
        }
        return this.detector.createFile(this, Files.getCanOrAbsFile(this.delegate), enclArchive);
    }

    public String getCanOrAbsPath() {
        return this.getCanOrAbsFile().getPath();
    }

    public final boolean isArchive() {
        return this.innerArchive == this;
    }

    public final boolean isEntry() {
        return this.enclEntryName != null;
    }

    public final File getInnerArchive() {
        return this.innerArchive;
    }

    public final String getInnerEntryName() {
        return this.innerEntryName;
    }

    public final File getEnclArchive() {
        return this.enclArchive;
    }

    public final String getEnclEntryName() {
        return this.enclEntryName;
    }

    public final ArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public final java.io.File getDelegate() {
        return this.delegate;
    }

    final ArchiveController getArchiveController() {
        if (!$assertionsDisabled && this.controller != null != this.isArchive()) {
            throw new AssertionError();
        }
        return this.controller;
    }

    public boolean isParentOf(java.io.File file) {
        String a = Files.getCanOrAbsFile(this).getPath();
        String b = Files.getCanOrAbsFile(file).getParent();
        return b != null ? Files.contains(a, b) : false;
    }

    public boolean contains(java.io.File file) {
        return Files.contains(this, file);
    }

    public static boolean contains(java.io.File a, java.io.File b) {
        return Files.contains(a, b);
    }

    public boolean isFileSystemRoot() {
        File canOrAbsFile = this.getCanOrAbsFile();
        return roots.contains(canOrAbsFile) || File.isUNC(canOrAbsFile.getPath());
    }

    public boolean isUNC() {
        return File.isUNC(this.getCanOrAbsFile().getPath());
    }

    protected static boolean isUNC(String path) {
        return path.startsWith(uncPrefix) && path.indexOf(separatorChar, 2) > 2;
    }

    public int hashCode() {
        File enclArchive = this.enclArchive;
        if (enclArchive != null) {
            return 31 * enclArchive.hashCode() + this.enclEntryName.hashCode();
        }
        return this.delegate.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof File) {
            return this.compareTo((File)other) == 0;
        }
        return super.equals(other);
    }

    public int compareTo(java.io.File other) {
        File fileEnclArchive;
        if (this == other) {
            return 0;
        }
        if (!(other instanceof File)) {
            return super.compareTo(other);
        }
        File file = (File)other;
        File enclArchive = this.enclArchive;
        if (enclArchive != null && (fileEnclArchive = file.enclArchive) != null) {
            int ret = enclArchive.compareTo(fileEnclArchive);
            if (ret == 0) {
                ret = this.enclEntryName.compareTo(file.enclEntryName);
            }
            return ret;
        }
        return super.compareTo(other);
    }

    public File getTopLevelArchive() {
        File enclArchive = this.enclArchive;
        return enclArchive != null ? enclArchive.getTopLevelArchive() : this.innerArchive;
    }

    public String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.delegate.getCanonicalPath();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getParent() {
        return this.delegate.getParent();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public URI toURI() {
        return this.delegate.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return this.delegate.toURL();
    }

    final void ensureNotVirtualRoot(String prefix) throws ArchiveController.ArchiveFileNotFoundException {
        if (this.isArchive() && (this.isDirectory() || this.exists() && !this.isFile())) {
            String msg = "virtual root directory";
            if (prefix != null) {
                msg = prefix + " " + msg;
            }
            ArchiveController archiveController = this.getArchiveController();
            archiveController.getClass();
            throw archiveController.new ArchiveController.ArchiveFileNotFoundException(msg);
        }
    }

    public boolean exists() {
        try {
            if (this.enclArchive != null) {
                return this.enclArchive.getArchiveController().exists(this.enclEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.exists();
    }

    public boolean isFile() {
        block3: {
            try {
                if (this.innerArchive != null) {
                    return this.innerArchive.getArchiveController().isFile(this.innerEntryName);
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException ex) {
                if (!this.isArchive() || !(ex.getCause() instanceof FileNotFoundException)) break block3;
                return false;
            }
        }
        return this.delegate.isFile();
    }

    public boolean isDirectory() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().isDirectory(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.isDirectory();
    }

    public Icon getOpenIcon() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().getOpenIcon(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return null;
    }

    public Icon getClosedIcon() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().getClosedIcon(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return null;
    }

    public boolean canRead() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().canRead(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.canRead();
    }

    public boolean canWrite() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().canWrite(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.canWrite();
    }

    public boolean setReadOnly() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().setReadOnly(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.setReadOnly();
    }

    public long length() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().length(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.length();
    }

    public long lastModified() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().lastModified(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.lastModified();
    }

    public boolean setLastModified(long time) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().setLastModified(this.innerEntryName, time);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.setLastModified(time);
    }

    public String[] list() {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().list(this.innerEntryName);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.list();
    }

    public String[] list(FilenameFilter filenameFilter) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().list(this.innerEntryName, filenameFilter, this);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegate.list(filenameFilter);
    }

    public java.io.File[] listFiles() {
        return this.listFiles((FilenameFilter)null, (FileFactory)this.detector);
    }

    public File[] listFiles(FileFactory factory) {
        return this.listFiles((FilenameFilter)null, factory);
    }

    public java.io.File[] listFiles(FilenameFilter filenameFilter) {
        return this.listFiles(filenameFilter, (FileFactory)this.detector);
    }

    public File[] listFiles(FilenameFilter filenameFilter, FileFactory factory) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().listFiles(this.innerEntryName, filenameFilter, this, factory);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return File.convert(this.delegate.listFiles(filenameFilter), factory);
    }

    private static File[] convert(java.io.File[] files, FileFactory factory) {
        if (files == null) {
            return null;
        }
        File[] results = new File[files.length];
        int i = files.length;
        while (0 <= --i) {
            results[i] = factory.createFile(files[i]);
        }
        return results;
    }

    public final java.io.File[] listFiles(FileFilter fileFilter) {
        return this.listFiles(fileFilter, (FileFactory)this.detector);
    }

    public File[] listFiles(FileFilter fileFilter, FileFactory factory) {
        try {
            if (this.innerArchive != null) {
                return this.innerArchive.getArchiveController().listFiles(this.innerEntryName, fileFilter, this, factory);
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return this.delegateListFiles(fileFilter, factory);
    }

    private File[] delegateListFiles(FileFilter fileFilter, FileFactory factory) {
        ArrayList<File> filteredList = new ArrayList<File>();
        String[] children = this.delegate.list();
        if (children == null) {
            return null;
        }
        int l = children.length;
        for (int i = 0; i < l; ++i) {
            String child = children[i];
            File file = factory.createFile((java.io.File)this, child);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            filteredList.add(file);
        }
        File[] list = new File[filteredList.size()];
        filteredList.toArray(list);
        return list;
    }

    public boolean createNewFile() throws IOException {
        try {
            if (this.enclArchive != null) {
                return this.enclArchive.getArchiveController().createNewFile(this.enclEntryName, File.isLenient());
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException ex) {
        }
        catch (IOException ex) {
            throw ex;
        }
        return this.delegate.createNewFile();
    }

    public boolean mkdirs() {
        if (this.innerArchive == null) {
            return this.delegate.mkdirs();
        }
        File parent = (File)this.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return this.mkdir();
    }

    public boolean mkdir() {
        block3: {
            try {
                if (this.innerArchive != null) {
                    return this.innerArchive.getArchiveController().mkdir(this.innerEntryName, File.isLenient());
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException ex) {
                if ($assertionsDisabled || !this.isArchive()) break block3;
                throw new AssertionError();
            }
        }
        return this.delegate.mkdir();
    }

    public boolean delete() {
        block3: {
            try {
                if (this.innerArchive != null) {
                    return this.innerArchive.getArchiveController().delete(this.innerEntryName);
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException ex) {
                if (!this.isArchive() || this.delegate.isDirectory() || !(ex.getCause() instanceof FileNotFoundException)) break block3;
                return false;
            }
        }
        return this.delegate.delete();
    }

    public boolean deleteAll() {
        return Files.rm_r(this);
    }

    public void deleteOnExit() {
        if (this.innerArchive == null) {
            this.delegate.deleteOnExit();
            return;
        }
        if (this.isArchive()) {
            this.isDirectory();
        }
        ArchiveControllers.ShutdownHook.deleteOnExit.add(this);
    }

    public final boolean renameTo(java.io.File dst) {
        return this.renameTo(dst, this.detector);
    }

    public boolean renameTo(java.io.File dst, ArchiveDetector detector) {
        if (!(this.innerArchive != null || dst instanceof File && ((File)dst).innerArchive != null)) {
            return this.delegate.renameTo(dst);
        }
        return !dst.exists() && Files.mv(this, dst, detector);
    }

    public boolean copyFrom(InputStream in) {
        try {
            FileOutputStream out = this.detector.createFileOutputStream(this, false);
            try {
                File.cp(in, out);
                return true;
            }
            catch (IOException ex) {
                this.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean copyFrom(java.io.File src) {
        try {
            File.cp(src, this);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File src) {
        try {
            Files.cp_r(false, src, this, this.detector, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File src, ArchiveDetector detector) {
        try {
            Files.cp_r(false, src, this, detector, detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File src, ArchiveDetector srcDetector, ArchiveDetector dstDetector) {
        try {
            Files.cp_r(false, src, this, srcDetector, dstDetector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyTo(OutputStream out) {
        try {
            FileInputStream in = this.detector.createFileInputStream(this);
            File.cp(in, out);
            return true;
        }
        catch (IOException failed) {
            return false;
        }
    }

    public boolean copyTo(java.io.File dst) {
        try {
            File.cp(this, dst);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File dst) {
        try {
            Files.cp_r(false, this, dst, this.detector, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File dst, ArchiveDetector detector) {
        try {
            Files.cp_r(false, this, dst, detector, detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File dst, ArchiveDetector srcDetector, ArchiveDetector dstDetector) {
        try {
            Files.cp_r(false, this, dst, srcDetector, dstDetector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyFrom(java.io.File src) {
        try {
            File.cp_p(src, this);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File src) {
        try {
            Files.cp_r(true, src, this, this.detector, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File src, ArchiveDetector detector) {
        try {
            Files.cp_r(true, src, this, detector, detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File src, ArchiveDetector srcDetector, ArchiveDetector dstDetector) {
        try {
            Files.cp_r(true, src, this, srcDetector, dstDetector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyTo(java.io.File dst) {
        try {
            File.cp_p(this, dst);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File dst) {
        try {
            Files.cp_r(true, this, dst, this.detector, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File dst, ArchiveDetector detector) {
        try {
            Files.cp_r(true, this, dst, detector, detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File dst, ArchiveDetector srcDetector, ArchiveDetector dstDetector) {
        try {
            Files.cp_r(true, this, dst, srcDetector, dstDetector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void cp(InputStream in, OutputStream out) throws IOException {
        Files.cp(in, out);
    }

    public static void cp(java.io.File src, java.io.File dst) throws IOException {
        Files.cp(false, src, dst);
    }

    public static void cp_p(java.io.File src, java.io.File dst) throws IOException {
        Files.cp(true, src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean catFrom(InputStream in) {
        try {
            FileOutputStream out = this.detector.createFileOutputStream(this, false);
            try {
                try {
                    Streams.cat(in, out);
                }
                finally {
                    ((OutputStream)out).close();
                }
                return true;
            }
            catch (IOException ex) {
                this.delete();
                throw ex;
            }
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean catTo(OutputStream out) {
        try {
            FileInputStream in = this.detector.createFileInputStream(this);
            try {
                Streams.cat(in, out);
            }
            finally {
                ((InputStream)in).close();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void cat(InputStream in, OutputStream out) throws IOException {
        Streams.cat(in, out);
    }

    static {
        $assertionsDisabled = !File.class.desiredAssertionStatus();
        roots = new TreeSet<java.io.File>(Arrays.asList(File.listRoots()));
        uncPrefix = separator + separator;
        lenient = !Boolean.getBoolean("de.schlichtherle.io.strict");
        defaultDetector = ArchiveDetector.DEFAULT;
    }
}

