/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collection;

import ch.systemsx.cisd.common.collection.UnmodifiableCollectionDecorator;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class UnmodifiableListDecorator<E>
extends UnmodifiableCollectionDecorator<E>
implements List<E> {
    private final List<E> getList() {
        return (List)super.getDecorated();
    }

    public UnmodifiableListDecorator(List<E> list) {
        super(list);
    }

    @Override
    public List<E> getDecorated() {
        return this.getList();
    }

    @Override
    public E get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new UnmodifiableListIterator<E>(this.getList(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new UnmodifiableListIterator<E>(this.getList(), index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new UnmodifiableListDecorator<E>(this.getList().subList(fromIndex, toIndex));
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    private static final class UnmodifiableListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> iter;

        UnmodifiableListIterator(List<E> list, int startIndex) {
            this.iter = list.listIterator(startIndex);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public E previous() {
            return this.iter.previous();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }
    }
}

