/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.gui;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

public class FileChooserUtils {
    public static File tryChooseFile(Frame parentFrame, File initialDirectory, boolean chooseDirectories) {
        if (OSUtilities.isMacOS()) {
            if (chooseDirectories) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            FileDialog fileChooser = new FileDialog(parentFrame, FileChooserUtils.getTitle(chooseDirectories));
            fileChooser.setModal(true);
            fileChooser.setMode(0);
            fileChooser.setDirectory(initialDirectory.getAbsolutePath());
            fileChooser.setVisible(true);
            String newParent = fileChooser.getDirectory();
            String newFile = fileChooser.getFile();
            if (chooseDirectories) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            if (newFile != null) {
                return new File(newParent, newFile);
            }
            return null;
        }
        JFileChooser fileChooser = new JFileChooser(initialDirectory);
        fileChooser.setFileSelectionMode(chooseDirectories ? 1 : 0);
        fileChooser.setDialogTitle(FileChooserUtils.getTitle(chooseDirectories));
        int returnVal = fileChooser.showOpenDialog(parentFrame);
        if (returnVal == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static File tryChooseFileOrDirectory(Frame parentFrame, File initialDirectoryOrNull) {
        File initialDirectory = initialDirectoryOrNull != null ? initialDirectoryOrNull : new File(System.getProperty("user.home"));
        JFileChooser fileChooser = new JFileChooser(initialDirectory);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle("Select a directory or file");
        int returnVal = fileChooser.showOpenDialog(parentFrame);
        if (returnVal == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private static String getTitle(boolean chooseDirectories) {
        return "Select a " + (chooseDirectories ? "Directory" : "File");
    }
}

