/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.image;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.EnumSet;

public class IntensityRescaling {
    private static final int MAX_USHORT = 65535;

    private static int getGrayIntensity(BufferedImage image, int x, int y) {
        return image.getRaster().getSample(x, y, 0);
    }

    private static int getBitShiftLowerThanThreshold(int[] b0, float pixels, float threshold) {
        int shift = b0.length - 1;
        while (shift >= 0 && (float)b0[shift] / pixels < threshold) {
            --shift;
        }
        return shift + 1;
    }

    public static int computeBitShift(BufferedImage image, float threshold) {
        if (IntensityRescaling.isNotGrayscale(image)) {
            throw new IllegalArgumentException("computeBitShift() is only applicable to gray scale images.");
        }
        float pixels = image.getWidth() * image.getHeight();
        int[] b0 = new int[image.getColorModel().getPixelSize() - 8];
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int intensity = IntensityRescaling.getGrayIntensity(image, x, y);
                int b = 0;
                while (b < b0.length) {
                    if ((intensity >>> b + 8 & 1) == 1) {
                        int n = b;
                        b0[n] = b0[n] + 1;
                    }
                    ++b;
                }
                ++x;
            }
            ++y;
        }
        return IntensityRescaling.getBitShiftLowerThanThreshold(b0, pixels, threshold);
    }

    public static boolean isNotGrayscale(BufferedImage image) {
        return image.getColorModel().getColorSpace().getNumComponents() > 1;
    }

    public static EnumSet<Channel> getUsedRgbChannels(BufferedImage image) {
        EnumSet<Channel> channels = EnumSet.noneOf(Channel.class);
        if (image.getType() != 1 && image.getType() != 2) {
            return channels;
        }
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int rgb = image.getRGB(x, y);
                if ((rgb >> 16 & 0xFF) > 0) {
                    channels.add(Channel.RED);
                }
                if ((rgb >> 8 & 0xFF) > 0) {
                    channels.add(Channel.GREEN);
                }
                if ((rgb & 0xFF) > 0) {
                    channels.add(Channel.BLUE);
                }
                ++x;
            }
            ++y;
        }
        return channels;
    }

    public static BufferedImage rescaleIntensityBitShiftTo8Bits(BufferedImage image, float threshold) {
        return IntensityRescaling.rescaleIntensityBitShiftTo8Bits(image, IntensityRescaling.computeBitShift(image, threshold));
    }

    public static BufferedImage rescaleIntensityBitShiftTo8Bits(BufferedImage image, int shiftBits) {
        return IntensityRescaling.rescaleIntensityBitShiftTo8Bits(new GrayscalePixels(image), shiftBits);
    }

    public static BufferedImage rescaleIntensityBitShiftTo8Bits(GrayscalePixels image, int shiftBits) {
        BufferedImage rescaledImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        WritableRaster raster = rescaledImage.getRaster();
        int[] pixelData = image.getPixelData();
        int offset = 0;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int intensity = Math.min(255, pixelData[offset++] >>> shiftBits);
                raster.setSample(x, y, 0, intensity);
                ++x;
            }
            ++y;
        }
        return rescaledImage;
    }

    public static void addToLevelStats(PixelHistogram histogram, BufferedImage image) {
        GrayscalePixels pixels = new GrayscalePixels(image);
        IntensityRescaling.addToLevelStats(histogram, pixels);
    }

    public static void addToLevelStats(PixelHistogram histogram, GrayscalePixels pixels) {
        int[] histogramArray = histogram.histogram;
        int[] pixelData = pixels.getPixelData();
        int numberOfPixels = pixels.getNumberOfPixels();
        int i = 0;
        while (i < numberOfPixels) {
            int n = pixelData[i];
            histogramArray[n] = histogramArray[n] + 1;
            ++i;
        }
        histogram.pixelCount += numberOfPixels;
    }

    public static Levels computeLevels(PixelHistogram histogram, float threshold) {
        int intThreshold = Math.round(threshold * (float)histogram.pixelCount);
        int min = -1;
        int sum = 0;
        while (sum <= intThreshold) {
            sum += histogram.histogram[++min];
        }
        if (min < 0) {
            min = 0;
        }
        int max = 65536;
        sum = 0;
        while (sum <= intThreshold) {
            sum += histogram.histogram[--max];
        }
        if (max > 65535) {
            max = 65535;
        }
        return new Levels(min, max);
    }

    public static Levels computeLevels(BufferedImage image, float threshold) {
        return IntensityRescaling.computeLevels(new GrayscalePixels(image), threshold);
    }

    public static Levels computeLevels(GrayscalePixels image, float threshold) {
        PixelHistogram stats = new PixelHistogram();
        IntensityRescaling.addToLevelStats(stats, image);
        return IntensityRescaling.computeLevels(stats, threshold);
    }

    public static BufferedImage rescaleIntensityLevelTo8Bits(BufferedImage image, Levels levels) {
        return IntensityRescaling.rescaleIntensityLevelTo8Bits(new GrayscalePixels(image), levels);
    }

    public static BufferedImage rescaleIntensityLevelTo8Bits(BufferedImage image, Levels levels, Channel channel) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage rescaledImage = new BufferedImage(width, height, 1);
        WritableRaster rescaledRaster = rescaledImage.getRaster();
        float dynamicRange = 255.0f / (float)(levels.maxLevel - levels.minLevel);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int originalIntensity = image.getRGB(x, y) >> channel.getShift() & 0xFF;
                int intensity = Math.min(levels.maxLevel, originalIntensity);
                intensity = Math.max(0, intensity - levels.minLevel);
                intensity = (int)(0.5 + (double)((float)intensity * dynamicRange));
                rescaledRaster.setSample(x, y, channel.getBand(), intensity);
                ++x;
            }
            ++y;
        }
        return rescaledImage;
    }

    public static BufferedImage rescaleIntensityLevelTo8Bits(GrayscalePixels image, Levels levels) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage rescaledImage = new BufferedImage(width, height, 10);
        WritableRaster rescaledRaster = rescaledImage.getRaster();
        int[] pixelData = image.getPixelData();
        float dynamicRange = 255.0f / (float)(levels.maxLevel - levels.minLevel);
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int originalIntensity = pixelData[offset++];
                int intensity = Math.min(levels.maxLevel, originalIntensity);
                intensity = Math.max(0, intensity - levels.minLevel);
                intensity = (int)(0.5 + (double)((float)intensity * dynamicRange));
                rescaledRaster.setSample(x, y, 0, intensity);
                ++x;
            }
            ++y;
        }
        return rescaledImage;
    }

    public static enum Channel {
        RED(0, 16),
        GREEN(1, 8),
        BLUE(2, 0);

        private int band;
        private int shift;

        private Channel(int band, int shift) {
            this.band = band;
            this.shift = shift;
        }

        public int getShift() {
            return this.shift;
        }

        public int getBand() {
            return this.band;
        }
    }

    public static class GrayscalePixels {
        private final int width;
        private final int height;
        private final int[] pixelData;

        public GrayscalePixels(BufferedImage image) {
            if (IntensityRescaling.isNotGrayscale(image)) {
                throw new IllegalArgumentException("This is not gray scale image, some image transformations cannot be applied to it.");
            }
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.pixelData = new int[this.width * this.height];
            image.getRaster().getSamples(0, 0, this.width, this.height, 0, this.pixelData);
        }

        public int getPixel(int x, int y) {
            return this.pixelData[x + y * this.width];
        }

        public int[] getPixelData() {
            return this.pixelData;
        }

        public int getNumberOfPixels() {
            return this.width * this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class Levels {
        final int minLevel;
        final int maxLevel;

        public Levels(int minLevel, int maxLevel) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public String toString() {
            return "MinMax [minLevel=" + this.minLevel + ", maxLevel=" + this.maxLevel + "]";
        }
    }

    public static class PixelHistogram {
        final int[] histogram = new int[65536];
        int pixelCount = 0;

        public int getPixelCount() {
            return this.pixelCount;
        }

        public int[] getHistogram() {
            return this.histogram;
        }
    }
}

