/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="data_types", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
public final class DataTypePE
implements IIdHolder,
Serializable,
Comparable<DataTypePE> {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private DataTypeCode code;
    private String description;

    @Override
    @SequenceGenerator(name="DATA_TYPE_ID_SEQ", sequenceName="DATA_TYPE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_TYPE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @Column(name="code")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @NotNull(message="Code can not be null.")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Enumerated(value=EnumType.STRING)
    public final DataTypeCode getCode() {
        return this.code;
    }

    public final void setCode(DataTypeCode code) {
        this.code = code;
    }

    @NotNull(message="Description can not be null.")
    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataTypePE)) {
            return false;
        }
        DataTypePE that = (DataTypePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }

    @Override
    public final int compareTo(DataTypePE o) {
        return this.getCode().name().compareTo(o.getCode().name());
    }
}

