/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.JythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.AbstractCommonPropertyBasedHotDeployPluginFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.JythonManagedPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IManagedPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IManagedPropertyHotDeployEvaluator;

public class ManagedPropertyEvaluatorFactory
extends AbstractCommonPropertyBasedHotDeployPluginFactory<IManagedPropertyHotDeployEvaluator>
implements IManagedPropertyEvaluatorFactory {
    public ManagedPropertyEvaluatorFactory(String pluginDirectoryPath) {
        super(pluginDirectoryPath);
    }

    @Override
    public IManagedPropertyEvaluator createManagedPropertyEvaluator(EntityTypePropertyTypePE entityTypePropertyTypePE) {
        ScriptPE scriptPE = entityTypePropertyTypePE.getScript();
        assert (scriptPE != null && scriptPE.getScriptType() == ScriptType.MANAGED_PROPERTY);
        return this.getManagedPropertyEvaluator(scriptPE.getPluginType(), scriptPE.getName(), scriptPE.getScript());
    }

    @Override
    public IManagedPropertyEvaluator createManagedPropertyEvaluator(EntityTypePropertyType<?> entityTypePropertyType) {
        Script script = entityTypePropertyType.getScript();
        return this.getManagedPropertyEvaluator(script.getPluginType(), script.getName(), script.getScript());
    }

    private IManagedPropertyEvaluator getManagedPropertyEvaluator(PluginType pluginType, String scriptName, String scriptBody) {
        switch (pluginType) {
            case JYTHON: {
                return ManagedPropertyEvaluatorFactory.createJythonManagedPropertyEvaluator(scriptBody);
            }
            case PREDEPLOYED: {
                IManagedPropertyEvaluator managedPropertyEvaluator = (IManagedPropertyEvaluator)this.tryGetPredeployedPluginByName(scriptName);
                if (managedPropertyEvaluator == null) {
                    throw new UserFailureException("Couldn't find plugin named '" + scriptName + "'.");
                }
                return managedPropertyEvaluator;
            }
        }
        return null;
    }

    private static JythonManagedPropertyEvaluator createJythonManagedPropertyEvaluator(String script) {
        if (JythonEvaluatorPool.INSTANCE != null) {
            return new JythonManagedPropertyEvaluator(JythonEvaluatorPool.INSTANCE.getManagedPropertiesRunner(script));
        }
        return new JythonManagedPropertyEvaluator(script);
    }

    @Override
    protected String getPluginDescription() {
        return "managed property evaluator";
    }

    @Override
    protected Class<IManagedPropertyHotDeployEvaluator> getPluginClass() {
        return IManagedPropertyHotDeployEvaluator.class;
    }

    @Override
    protected ScriptType getScriptType() {
        return ScriptType.MANAGED_PROPERTY;
    }

    @Override
    protected String getDefaultPluginSubDirName() {
        return "managed-properties";
    }
}

