/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VocabularyTermTranslator {
    public static VocabularyTerm translate(VocabularyTermPE vt) {
        if (vt == null) {
            return null;
        }
        VocabularyTerm result = new VocabularyTerm();
        result.setId(HibernateUtils.getId(vt));
        result.setCode(vt.getCode());
        result.setLabel(vt.getLabel());
        result.setDescription(vt.getDescription());
        result.setOrdinal(vt.getOrdinal());
        result.setUrl(vt.getUrl());
        result.setOfficial(vt.isOfficial());
        result.setRegistrationDate(vt.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(vt.getRegistrator()));
        return result;
    }

    public static List<VocabularyTerm> translateTermsList(Collection<VocabularyTermPE> terms) {
        ArrayList<VocabularyTerm> result = new ArrayList<VocabularyTerm>();
        for (VocabularyTermPE term : terms) {
            result.add(VocabularyTermTranslator.translate(term));
        }
        Collections.sort(result, new Comparator<VocabularyTerm>(){

            @Override
            public int compare(VocabularyTerm arg0, VocabularyTerm arg1) {
                return arg0.getOrdinal().compareTo(arg1.getOrdinal());
            }
        });
        return result;
    }

    public static Set<VocabularyTerm> translateTerms(Set<VocabularyTermPE> terms) {
        HashSet<VocabularyTerm> result = new HashSet<VocabularyTerm>();
        for (VocabularyTermPE term : terms) {
            result.add(VocabularyTermTranslator.translate(term));
        }
        return result;
    }

    public static List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats> translate(Collection<VocabularyTermWithStats> terms) {
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats> result = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats>();
        for (VocabularyTermWithStats term : terms) {
            result.add(VocabularyTermTranslator.translate(term));
        }
        return result;
    }

    private static ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats translate(VocabularyTermWithStats term) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats result = new ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermWithStats(VocabularyTermTranslator.translate(term.getTerm()));
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind[] entityKindArray = ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind.values();
        int n = entityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind entityKind = entityKindArray[n2];
            result.registerUsage(entityKind, term.getUsageCounter(VocabularyTermTranslator.translate(entityKind)));
            ++n2;
        }
        return result;
    }

    private static EntityKind translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind entityKind) {
        EntityKind origEntityKind = EntityKind.valueOf(entityKind.name());
        return origEntityKind;
    }
}

