/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class WebClientFilesUpdater {
    @Private
    static final String SOURCE_TAG_TEMPLATE = "<source path=\"plugin/%1$s/client/web/client\"/>\n    <source path=\"plugin/%1$s/shared/basic\"/>";
    @Private
    static final String SCRIPT_TAG_TEMPLATE = "<script src=\"%s-dictionary.js\"/>";
    @Private
    static final String PUBLIC_TAG_TEMPLATE = "<public path=\"plugin/%s/client/web/public\"/>";
    @Private
    static final String JAVA_MARKER_START = "// Automatically generated part - START";
    @Private
    static final String XML_MARKER_START = "<!-- Automatically generated part - START -->";
    @Private
    static final String JAVA_MARKER_END = "// Automatically generated part - END";
    @Private
    static final String XML_MARKER_END = "<!-- Automatically generated part - END -->";
    @Private
    static final String PLUGIN_FACTORY_CLASS_NAME_TEMPLATE = "ch.systemsx.cisd.openbis.plugin.%s.client.web.client.application.ClientPluginFactory";
    @Private
    static final String PLUGIN_FACTORY_REGISTRATION_TEMPLATE = "registerPluginFactory(new ch.systemsx.cisd.openbis.plugin.%s.client.web.client.application.ClientPluginFactory(originalViewContext));";
    @Private
    static final String PLUGIN_PACKAGE_NAME = "plugin";
    @Private
    static final String CLIENT_PLUGIN_PROVIDER_CLASS = "ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.DefaultClientPluginFactoryProvider";
    @Private
    static final String OPENBIS_GWT_XML_FILE_NAME = "OpenBIS-without-entry-point.gwt.xml";
    @Private
    static final String OPENBIS_PACKAGE_NAME = "ch/systemsx/cisd/openbis";
    private final String[] allTechnologies;
    private final String[] technologies;
    private final File workingDirectory;

    @Private
    WebClientFilesUpdater(String workingDirectory, String ... technologies) {
        assert (workingDirectory != null) : "Unspecified working directory.";
        this.workingDirectory = WebClientFilesUpdater.getWorkingDirectory(workingDirectory);
        this.allTechnologies = WebClientFilesUpdater.scanAllTechnologies(this.workingDirectory);
        this.technologies = WebClientFilesUpdater.getTechnologies(this.allTechnologies, technologies);
        Arrays.sort(this.technologies);
    }

    private static final void checkTechnologies(String[] allTechnologies, String[] technologies) {
        String[] stringArray = technologies;
        int n = technologies.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            if (ArrayUtils.indexOf((Object[])allTechnologies, (Object)technology) < 0) {
                throw new IllegalArgumentException(String.format("Technology '%s' must be one of '%s'.", technology, Arrays.toString(allTechnologies)));
            }
            ++n2;
        }
    }

    private static final File getWorkingDirectory(String workingDirectory) {
        return workingDirectory == null ? new File(".") : new File(workingDirectory);
    }

    private static final String[] getTechnologies(String[] allTechnologies, String[] technologies) {
        if (technologies == null || technologies.length == 0) {
            return allTechnologies;
        }
        WebClientFilesUpdater.checkTechnologies(allTechnologies, technologies);
        return technologies;
    }

    private static final String[] scanAllTechnologies(File rootDirectory) {
        File pluginRootDirectory = WebClientFilesUpdater.getPluginRootDirectory(rootDirectory);
        File[] pluginDirs = pluginRootDirectory.listFiles((FileFilter)FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.directoryFileFilter()));
        return FileUtilities.toFileNames(pluginDirs);
    }

    private static final File getPluginRootDirectory(File rootDirectory) {
        File openBISPackage = new File(rootDirectory, "ch/systemsx/cisd/openbis/plugin");
        String response = FileUtilities.checkDirectoryFullyAccessible(openBISPackage, "openBIS package");
        if (response != null) {
            throw new RuntimeException(response);
        }
        return openBISPackage;
    }

    private static final StringBuilder createTag(String template, String indent, String technology) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent);
        builder.append(String.format(template, technology));
        builder.append("\n");
        return builder;
    }

    public final void updateOpenBISGwtXmlFile() {
        File openBISGwtXmlFile = new File(this.workingDirectory, "ch/systemsx/cisd/openbis/OpenBIS-without-entry-point.gwt.xml");
        String response = FileUtilities.checkFileFullyAccessible(openBISGwtXmlFile, "xml");
        if (response != null) {
            throw new RuntimeException(response);
        }
        StringBuilder builder = new StringBuilder(XML_MARKER_START);
        builder.append("\n");
        String indent = StringUtils.repeat((String)" ", (int)4);
        boolean first = true;
        String[] stringArray = this.technologies;
        int n = this.technologies.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            if (!first) {
                builder.append("\n");
            }
            first = false;
            builder.append(indent);
            builder.append(String.format("<!-- %s plugin -->", StringUtils.capitalize((String)technology)));
            builder.append("\n");
            builder.append((CharSequence)WebClientFilesUpdater.createTag(SCRIPT_TAG_TEMPLATE, indent, technology));
            builder.append((CharSequence)WebClientFilesUpdater.createTag(PUBLIC_TAG_TEMPLATE, indent, technology));
            builder.append((CharSequence)WebClientFilesUpdater.createTag(SOURCE_TAG_TEMPLATE, indent, technology));
            ++n2;
        }
        builder.append(indent);
        String content = FileUtilities.loadToString(openBISGwtXmlFile);
        content = String.valueOf(content.substring(0, content.indexOf(XML_MARKER_START))) + builder.toString() + content.substring(content.indexOf(XML_MARKER_END), content.length());
        FileUtilities.writeToFile(openBISGwtXmlFile, content);
    }

    public final void updateClientPluginProvider() {
        File clientPluginProviderJavaFile = new File(this.workingDirectory, String.valueOf(CLIENT_PLUGIN_PROVIDER_CLASS.replace(".", "/")) + ".java");
        String response = FileUtilities.checkFileFullyAccessible(clientPluginProviderJavaFile, "java");
        if (response != null) {
            throw new RuntimeException(response);
        }
        StringBuilder builder = new StringBuilder(JAVA_MARKER_START);
        builder.append("\n");
        String indent = StringUtils.repeat((String)" ", (int)8);
        String[] stringArray = this.technologies;
        int n = this.technologies.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            if (!technology.equals("generic")) {
                try {
                    Class.forName(String.format(PLUGIN_FACTORY_CLASS_NAME_TEMPLATE, technology));
                }
                catch (ClassNotFoundException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
                builder.append(indent);
                builder.append(String.format(PLUGIN_FACTORY_REGISTRATION_TEMPLATE, technology));
                builder.append("\n");
            }
            ++n2;
        }
        builder.append(indent);
        String content = FileUtilities.loadToString(clientPluginProviderJavaFile);
        content = String.valueOf(content.substring(0, content.indexOf(JAVA_MARKER_START))) + builder.toString() + content.substring(content.indexOf(JAVA_MARKER_END), content.length());
        FileUtilities.writeToFile(clientPluginProviderJavaFile, content);
    }

    public static void main(String[] args) {
        String[] technologies;
        String workingDirectory;
        int len = args.length;
        switch (len) {
            case 0: {
                workingDirectory = null;
                technologies = null;
                break;
            }
            default: {
                workingDirectory = args[0];
                technologies = new String[len - 1];
                int i = 1;
                while (i < len) {
                    technologies[i - 0] = args[i];
                    ++i;
                }
                break block0;
            }
        }
        WebClientFilesUpdater webClientFilesUpdater = new WebClientFilesUpdater(workingDirectory, technologies);
        webClientFilesUpdater.updateOpenBISGwtXmlFile();
        System.out.println(String.format("'%s' has been updated.", OPENBIS_GWT_XML_FILE_NAME));
        webClientFilesUpdater.updateClientPluginProvider();
        System.out.println(String.format("'%s' has been updated.", CLIENT_PLUGIN_PROVIDER_CLASS));
    }
}

