/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.ClosableURLClassLoader;
import ch.ethz.cisd.hotdeploy.Plugin;
import ch.ethz.cisd.hotdeploy.PluginDescriptor;
import ch.ethz.cisd.hotdeploy.PluginInfo;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class PluginDeploymentDesc {
    private final Log log = LogFactory.getLog(PluginDeploymentDesc.class);
    private final File pluginArchive;
    private final boolean requirePluginInfo;
    private ClosableURLClassLoader classLoader;
    private PluginDescriptor pluginDesc;

    PluginDeploymentDesc(File pluginArchive, boolean requirePluginInfo) {
        this.pluginArchive = pluginArchive;
        this.requirePluginInfo = requirePluginInfo;
        this.classLoader = null;
        this.pluginDesc = null;
        this.reload();
    }

    boolean reload() {
        try {
            this.unload();
            this.classLoader = new ClosableURLClassLoader(this.pluginArchive.getAbsolutePath(), this.getClass().getClassLoader());
            String pluginClassname = this.tryLoadingFromJar(this.pluginArchive);
            if (pluginClassname == null) {
                this.unload();
            } else {
                long lastModified = this.pluginArchive.lastModified();
                Class<?> pluginClass = this.classLoader.loadClass(pluginClassname);
                this.pluginDesc = new PluginDescriptor(pluginClass, this.pluginArchive, lastModified);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("error loading plugin: " + e.getMessage()), (Throwable)e);
            this.unload();
        }
        return this.pluginDesc != null;
    }

    void unload() {
        try {
            if (this.classLoader != null) {
                this.classLoader.close();
            }
            this.classLoader = null;
            this.pluginDesc = null;
        }
        catch (Exception e) {
            this.log.error((Object)("Failure while unloading plugin: " + e.getMessage()), (Throwable)e);
        }
    }

    boolean isLoaded() {
        return this.pluginDesc != null;
    }

    boolean hasChanged() {
        return this.pluginDesc == null ? false : this.pluginDesc.hasPluginArchiveChanged();
    }

    Class<?> getPluginClass() {
        return this.pluginDesc == null ? null : this.pluginDesc.getPluginClass();
    }

    File getPluginArchive() {
        return this.pluginArchive;
    }

    boolean updatePluginIfChanged() {
        try {
            if (this.hasChanged()) {
                if (this.reload()) {
                    this.log.info((Object)("reload archive " + this.pluginArchive.getName()));
                    return true;
                }
                this.log.warn((Object)("reload archive " + this.pluginArchive.getName() + " failed."));
                return false;
            }
            return false;
        }
        catch (RuntimeException ex) {
            this.log.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace();
            return false;
        }
    }

    synchronized Class<?> checkAndGetPluginClass() {
        try {
            if (this.hasChanged()) {
                if (this.reload()) {
                    this.log.info((Object)("reload archive " + this.pluginArchive.getName()));
                } else {
                    this.log.warn((Object)("reload archive " + this.pluginArchive.getName() + " failed."));
                }
            }
            return this.pluginDesc == null ? null : this.pluginDesc.getPluginClass();
        }
        catch (RuntimeException ex) {
            this.log.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    private boolean isPluginClass(String className) throws ClassNotFoundException {
        Class<?> clazz = this.classLoader.loadClass(className);
        if (clazz.isInterface()) {
            return false;
        }
        return this.requirePluginInfo ? this.hasValidPluginInfo(clazz) : Plugin.class.isAssignableFrom(clazz) || this.hasValidPluginInfo(clazz);
    }

    private boolean hasValidPluginInfo(Class<?> clazz) {
        PluginInfo info = clazz.getAnnotation(PluginInfo.class);
        if (info == null) {
            return false;
        }
        boolean validType = info.pluginType().isAssignableFrom(clazz);
        if (!validType) {
            this.log.warn((Object)("plugin " + clazz.getName() + " does not implement its plugin type " + info.pluginType() + " - ignored"));
        }
        return validType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryLoadingFromJar(File jar) throws Exception {
        String pluginClassname = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String resource_name = entry.getName();
                if (!resource_name.endsWith(".class")) continue;
                String className = resource_name.substring(0, resource_name.lastIndexOf(".class"));
                if (!this.isPluginClass(className = className.replace('/', '.'))) continue;
                pluginClassname = className;
                break;
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return pluginClassname;
    }

    PluginDescriptor getPluginDesc() {
        return this.pluginDesc;
    }

    ClosableURLClassLoader getClassLoader() {
        return this.classLoader;
    }
}

