/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDeletionCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "delete";
    private static FileDeletionCommand instance;
    private Parameters parameters;
    private static final Pattern FILE_ID_LINK_PATTERN;

    static {
        FILE_ID_LINK_PATTERN = Pattern.compile("fileId=([0-9]+)");
    }

    private FileDeletionCommand() {
        super(NAME);
    }

    @Override
    protected Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters(this.arguments);
        }
        return this.parameters;
    }

    public static final synchronized FileDeletionCommand getInstance() {
        if (instance == null) {
            instance = new FileDeletionCommand();
        }
        return instance;
    }

    @Override
    protected boolean isHelpRequest(String[] args) {
        this.arguments = args;
        return this.getParameters().isHelpRequest();
    }

    @Override
    protected int execute(String sessionToken, ICIFEXComponent cifex, String[] args) throws UserFailureException, EnvironmentFailureException {
        cifex.deleteFile(sessionToken, this.getParameters().getFileID());
        System.out.printf("File with id %d successfully deleted from server.\n", this.getParameters().getFileID());
        return 0;
    }

    private static class Parameters
    extends MinimalParameters {
        private long fileID;

        public Parameters(String[] args) {
            super(args, FileDeletionCommand.NAME, "<cifex_file_id or cifex_link>");
            if (this.getArgs().size() != 1) {
                this.printHelp(true);
            }
            String fileIdStr = this.getArgs().get(0);
            try {
                this.fileID = Long.parseLong(fileIdStr);
            }
            catch (NumberFormatException numberFormatException) {
                Matcher fileIdLinkMatcher = FILE_ID_LINK_PATTERN.matcher(fileIdStr);
                if (fileIdLinkMatcher.find()) {
                    this.fileID = Long.parseLong(fileIdLinkMatcher.group(1));
                }
                this.printHelp(true);
            }
        }

        public long getFileID() {
            return this.fileID;
        }
    }
}

