/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.FileItem;
import ch.systemsx.cisd.cifex.rpc.client.FileItemStatus;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

final class UploadTableCellRenderer
implements TableCellRenderer {
    private JProgressBar progressBar = new JProgressBar();
    private JLabel cell = new JLabel();

    UploadTableCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int columnIndex) {
        if (value instanceof FileItem) {
            FileItem fileItem = (FileItem)value;
            FileItemStatus status = fileItem.getStatus();
            switch (status) {
                case NOT_STARTED: {
                    return this.renderText("");
                }
                case ENCRYPTING: {
                    return this.renderText("Encrypting\u2026");
                }
                case UPLOADING: {
                    return this.renderProgressBar(fileItem, false);
                }
                case FINISHED: {
                    return this.renderText("Sucessfully uploaded");
                }
                case ABORTED: {
                    return this.renderText("Uploading aborted");
                }
                case STALLED: {
                    return this.renderProgressBar(fileItem, true);
                }
            }
        }
        return this.renderText(String.valueOf(value));
    }

    private Component renderProgressBar(FileItem fileItem, boolean stalled) {
        long percentage = 100L * fileItem.getNumberOfBytesUploaded() / Math.max(1L, fileItem.getLength());
        this.progressBar.setValue((int)percentage);
        this.progressBar.setStringPainted(true);
        if (stalled) {
            this.progressBar.setString(String.valueOf(percentage) + "% (stalled)");
        } else {
            String eta = DateTimeUtils.renderDuration(fileItem.getEstimatedTimeOfArrival());
            this.progressBar.setString(String.valueOf(percentage) + "% (remaining: " + eta + ")");
        }
        return this.progressBar;
    }

    private Component renderText(String text) {
        this.cell.setText(text);
        return this.cell;
    }
}

