/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.bo;

import ch.systemsx.cisd.cifex.server.business.IBusinessContext;
import ch.systemsx.cisd.cifex.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.cifex.server.business.bo.IUserBO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IDAOFactory;
import ch.systemsx.cisd.cifex.server.business.dataaccess.IUserDAO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.common.Password;
import ch.systemsx.cisd.cifex.server.util.ExpirationUtilities;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import java.util.Date;
import org.springframework.dao.DataAccessException;

class UserBO
extends AbstractBusinessObject
implements IUserBO {
    private UserDTO userDTO;
    private UserDTO existingUser;
    private boolean dataChanged;
    private boolean createUser;
    private ITimeProvider timeProvider;

    UserBO(IDAOFactory daoFactory, IBusinessContext businessContext, ITimeProvider timeProvider) {
        super(daoFactory, businessContext);
        this.timeProvider = timeProvider;
    }

    @Override
    public void defineForCreate(UserDTO user, UserDTO requestUserOrNull, boolean forceTemporaryUser) {
        boolean noAdmin;
        assert (user != null) : "Given user can not be null.";
        user.setRegistrator(requestUserOrNull);
        boolean bl = noAdmin = requestUserOrNull != null && !requestUserOrNull.isAdmin();
        if (noAdmin) {
            user.setQuotaGroupId(requestUserOrNull.getQuotaGroupId());
        }
        this.checkAndFixUserExpiration(null, user, requestUserOrNull, noAdmin || forceTemporaryUser);
        this.userDTO = user;
        this.dataChanged = true;
        this.createUser = true;
    }

    @Override
    public void defineForUpdate(UserDTO oldUserToUpdateOrNull, UserDTO userToUpdate, Password passwordOrNull, UserDTO requestUserOrNull) {
        IUserDAO userDAO = this.daoFactory.getUserDAO();
        this.existingUser = oldUserToUpdateOrNull != null ? oldUserToUpdateOrNull : UserBO.getUserById(userDAO, userToUpdate);
        userToUpdate.setID(this.existingUser.getID());
        userToUpdate.setQuotaGroupId(this.existingUser.getQuotaGroupId());
        if (userToUpdate.isExternallyAuthenticated() != this.existingUser.isExternallyAuthenticated()) {
            if (userToUpdate.isExternallyAuthenticated()) {
                userToUpdate.setExternallyAuthenticated(true);
                userToUpdate.setExpirationDate(null);
                userToUpdate.setRegistrator(null);
            } else {
                userToUpdate.setExternallyAuthenticated(false);
                userToUpdate.setExpirationDate(null);
                userToUpdate.setRegistrator(requestUserOrNull);
            }
        }
        this.checkAndFixUserExpiration(this.existingUser, userToUpdate, requestUserOrNull, false);
        if (!Password.isEmpty(passwordOrNull)) {
            userToUpdate.setPassword(passwordOrNull);
        }
        if ((userToUpdate.isAdmin() || userToUpdate.isPermanent()) && !userDAO.isMainUserOfQuotaGroup(userToUpdate)) {
            userToUpdate.setQuotaGroupId(null);
        }
        UserDTO registratorOrNull = userToUpdate.getRegistrator();
        if (!this.existingUser.isPermanent() && userToUpdate.isPermanent() && registratorOrNull != null && !registratorOrNull.isAdmin() || registratorOrNull == null) {
            userToUpdate.setRegistrator(requestUserOrNull);
        }
        this.userDTO = userToUpdate;
        this.dataChanged = true;
        this.createUser = false;
    }

    private static UserDTO getUserById(IUserDAO userDAO, UserDTO user) throws IllegalArgumentException {
        assert (user != null);
        try {
            return userDAO.getUserById(user.getID());
        }
        catch (DataAccessException dataAccessException) {
            String msg = String.format("User id=%d does not exist in the database.", user.getID());
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkAndFixUserExpiration(UserDTO oldUserOrNull, UserDTO userToUpdate, UserDTO requestUserOrNull, boolean forceExpiration) {
        if (!userToUpdate.isPermanent() || forceExpiration) {
            Date registrationDate = this.getRegistrationDate(oldUserOrNull);
            Integer maxRetentionDaysOrNull = this.tryGetMaxUserRetentionDays(requestUserOrNull);
            Date expirationDate = ExpirationUtilities.fixExpiration(new Date(this.timeProvider.getTimeInMilliseconds()), userToUpdate.getExpirationDate(), registrationDate, maxRetentionDaysOrNull, this.businessContext.getUserRetention());
            userToUpdate.setExpirationDate(expirationDate);
        }
    }

    private Date getRegistrationDate(UserDTO userOrNull) {
        return userOrNull == null ? new Date() : userOrNull.getRegistrationDate();
    }

    private Integer tryGetMaxUserRetentionDays(UserDTO requestUserOrNull) {
        if (requestUserOrNull == null) {
            return this.businessContext.getMaxUserRetention();
        }
        if (requestUserOrNull.isAdmin()) {
            return null;
        }
        return requestUserOrNull.getMaxUserRetention() == null ? this.businessContext.getMaxUserRetention() : requestUserOrNull.getMaxUserRetention().intValue();
    }

    @Override
    public void save() {
        if (this.dataChanged) {
            if (this.createUser) {
                this.daoFactory.getUserDAO().createUser(this.userDTO);
            } else {
                this.daoFactory.getUserDAO().updateUser(this.userDTO);
            }
            this.dataChanged = false;
        }
    }

    @Override
    public UserDTO getOldUser() throws IllegalStateException {
        if (!this.dataChanged || this.createUser) {
            throw new IllegalStateException();
        }
        return this.existingUser;
    }

    @Override
    public UserDTO getUser() throws IllegalStateException {
        return this.userDTO;
    }
}

