/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingStatement;

public class DelegatingResultSet
extends AbandonedTrace
implements ResultSet {
    private ResultSet _res;
    private Statement _stmt;
    private Connection _conn;

    public DelegatingResultSet(Statement statement, ResultSet resultSet) {
        super((AbandonedTrace)((Object)statement));
        this._stmt = statement;
        this._res = resultSet;
    }

    public DelegatingResultSet(Connection connection, ResultSet resultSet) {
        super((AbandonedTrace)((Object)connection));
        this._conn = connection;
        this._res = resultSet;
    }

    public static ResultSet wrapResultSet(Statement statement, ResultSet resultSet) {
        if (null == resultSet) {
            return null;
        }
        return new DelegatingResultSet(statement, resultSet);
    }

    public static ResultSet wrapResultSet(Connection connection, ResultSet resultSet) {
        if (null == resultSet) {
            return null;
        }
        return new DelegatingResultSet(connection, resultSet);
    }

    public ResultSet getDelegate() {
        return this._res;
    }

    public boolean equals(Object object) {
        ResultSet resultSet = this.getInnermostDelegate();
        if (resultSet == null) {
            return false;
        }
        if (object instanceof DelegatingResultSet) {
            DelegatingResultSet delegatingResultSet = (DelegatingResultSet)object;
            return resultSet.equals(delegatingResultSet.getInnermostDelegate());
        }
        return resultSet.equals(object);
    }

    public int hashCode() {
        ResultSet resultSet = this.getInnermostDelegate();
        if (resultSet == null) {
            return 0;
        }
        return resultSet.hashCode();
    }

    public ResultSet getInnermostDelegate() {
        ResultSet resultSet = this._res;
        while (resultSet != null && resultSet instanceof DelegatingResultSet) {
            if (this != (resultSet = ((DelegatingResultSet)resultSet).getDelegate())) continue;
            return null;
        }
        return resultSet;
    }

    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    public void close() throws SQLException {
        try {
            if (this._stmt != null) {
                ((AbandonedTrace)((Object)this._stmt)).removeTrace(this);
                this._stmt = null;
            }
            if (this._conn != null) {
                ((AbandonedTrace)((Object)this._conn)).removeTrace(this);
                this._conn = null;
            }
            this._res.close();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this._stmt != null && this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).handleException(sQLException);
        } else if (this._conn != null && this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).handleException(sQLException);
        } else {
            throw sQLException;
        }
    }

    public boolean next() throws SQLException {
        try {
            return this._res.next();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this._res.wasNull();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public String getString(int n) throws SQLException {
        try {
            return this._res.getString(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this._res.getBoolean(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this._res.getByte(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this._res.getShort(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this._res.getInt(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            return this._res.getLong(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this._res.getFloat(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0f;
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this._res.getDouble(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this._res.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this._res.getBytes(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this._res.getDate(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this._res.getTime(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this._res.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            return this._res.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return this._res.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return this._res.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this._res.getString(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this._res.getBoolean(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this._res.getByte(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this._res.getShort(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this._res.getInt(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this._res.getLong(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this._res.getFloat(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0f;
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this._res.getDouble(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return this._res.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this._res.getBytes(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this._res.getDate(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this._res.getTime(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this._res.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this._res.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this._res.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this._res.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._res.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this._res.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public String getCursorName() throws SQLException {
        try {
            return this._res.getCursorName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this._res.getMetaData();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this._res.getObject(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this._res.getObject(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this._res.findColumn(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            return this._res.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return this._res.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this._res.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this._res.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            return this._res.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            return this._res.isAfterLast();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            return this._res.isFirst();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean isLast() throws SQLException {
        try {
            return this._res.isLast();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this._res.beforeFirst();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void afterLast() throws SQLException {
        try {
            this._res.afterLast();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public boolean first() throws SQLException {
        try {
            return this._res.first();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean last() throws SQLException {
        try {
            return this._res.last();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public int getRow() throws SQLException {
        try {
            return this._res.getRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public boolean absolute(int n) throws SQLException {
        try {
            return this._res.absolute(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            return this._res.relative(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean previous() throws SQLException {
        try {
            return this._res.previous();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this._res.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this._res.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this._res.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this._res.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public int getType() throws SQLException {
        try {
            return this._res.getType();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            return this._res.getConcurrency();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            return this._res.rowUpdated();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            return this._res.rowInserted();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            return this._res.rowDeleted();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public void updateNull(int n) throws SQLException {
        try {
            this._res.updateNull(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this._res.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        try {
            this._res.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            this._res.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            this._res.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            this._res.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        try {
            this._res.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            this._res.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this._res.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        try {
            this._res.updateString(n, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this._res.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            this._res.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            this._res.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this._res.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this._res.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this._res.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this._res.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this._res.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        try {
            this._res.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateNull(String string) throws SQLException {
        try {
            this._res.updateNull(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this._res.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        try {
            this._res.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        try {
            this._res.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        try {
            this._res.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        try {
            this._res.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        try {
            this._res.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        try {
            this._res.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this._res.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        try {
            this._res.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this._res.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        try {
            this._res.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        try {
            this._res.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this._res.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this._res.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this._res.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            this._res.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        try {
            this._res.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        try {
            this._res.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void insertRow() throws SQLException {
        try {
            this._res.insertRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateRow() throws SQLException {
        try {
            this._res.updateRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void deleteRow() throws SQLException {
        try {
            this._res.deleteRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void refreshRow() throws SQLException {
        try {
            this._res.refreshRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            this._res.cancelRowUpdates();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this._res.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this._res.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            return this._res.getObject(n, map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return this._res.getRef(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return this._res.getBlob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return this._res.getClob(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            return this._res.getArray(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this._res.getObject(string, map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this._res.getRef(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this._res.getBlob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this._res.getClob(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this._res.getArray(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this._res.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this._res.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this._res.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this._res.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this._res.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this._res.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this._res.getURL(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this._res.getURL(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            this._res.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this._res.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            this._res.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this._res.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            this._res.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this._res.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        try {
            this._res.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        try {
            this._res.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }
}

