/*
 * Decompiled with CFR 0.152.
 */
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import ch.systemsx.cisd.openbis.generic.client.cli.Login;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.AndDataSetFilter;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.IDataSetFilter;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.PropertiesBasedDataSetFilter;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.TypeBasedDataSetFilter;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureCodesProvider;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OpenBISScreeningML {
    static final String DATASETS_FOLDER = "openbis_datasets";
    private static File temporarySessionDir;
    private static Map<PlateImageReference, File> loadedImages;
    static IScreeningOpenbisServiceFacadeFactory facadeFactory;
    private static IScreeningOpenbisServiceFacade openbis;
    private static List<ExperimentIdentifier> experiments;
    private static List<Plate> plates;
    private static Map<String, List<Plate>> experimentToPlateMap;
    private static Map<String, ExperimentIdentifier> experimentCodeToExperimentMap;
    private static Map<String, Plate> plateCodeToPlateMap;
    public static final String VERSION = "1";
    public static final String REQUIRES_OPENBIS_AS_API = "1.7";
    public static final String REQUIRES_OPENBIS_DSS_API = "1.1";
    private static File dataSetsDir;
    static File tempDir;
    static final String TEMP_DIR_PREFIX = "openbis_";
    static final String TEMP_DIR_POSTFIX = "_temp_dir";

    static {
        facadeFactory = ScreeningOpenbisServiceFacadeFactory.INSTANCE;
        openbis = null;
        experiments = null;
        plates = null;
        experimentToPlateMap = new HashMap<String, List<Plate>>();
        experimentCodeToExperimentMap = new HashMap<String, ExperimentIdentifier>();
        plateCodeToPlateMap = new HashMap<String, Plate>();
        tempDir = new File(System.getProperty("java.io.tmpdir"));
    }

    private OpenBISScreeningML() {
    }

    public static void login(String user, String password, String url) {
        System.setProperty("force-accept-ssl-certificate", "true");
        IScreeningOpenbisServiceFacade facade = facadeFactory.tryToCreate(user, password, url);
        if (facade == null) {
            throw new RuntimeException("Login failed.");
        }
        OpenBISScreeningML.init(facade);
    }

    private static void init(IScreeningOpenbisServiceFacade openBisFacade) {
        openbis = openBisFacade;
        dataSetsDir = new File(tempDir, DATASETS_FOLDER);
        if (!dataSetsDir.isDirectory() && !dataSetsDir.mkdirs()) {
            throw new RuntimeException("Couldn't create a data set directory.");
        }
        temporarySessionDir = new File(tempDir, TEMP_DIR_PREFIX + System.currentTimeMillis() / 1000L + TEMP_DIR_POSTFIX);
        if (!temporarySessionDir.mkdirs()) {
            throw new RuntimeException("Couldn't create a temporary directory.");
        }
        temporarySessionDir.deleteOnExit();
        loadedImages = new HashMap<PlateImageReference, File>();
        experiments = openbis.listExperiments();
        experimentCodeToExperimentMap.clear();
        for (ExperimentIdentifier e : experiments) {
            experimentCodeToExperimentMap.put(e.getAugmentedCode(), e);
        }
        plates = openbis.listPlates();
        plateCodeToPlateMap.clear();
        experimentToPlateMap.clear();
        for (Plate p : plates) {
            String plateCode = p.getAugmentedCode();
            plateCodeToPlateMap.put(plateCode, p);
            String experimentCode = p.getExperimentIdentifier().getAugmentedCode();
            List<Plate> experimentPlates = experimentToPlateMap.get(experimentCode);
            if (experimentPlates == null) {
                experimentPlates = new ArrayList<Plate>();
                experimentToPlateMap.put(experimentCode, experimentPlates);
            }
            experimentPlates.add(p);
        }
    }

    public static void logout() {
        if (openbis == null) {
            return;
        }
        openbis.logout();
        if (Login.OPENBIS_TOKEN_FILE.exists()) {
            Login.OPENBIS_TOKEN_FILE.delete();
        }
        OpenBISScreeningML.delete(temporarySessionDir);
        openbis = null;
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                OpenBISScreeningML.delete(child);
                ++n2;
            }
        }
        file.delete();
    }

    public static Object[][] listExperiments() {
        OpenBISScreeningML.checkLoggedIn();
        Object[][] result = new Object[experiments.size()][5];
        int i = 0;
        while (i < experiments.size()) {
            Object[] annotations = new Object[]{experiments.get(i).getAugmentedCode(), experiments.get(i).getPermId(), experiments.get(i).getSpaceCode(), experiments.get(i).getProjectCode(), experiments.get(i).getExperimentCode()};
            System.arraycopy(annotations, 0, result[i], 0, annotations.length);
            ++i;
        }
        return result;
    }

    public static Object[][] listPlates() {
        OpenBISScreeningML.checkLoggedIn();
        return OpenBISScreeningML.listPlates(plates);
    }

    public static Object[][] listPlates(String experiment) {
        OpenBISScreeningML.checkLoggedIn();
        List<Plate> experimentPlates = experimentToPlateMap.get(experiment);
        if (experimentPlates == null) {
            throw new RuntimeException("No experiment with that code found.");
        }
        return OpenBISScreeningML.listPlates(experimentPlates);
    }

    public static Object[][] listPlates(String experiment, String analysisProcedure) {
        OpenBISScreeningML.checkLoggedIn();
        ExperimentIdentifier experimentIdentifier = OpenBISScreeningML.getExperimentIdentifierOrFail(experiment);
        List resultPlates = openbis.listPlates(experimentIdentifier, analysisProcedure);
        return OpenBISScreeningML.listPlates(resultPlates);
    }

    private static Object[][] listPlates(List<Plate> list) {
        Object[][] result = new Object[list.size()][9];
        int i = 0;
        while (i < list.size()) {
            Object[] annotations = new Object[]{list.get(i).getAugmentedCode(), list.get(i).getPermId(), list.get(i).tryGetSpaceCode(), list.get(i).getPlateCode(), list.get(i).getExperimentIdentifier().getAugmentedCode(), list.get(i).getExperimentIdentifier().getPermId(), list.get(i).getExperimentIdentifier().getSpaceCode(), list.get(i).getExperimentIdentifier().getProjectCode(), list.get(i).getExperimentIdentifier().getExperimentCode()};
            System.arraycopy(annotations, 0, result[i], 0, annotations.length);
            ++i;
        }
        return result;
    }

    public static Object[][] listAnalysisProcedures(String experiment) {
        OpenBISScreeningML.checkLoggedIn();
        ExperimentIdentifier experimentIdentifier = OpenBISScreeningML.getExperimentIdentifierOrFail(experiment);
        List proceduresList = openbis.listAnalysisProcedures(experimentIdentifier);
        return OpenBISScreeningML.listAnalysisProcedures(proceduresList);
    }

    private static Object[][] listAnalysisProcedures(List<String> list) {
        Object[][] result = new Object[list.size()][1];
        int i = 0;
        while (i < list.size()) {
            result[i][0] = list.get(i);
            ++i;
        }
        return result;
    }

    public static Object[][] getWellProperties(String augmentedPlateCode, int row, int column) {
        OpenBISScreeningML.checkLoggedIn();
        WellPosition wellPosition = new WellPosition(row, column);
        WellIdentifier wellIdentifier = OpenBISScreeningML.getWell(augmentedPlateCode, wellPosition);
        Map wellProperties = openbis.getWellProperties(wellIdentifier);
        return OpenBISScreeningML.listProperties(wellProperties);
    }

    public static void updateWellProperties(String augmentedPlateCode, int row, int column, Object[][] properties) {
        OpenBISScreeningML.checkLoggedIn();
        WellPosition wellPosition = new WellPosition(row, column);
        WellIdentifier wellIdentifier = OpenBISScreeningML.getWell(augmentedPlateCode, wellPosition);
        openbis.updateWellProperties(wellIdentifier, OpenBISScreeningML.createMap(properties));
    }

    private static WellIdentifier getWell(String augmentedPlateCode, WellPosition wellPosition) {
        Plate plate = OpenBISScreeningML.getPlate(augmentedPlateCode);
        List wells = openbis.listPlateWells((PlateIdentifier)plate);
        for (WellIdentifier wellIdentifier : wells) {
            if (!wellIdentifier.getWellPosition().equals(wellPosition)) continue;
            return wellIdentifier;
        }
        throw new RuntimeException("Plate '" + augmentedPlateCode + "' has no well at " + wellPosition + ".");
    }

    public static Object[][] getImagesMetadata(String augmentedPlateCode) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateId = OpenBISScreeningML.getPlate(augmentedPlateCode);
        List<ImageDatasetReference> imageDatasets = OpenBISScreeningML.listRawImageDatasets(plateId);
        List metaList = openbis.listImageMetadata(imageDatasets);
        Object[][] result = new Object[metaList.size()][];
        int i = 0;
        while (i < metaList.size()) {
            ImageDatasetMetadata meta = (ImageDatasetMetadata)metaList.get(i);
            ImageDatasetReference imageDatasetReference = imageDatasets.get(i);
            Geometry plateGeometry = imageDatasetReference.getPlateGeometry();
            result[i] = new Object[]{meta.getWidth(), meta.getHeight(), meta.getNumberOfTiles(), meta.getTilesRows(), meta.getTilesCols(), plateGeometry.getNumberOfRows(), plateGeometry.getNumberOfColumns()};
            ++i;
        }
        return result;
    }

    public static Object[][] listChannels(String experiment) {
        OpenBISScreeningML.checkLoggedIn();
        List<Plate> experimentPlates = experimentToPlateMap.get(experiment);
        if (experimentPlates == null) {
            throw new RuntimeException("No experiment with that code found.");
        }
        if (experimentPlates.isEmpty()) {
            return new Object[0][];
        }
        List imageDatasets = openbis.listRawImageDatasets(experimentPlates);
        if (imageDatasets.isEmpty()) {
            return new Object[0][];
        }
        return OpenBISScreeningML.extractChannels((ImageDatasetReference)imageDatasets.get(0));
    }

    private static List<String> getChannelCodes(List<ImageDatasetMetadata> meta) {
        return meta.get(0).getChannelCodes();
    }

    public static Object[][] listFeatures(String experiment, String analysisProcedureOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        List<Plate> experimentPlates = experimentToPlateMap.get(experiment);
        if (experimentPlates == null) {
            throw new RuntimeException("No experiment with that code found.");
        }
        if (experimentPlates.isEmpty()) {
            return new Object[0][];
        }
        List featureDatasets = openbis.listFeatureVectorDatasets(experimentPlates, analysisProcedureOrNull);
        if (featureDatasets.isEmpty()) {
            return new Object[0][];
        }
        List featureCodes = openbis.listAvailableFeatureCodes(featureDatasets);
        Collections.sort(featureCodes);
        Object[][] result = new Object[featureCodes.size()][1];
        int i = 0;
        while (i < result.length) {
            result[i][0] = featureCodes.get(i);
            ++i;
        }
        return result;
    }

    public static Object[][] loadDataSets(String augmentedPlateCode, String dataSetTypeCodePattern, String overrideStoreRootPathOrNull) {
        return OpenBISScreeningML.loadDataSets(augmentedPlateCode, dataSetTypeCodePattern, new Object[0][], overrideStoreRootPathOrNull);
    }

    public static Object[][] loadDataSets(String augmentedPlateCode, String dataSetTypeCodePattern, Object[][] properties, String overrideStoreRootPathOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateIdentifier = OpenBISScreeningML.getPlate(augmentedPlateCode);
        List dataSets = openbis.getFullDataSets((PlateIdentifier)plateIdentifier, (IDataSetFilter)new AndDataSetFilter(new IDataSetFilter[]{new TypeBasedDataSetFilter(dataSetTypeCodePattern), new PropertiesBasedDataSetFilter(OpenBISScreeningML.createMap(properties))}));
        try {
            return OpenBISScreeningML.translateDataSets(overrideStoreRootPathOrNull, dataSets);
        }
        catch (Exception ex) {
            throw OpenBISScreeningML.createException("Loading data sets for plate '" + augmentedPlateCode + "' failed.", ex);
        }
    }

    public static Object[][] loadDataSetsForExperiment(String augmentedExperimentCode, String dataSetTypeCodePattern, Object[][] properties, String overrideStoreRootPathOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        ExperimentIdentifier experimentIdentifier = OpenBISScreeningML.getExperimentIdentifierOrFail(augmentedExperimentCode);
        List dataSets = openbis.getFullDataSets(experimentIdentifier, (IDataSetFilter)new AndDataSetFilter(new IDataSetFilter[]{new TypeBasedDataSetFilter(dataSetTypeCodePattern), new PropertiesBasedDataSetFilter(OpenBISScreeningML.createMap(properties))}));
        try {
            return OpenBISScreeningML.translateDataSets(overrideStoreRootPathOrNull, dataSets);
        }
        catch (Exception ex) {
            throw OpenBISScreeningML.createException("Loading data sets for experiment '" + augmentedExperimentCode + "' failed.", ex);
        }
    }

    public static Object[][][] listDataSetFilesForExperiment(String augmentedExperimentCode, String dataSetTypeCodePattern) {
        OpenBISScreeningML.checkLoggedIn();
        ExperimentIdentifier experimentIdentifier = OpenBISScreeningML.getExperimentIdentifierOrFail(augmentedExperimentCode);
        List dataSets = openbis.getDataSets(experimentIdentifier, (IDataSetFilter)new TypeBasedDataSetFilter(dataSetTypeCodePattern));
        Object[][][] result = new Object[dataSets.size()][][];
        int i = 0;
        while (i < dataSets.size()) {
            IDataSetDss dataSet = (IDataSetDss)dataSets.get(i);
            FileInfoDssDTO[] fileInfos = dataSet.listFiles("/", true);
            String code = dataSet.getCode();
            result[i] = new Object[4][];
            result[i][0] = new Object[]{code};
            result[i][1] = new Object[fileInfos.length];
            int j = 0;
            while (j < fileInfos.length) {
                FileInfoDssDTO fileInfo = fileInfos[j];
                result[i][1][j] = fileInfo.getPathInDataSet();
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Object[][] translateDataSets(String overrideStoreRootPathOrNull, List<DataSet> dataSets) {
        Object[][] result = new Object[dataSets.size()][];
        int i = 0;
        while (i < dataSets.size()) {
            DataSet dataSet = dataSets.get(i);
            String code = dataSet.getCode();
            File file = new File(dataSetsDir, code);
            if (!file.exists()) {
                file = dataSet.getLinkOrCopyOfContents(overrideStoreRootPathOrNull, dataSetsDir);
            }
            List parents = dataSet.getParentCodes();
            Object[] parentCodes = new Object[parents.size()];
            int j = 0;
            while (j < parentCodes.length) {
                parentCodes[j] = parents.get(j);
                ++j;
            }
            Object[][] dataSetProperties = OpenBISScreeningML.listProperties(dataSet.getProperties());
            result[i] = new Object[]{code, file.getPath(), dataSetProperties, parentCodes};
            ++i;
        }
        return result;
    }

    public static Object loadDataSetFile(String dataSetCode, String pathInDataSet, String overrideStoreRootPathOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        IDataSetDss dataSet = openbis.getDataSet(dataSetCode);
        return dataSet.getLinkOrCopyOfContent(overrideStoreRootPathOrNull, temporarySessionDir, pathInDataSet).toString();
    }

    public static Object[][][] listDataSetsFiles(String augmentedPlateCode, String dataSetTypeCodePattern) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateIdentifier = OpenBISScreeningML.getPlate(augmentedPlateCode);
        List dataSets = openbis.getDataSets((PlateIdentifier)plateIdentifier, (IDataSetFilter)new TypeBasedDataSetFilter(dataSetTypeCodePattern));
        Object[][][] result = new Object[dataSets.size()][][];
        int i = 0;
        while (i < dataSets.size()) {
            IDataSetDss dataSet = (IDataSetDss)dataSets.get(i);
            FileInfoDssDTO[] fileInfos = dataSet.listFiles("/", true);
            String code = dataSet.getCode();
            result[i] = new Object[4][];
            result[i][0] = new Object[]{code};
            result[i][1] = new Object[fileInfos.length];
            int j = 0;
            while (j < fileInfos.length) {
                FileInfoDssDTO fileInfo = fileInfos[j];
                result[i][1][j] = fileInfo.getPathInDataSet();
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static Object[][][] getDataSetMetaData(String[] dataSetCodes) {
        OpenBISScreeningML.checkLoggedIn();
        List dataSets = openbis.getDataSetMetaData(Arrays.asList(dataSetCodes));
        TableMap dataSetMap = new TableMap((Iterable)dataSets, (IKeyExtractor)new IKeyExtractor<String, DataSet>(){

            public String getKey(DataSet e) {
                return e.getCode();
            }
        });
        Object[][][] result = new Object[dataSetCodes.length][][];
        int i = 0;
        while (i < dataSetCodes.length) {
            DataSet dataSet = (DataSet)dataSetMap.tryGet((Object)dataSetCodes[i]);
            result[i] = new Object[4][];
            result[i][0] = new Object[]{dataSet.getCode(), dataSet.getDataSetTypeCode()};
            result[i][1] = OpenBISScreeningML.listProperties(dataSet.getProperties());
            result[i][2] = dataSet.getParentCodes().toArray();
            result[i][3] = dataSet.getChildrenCodes().toArray();
            ++i;
        }
        return result;
    }

    public static Object uploadDataSet(String augmentedPlateCode, String dataSetFilePath, String dataSetType, Object[][] dataSetProperties) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateIdentifier = OpenBISScreeningML.getPlate(augmentedPlateCode);
        File dataSetFile = new File(dataSetFilePath);
        if (!dataSetFile.exists()) {
            throw new RuntimeException("Unknown data set file path '" + dataSetFilePath + "'.");
        }
        try {
            Map<String, String> map = OpenBISScreeningML.createMap(dataSetProperties);
            IDataSetDss dataSet = openbis.putDataSet((PlateIdentifier)plateIdentifier, dataSetFile, new NewDataSetMetadataDTO(dataSetType, map));
            return dataSet.getCode();
        }
        catch (Exception ex) {
            throw OpenBISScreeningML.createException("Couldn't upload data set for plate '" + augmentedPlateCode + "'.", ex);
        }
    }

    public static Object uploadDataSetForPlateAndParents(String augmentedPlateCode, Object[] parentDataSetCodeObjects, String dataSetFilePath, String dataSetType, Object[][] dataSetProperties) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateIdentifier = OpenBISScreeningML.getPlate(augmentedPlateCode);
        List<String> dataSetCodes = OpenBISScreeningML.createStringList(parentDataSetCodeObjects);
        File dataSetFile = new File(dataSetFilePath);
        if (!dataSetFile.exists()) {
            throw new RuntimeException("Unknown data set file path '" + dataSetFilePath + "'.");
        }
        try {
            Map<String, String> map = OpenBISScreeningML.createMap(dataSetProperties);
            IDataSetDss dataSet = openbis.putDataSet((PlateIdentifier)plateIdentifier, dataSetFile, new NewDataSetMetadataDTO(dataSetType, map, dataSetCodes));
            return dataSet.getCode();
        }
        catch (Exception ex) {
            throw OpenBISScreeningML.createException("Couldn't upload data set for plate '" + augmentedPlateCode + "'.", ex);
        }
    }

    public static Object uploadDataSetForExperimentAndParents(String augmentedExperimentCode, Object[] parentDataSetCodeObjects, String dataSetFilePath, String dataSetType, Object[][] dataSetProperties) {
        OpenBISScreeningML.checkLoggedIn();
        ExperimentIdentifier experimentIdentifier = OpenBISScreeningML.getExperimentIdentifierOrFail(augmentedExperimentCode);
        List<String> dataSetCodes = OpenBISScreeningML.createStringList(parentDataSetCodeObjects);
        File dataSetFile = new File(dataSetFilePath);
        if (!dataSetFile.exists()) {
            throw new RuntimeException("Unknown data set file path '" + dataSetFilePath + "'.");
        }
        try {
            Map<String, String> map = OpenBISScreeningML.createMap(dataSetProperties);
            IDataSetDss dataSet = openbis.putDataSet(experimentIdentifier, dataSetFile, new NewDataSetMetadataDTO(dataSetType, map, dataSetCodes));
            return dataSet.getCode();
        }
        catch (Exception ex) {
            throw OpenBISScreeningML.createException("Couldn't upload data set for experiment '" + augmentedExperimentCode + "' and parents '" + Arrays.toString(parentDataSetCodeObjects) + "'.", ex);
        }
    }

    private static Map<String, String> createMap(Object[][] properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        Object[][] objectArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] objects = objectArray[n2];
            if (objects.length == 2) {
                Object value = objects[1];
                map.put(objects[0].toString(), value == null ? null : value.toString());
            }
            ++n2;
        }
        return map;
    }

    private static List<String> createStringList(Object[] identifiers) {
        ArrayList<String> list = new ArrayList<String>();
        Object[] objectArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Object identifier = objectArray[n2];
            list.add(identifier.toString());
            ++n2;
        }
        return list;
    }

    public static Object[][][] loadImages(String plate, int row, int col) {
        return OpenBISScreeningML.loadImages(plate, row, col, null);
    }

    public static Object[][][] loadImages(String plate, int row, int col, int tile) {
        return OpenBISScreeningML.loadImages(plate, row, col, tile, null);
    }

    public static Object[][][] loadImages(String plate, int row, int col, String[] channels) {
        return OpenBISScreeningML.loadRawImages(plate, row, col, channels, OpenBISScreeningML.createAllTilesIterator());
    }

    public static Object[][][] loadSegmentationImages(String plate, int row, int col, String[] objectNamesOrNull, String analysisProcedureOrNull) {
        return OpenBISScreeningML.loadSegmentationImages(plate, row, col, objectNamesOrNull, OpenBISScreeningML.createAllTilesIterator(), analysisProcedureOrNull);
    }

    private static ITileNumberIterable createAllTilesIterator() {
        return new ITileNumberIterable(){
            private int maximumNumberOfTiles;

            @Override
            public void setMaximumNumberOfTiles(int numberOfTiles) {
                this.maximumNumberOfTiles = numberOfTiles;
            }

            @Override
            public int getMaximumNumberOfTiles() {
                return this.maximumNumberOfTiles;
            }

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < maximumNumberOfTiles;
                    }

                    @Override
                    public Integer next() {
                        return this.index++;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Object[][][] loadImages(String plate, int row, int col, int tile, String[] channels) {
        return OpenBISScreeningML.loadRawImages(plate, row, col, channels, OpenBISScreeningML.createSingleTileIterator(tile));
    }

    public static Object[][][] loadSegmentationImages(String plate, int row, int col, int tile, String[] objectNamesOrNull, String analysisProcedureOrNull) {
        return OpenBISScreeningML.loadSegmentationImages(plate, row, col, objectNamesOrNull, OpenBISScreeningML.createSingleTileIterator(tile), analysisProcedureOrNull);
    }

    private static ITileNumberIterable createSingleTileIterator(final int tile) {
        return new ITileNumberIterable(){

            @Override
            public void setMaximumNumberOfTiles(int numberOfTiles) {
                if (tile >= numberOfTiles) {
                    throw new IllegalArgumentException("Tile number " + tile + " is not less than number of tiles " + numberOfTiles + ".");
                }
            }

            @Override
            public int getMaximumNumberOfTiles() {
                return 1;
            }

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private boolean delivered;

                    @Override
                    public boolean hasNext() {
                        return !this.delivered;
                    }

                    @Override
                    public Integer next() {
                        this.delivered = true;
                        return tile;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Object[][] listSegmentationObjects(String plate, String analysisProcedureOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateId = OpenBISScreeningML.getPlate(plate);
        List<ImageDatasetReference> imageDatasets = OpenBISScreeningML.listSegmentationImageDatasets(plateId, analysisProcedureOrNull);
        if (imageDatasets.isEmpty()) {
            return new Object[0][];
        }
        return OpenBISScreeningML.extractChannels(imageDatasets.get(0));
    }

    private static Object[][] extractChannels(ImageDatasetReference imageDatasetReference) {
        List meta = openbis.listImageMetadata(Arrays.asList(imageDatasetReference));
        if (meta.isEmpty()) {
            return new Object[0][];
        }
        List<String> channels = OpenBISScreeningML.getChannelCodes(meta);
        Object[][] result = new Object[channels.size()][1];
        int i = 0;
        while (i < result.length) {
            result[i][0] = channels.get(i);
            ++i;
        }
        return result;
    }

    private static Object[][][] loadRawImages(String plate, int row, int col, String[] channels, ITileNumberIterable tileNumberIterable) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateId = OpenBISScreeningML.getPlate(plate);
        List<ImageDatasetReference> imageDatasets = OpenBISScreeningML.listRawImageDatasets(plateId);
        return OpenBISScreeningML.loadImages(plateId, imageDatasets, row, col, channels, tileNumberIterable);
    }

    private static Object[][][] loadSegmentationImages(String plate, int row, int col, String[] channelsOrNull, ITileNumberIterable tileNumberIterable, String analysisProcedureOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        Plate plateId = OpenBISScreeningML.getPlate(plate);
        List<ImageDatasetReference> imageDatasets = OpenBISScreeningML.listSegmentationImageDatasets(plateId, analysisProcedureOrNull);
        return OpenBISScreeningML.loadImages(plateId, imageDatasets, row, col, channelsOrNull, tileNumberIterable);
    }

    private static Object[][][] loadImages(Plate plate, List<ImageDatasetReference> imageDatasets, int row, int col, String[] channelsOrNull, ITileNumberIterable tileNumberIterable) {
        List meta = openbis.listImageMetadata(imageDatasets);
        if (meta.isEmpty()) {
            return new Object[][][]{new Object[0][], new Object[0][]};
        }
        List<String> imageChannels = channelsOrNull == null || channelsOrNull.length == 0 ? OpenBISScreeningML.getChannelCodes(meta) : Arrays.asList(channelsOrNull);
        ArrayList<ImageReferenceAndFile> imageReferencesAndFiles = new ArrayList<ImageReferenceAndFile>(imageDatasets.size());
        Object[][][] result = new Object[2][][];
        tileNumberIterable.setMaximumNumberOfTiles(((ImageDatasetMetadata)meta.get(0)).getNumberOfTiles());
        int numberOfTiles = tileNumberIterable.getMaximumNumberOfTiles();
        result[0] = new Object[imageDatasets.size() * imageChannels.size() * numberOfTiles][1];
        result[1] = new Object[imageDatasets.size() * imageChannels.size() * numberOfTiles][15];
        int resultIdx = 0;
        for (ImageDatasetReference ds : imageDatasets) {
            for (String channel : imageChannels) {
                for (Integer tile : tileNumberIterable) {
                    PlateImageReference ref = new PlateImageReference(row, col, tile, channel, ds);
                    File imageFile = OpenBISScreeningML.createImageFileName(plate, ref);
                    imageReferencesAndFiles.add(new ImageReferenceAndFile(ref, imageFile));
                    result[0][resultIdx][0] = imageFile.getPath();
                    PlateIdentifier plateIdentifier = ds.getPlate();
                    ExperimentIdentifier expIdentifier = ds.getExperimentIdentifier();
                    Object[] annotations = new Object[]{channel, tile, OpenBISScreeningML.createPlateWellDescription(plateIdentifier, row, col), plateIdentifier.getAugmentedCode(), plateIdentifier.getPermId(), plateIdentifier.tryGetSpaceCode(), plateIdentifier.getPlateCode(), row, col, expIdentifier.getAugmentedCode(), expIdentifier.getPermId(), expIdentifier.getSpaceCode(), expIdentifier.getProjectCode(), expIdentifier.getExperimentCode(), ds.getPermId()};
                    System.arraycopy(annotations, 0, result[1][resultIdx], 0, annotations.length);
                    ++resultIdx;
                }
            }
        }
        try {
            OpenBISScreeningML.loadImages(imageReferencesAndFiles);
        }
        catch (IOException ex) {
            throw OpenBISScreeningML.createException("Image loading error.", ex);
        }
        return result;
    }

    private static List<ImageDatasetReference> listRawImageDatasets(Plate plateId) {
        return openbis.listRawImageDatasets(Arrays.asList(plateId));
    }

    private static List<ImageDatasetReference> listSegmentationImageDatasets(Plate plateId, String analysisProcedureOrNull) {
        return openbis.listSegmentationImageDatasets(Arrays.asList(plateId), analysisProcedureOrNull);
    }

    /*
     * Unable to fully structure code
     */
    private static void loadImages(List<ImageReferenceAndFile> imageReferencesAndFiles) throws IOException {
        imageReferences = new ArrayList<PlateImageReference>();
        imageRefToFileMap = new HashMap<PlateImageReference, ImageReferenceAndFile>();
        for (ImageReferenceAndFile imageReferenceAndFile : imageReferencesAndFiles) {
            imageReference = imageReferenceAndFile.getImageReference();
            file = OpenBISScreeningML.loadedImages.get(imageReference);
            if (file != null) continue;
            imageReferences.add(imageReference);
            imageRefToFileMap.put(imageReference, imageReferenceAndFile);
        }
        try {
            OpenBISScreeningML.openbis.loadImages(imageReferences, new ScreeningOpenbisServiceFacade.IImageOutputStreamProvider(){

                public OutputStream getOutputStream(PlateImageReference imageReference) throws IOException {
                    return ((ImageReferenceAndFile)imageRefToFileMap.get(imageReference)).open();
                }
            }, false);
        }
        finally {
            values = imageRefToFileMap.values();
            ** for (imageReferenceAndFile : values)
        }
lbl-1000:
        // 1 sources

        {
            imageReferenceAndFile.close();
            imageReference = imageReferenceAndFile.getImageReference();
            OpenBISScreeningML.loadedImages.put(imageReference, imageReferenceAndFile.getImageFile());
            continue;
        }
lbl23:
        // 1 sources

    }

    private static File createImageFileName(Plate plate, PlateImageReference image) {
        WellPosition well = image.getWellPosition();
        File imageDir = new File(temporarySessionDir, "images");
        imageDir.mkdirs();
        File f = new File(imageDir, "img_" + plate.getPlateCode() + "_" + image.getDatasetCode() + "_row" + well.getWellRow() + "_col" + well.getWellColumn() + (image.getChannel() == null ? "" : "_" + image.getChannel()) + "_tile" + image.getTile() + ".tiff");
        f.deleteOnExit();
        return f;
    }

    public static Object[][][][] getFeatureMatrix(String experiment, String gene, String analysisProcedureOrNull, String[] featuresOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        ExperimentIdentifier experimentId = experimentCodeToExperimentMap.get(experiment);
        if (experimentId == null) {
            throw new RuntimeException("No experiment with that code found.");
        }
        List<Plate> experimentPlates = experimentToPlateMap.get(experiment);
        if (experimentPlates == null || experimentPlates.isEmpty()) {
            return new Object[][][][]{new Object[0][][], new Object[0][][], new Object[0][][]};
        }
        List featureVectors = openbis.loadFeaturesForPlateWells(experimentId, new MaterialIdentifier(MaterialTypeIdentifier.GENE, gene), analysisProcedureOrNull, featuresOrNull == null ? null : Arrays.asList(featuresOrNull));
        return OpenBISScreeningML.getFeatureMatrix(featureVectors);
    }

    public static Object[][][][] getFeatureMatrix(String gene, String analysisProcedureOrNull, String[] featuresOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        List featureVectors = openbis.loadFeaturesForPlateWells(new MaterialIdentifier(MaterialTypeIdentifier.GENE, gene), analysisProcedureOrNull, featuresOrNull == null ? null : Arrays.asList(featuresOrNull));
        return OpenBISScreeningML.getFeatureMatrix(featureVectors);
    }

    private static Object[][][][] getFeatureMatrix(List<FeatureVectorWithDescription> featureVectors) {
        WellPosition wellPosition;
        Object[][][][] result = new Object[3][][][];
        if (featureVectors.isEmpty()) {
            return result;
        }
        List<String> featureCodes = OpenBISScreeningML.getFeatureCodes(featureVectors);
        HashMap<String, Integer> featureCodeToIndexMap = new HashMap<String, Integer>();
        result[2] = new Object[featureCodes.size()][1][1];
        int i = 0;
        while (i < featureCodes.size()) {
            String code = featureCodes.get(i);
            result[2][i][0][0] = code;
            featureCodeToIndexMap.put(code, i);
            ++i;
        }
        IndexSet<String> dataSetCodes = new IndexSet<String>();
        IndexSet<WellPosition> wellPositions = new IndexSet<WellPosition>();
        for (FeatureVectorWithDescription featureVector : featureVectors) {
            wellPosition = featureVector.getWellPosition();
            wellPositions.add(wellPosition);
            dataSetCodes.add(featureVector.getDatasetWellReference().getDatasetCode());
        }
        result[0] = new Object[featureCodes.size()][wellPositions.size()][dataSetCodes.size()];
        result[1] = new Object[wellPositions.size()][dataSetCodes.size()][14];
        for (FeatureVectorWithDescription vector : featureVectors) {
            wellPosition = vector.getWellPosition();
            int wellIndex = wellPositions.getIndex(wellPosition);
            int[] featureIndexes = OpenBISScreeningML.createFeatureIndexes(vector, featureCodeToIndexMap);
            FeatureVectorDatasetWellReference dataSetRef = vector.getDatasetWellReference();
            int dataSetIndex = dataSetCodes.getIndex(dataSetRef.getDatasetCode());
            OpenBISScreeningML.copyFeatureValuesInto(result, wellIndex, dataSetIndex, featureIndexes, vector);
            OpenBISScreeningML.copyAnnotationsInto(result, wellIndex, dataSetIndex, dataSetRef, vector);
        }
        return OpenBISScreeningML.replaceFeatureNullValuesByNaN(result);
    }

    public static Object[][][][] getFeatureMatrixForPlate(String plate, String analysisProcedureOrNull, String[] featuresOrNull) {
        OpenBISScreeningML.checkLoggedIn();
        List dataSets = openbis.loadFeaturesForPlates(Arrays.asList(PlateIdentifier.createFromAugmentedCode(plate)), featuresOrNull == null ? null : Arrays.asList(featuresOrNull), analysisProcedureOrNull);
        Object[][][][] result = new Object[3][][][];
        if (dataSets.isEmpty()) {
            return result;
        }
        List<String> featureCodes = OpenBISScreeningML.getFeatureCodes(dataSets);
        HashMap<String, Integer> featureCodeToIndexMap = new HashMap<String, Integer>();
        result[2] = new Object[featureCodes.size()][1][1];
        int i = 0;
        while (i < featureCodes.size()) {
            String code = featureCodes.get(i);
            result[2][i][0][0] = code;
            featureCodeToIndexMap.put(code, i);
            ++i;
        }
        IndexSet<WellPosition> wellPositions = new IndexSet<WellPosition>();
        for (FeatureVectorDataset dataSet : dataSets) {
            List<FeatureVector> featureVectors = dataSet.getFeatureVectors();
            for (FeatureVector featureVector : featureVectors) {
                WellPosition wellPosition = featureVector.getWellPosition();
                wellPositions.add(wellPosition);
            }
        }
        int numberOfDataSets = dataSets.size();
        result[0] = new Object[featureCodes.size()][wellPositions.size()][numberOfDataSets];
        result[1] = new Object[wellPositions.size()][numberOfDataSets][14];
        int dataSetIndex = 0;
        while (dataSetIndex < numberOfDataSets) {
            FeatureVectorDataset dataSet = (FeatureVectorDataset)dataSets.get(dataSetIndex);
            FeatureVectorDatasetReference dataSetRef = dataSet.getDataset();
            int[] featureIndexes = OpenBISScreeningML.createFeatureIndexes(dataSet, featureCodeToIndexMap);
            for (FeatureVector vector : dataSet.getFeatureVectors()) {
                WellPosition wellPosition = vector.getWellPosition();
                int wellIndex = wellPositions.getIndex(wellPosition);
                OpenBISScreeningML.copyFeatureValuesInto(result, wellIndex, dataSetIndex, featureIndexes, vector);
                OpenBISScreeningML.copyAnnotationsInto(result, wellIndex, dataSetIndex, dataSetRef, vector);
            }
            ++dataSetIndex;
        }
        return OpenBISScreeningML.replaceFeatureNullValuesByNaN(result);
    }

    private static Object[][][][] replaceFeatureNullValuesByNaN(Object[][][][] result) {
        Double nan = Double.NaN;
        int i = 0;
        while (i < result[0].length) {
            Object[][] r0i = result[0][i];
            int j = 0;
            while (j < r0i.length) {
                Object[] r0ij = r0i[j];
                int k = 0;
                while (k < r0ij.length) {
                    if (r0ij[k] == null) {
                        r0ij[k] = nan;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static int[] createFeatureIndexes(IFeatureCodesProvider dataSet, Map<String, Integer> featureCodeToIndexMap) {
        List<String> codes = dataSet.getFeatureCodes();
        int[] featureIndexes = new int[codes.size()];
        int i = 0;
        while (i < featureIndexes.length) {
            featureIndexes[i] = featureCodeToIndexMap.get(codes.get(i));
            ++i;
        }
        return featureIndexes;
    }

    private static void copyFeatureValuesInto(Object[][][][] result, int wellIndex, int dataSetIndex, int[] featureIndexes, FeatureVector vector) {
        List<Object> valueObjects = vector.getValueObjects();
        int i = 0;
        int n = valueObjects.size();
        while (i < n) {
            int featureIndex = featureIndexes[i];
            try {
                Object[][] f = result[0][featureIndex];
                Object[] d = f[wellIndex];
                d[dataSetIndex] = valueObjects.get(i);
            }
            catch (Exception ex) {
                throw OpenBISScreeningML.createException(String.valueOf(featureIndex) + "." + wellIndex + "." + dataSetIndex, ex);
            }
            ++i;
        }
    }

    private static void copyAnnotationsInto(Object[][][][] result, int wellIndex, int dataSetIndex, FeatureVectorDatasetReference dataSetRef, FeatureVector vector) {
        Object[] annotations = new Object[]{OpenBISScreeningML.createPlateWellDescription(dataSetRef.getPlate(), vector), dataSetRef.getPlate().getAugmentedCode(), dataSetRef.getPlate().getPermId(), dataSetRef.getPlate().tryGetSpaceCode(), dataSetRef.getPlate().getPlateCode(), vector.getWellPosition().getWellRow(), vector.getWellPosition().getWellColumn(), dataSetRef.getExperimentIdentifier().getAugmentedCode(), dataSetRef.getExperimentIdentifier().getPermId(), dataSetRef.getExperimentIdentifier().getSpaceCode(), dataSetRef.getExperimentIdentifier().getProjectCode(), dataSetRef.getExperimentIdentifier().getExperimentCode(), dataSetRef.getDatasetCode(), dataSetRef.getDataSetType()};
        System.arraycopy(annotations, 0, result[1][wellIndex][dataSetIndex], 0, annotations.length);
    }

    private static List<String> getFeatureCodes(List<? extends IFeatureCodesProvider> dataSets) {
        HashSet<String> codes = new HashSet<String>();
        for (IFeatureCodesProvider iFeatureCodesProvider : dataSets) {
            codes.addAll(iFeatureCodesProvider.getFeatureCodes());
        }
        ArrayList<String> arrayList = new ArrayList<String>(codes);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static Object[][][] getGeneMappingForPlates(String[] platesCodes) {
        OpenBISScreeningML.checkLoggedIn();
        List mappingList = openbis.listPlateMaterialMapping(OpenBISScreeningML.toPlates(platesCodes), MaterialTypeIdentifier.GENE);
        int size = 0;
        for (PlateWellMaterialMapping mapping : mappingList) {
            size += mapping.getPlateGeometry().getNumberOfRows() * mapping.getPlateGeometry().getNumberOfColumns();
        }
        Object[][][] result = new Object[2][size][];
        int resultIdx = 0;
        for (PlateWellMaterialMapping mapping : mappingList) {
            int row = 1;
            while (row <= mapping.getPlateGeometry().getNumberOfRows()) {
                int col = 1;
                while (col <= mapping.getPlateGeometry().getNumberOfColumns()) {
                    List<MaterialIdentifier> genes = mapping.getMaterialsForWell(row, col);
                    result[0][resultIdx] = new Object[genes.size()];
                    int i = 0;
                    while (i < genes.size()) {
                        result[0][resultIdx][i] = genes.get(i).getMaterialCode();
                        ++i;
                    }
                    PlateIdentifier plate = mapping.getPlateIdentifier();
                    result[1][resultIdx] = new Object[]{OpenBISScreeningML.createPlateWellDescription(plate, row, col), plate.getAugmentedCode(), plate.getPermId(), plate.tryGetSpaceCode(), plate.getPlateCode(), row, col};
                    ++resultIdx;
                    ++col;
                }
                ++row;
            }
        }
        return result;
    }

    public static PlateMetadata[] getPlateMetadataList(String[] platesCodes) {
        OpenBISScreeningML.checkLoggedIn();
        List metadataList = openbis.getPlateMetadataList(OpenBISScreeningML.toPlates(platesCodes));
        return metadataList.toArray(new PlateMetadata[0]);
    }

    private static RuntimeException createException(String message, Throwable cause) {
        Throwable originalCause = cause;
        while (originalCause.getCause() != null) {
            originalCause = originalCause.getCause();
        }
        return new RuntimeException(String.valueOf(message) + " Reason: " + originalCause, cause);
    }

    private static List<PlateIdentifier> toPlates(String[] augmentedPlateCodes) {
        ArrayList<PlateIdentifier> result = new ArrayList<PlateIdentifier>(augmentedPlateCodes.length);
        String[] stringArray = augmentedPlateCodes;
        int n = augmentedPlateCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String plateCode = stringArray[n2];
            result.add(PlateIdentifier.createFromAugmentedCode(plateCode));
            ++n2;
        }
        return result;
    }

    private static Object[][] listProperties(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return new Object[0][];
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(properties.entrySet());
        Object[][] result = new Object[list.size()][2];
        int i = 0;
        while (i < list.size()) {
            result[i] = new Object[]{((Map.Entry)list.get(i)).getKey(), ((Map.Entry)list.get(i)).getValue()};
            ++i;
        }
        return result;
    }

    private static Plate getPlate(String augmentedPlateCode) {
        Plate plateIdentifier = plateCodeToPlateMap.get(augmentedPlateCode);
        if (plateIdentifier == null) {
            throw new RuntimeException("No plate with that code '" + augmentedPlateCode + "' found.");
        }
        return plateIdentifier;
    }

    private static ExperimentIdentifier getExperimentIdentifierOrFail(String experiment) {
        ExperimentIdentifier experimentIdentifier = experimentCodeToExperimentMap.get(experiment);
        if (experimentIdentifier == null) {
            String errorMessage = String.format("No experiment with code '%s' found.", experiment);
            throw new RuntimeException(errorMessage);
        }
        return experimentIdentifier;
    }

    private static String createPlateWellDescription(PlateIdentifier p, FeatureVector f) {
        return OpenBISScreeningML.createPlateWellDescription(p, f.getWellPosition().getWellRow(), f.getWellPosition().getWellColumn());
    }

    private static String createPlateWellDescription(PlateIdentifier p, int row, int col) {
        return String.valueOf(p.getPlateCode()) + ":" + OpenBISScreeningML.translateRowNumberIntoLetterCode(row) + col;
    }

    private static String translateRowNumberIntoLetterCode(int rowNumber) {
        int rowIndex = rowNumber - 1;
        String code = "";
        while (rowIndex >= 0) {
            code = String.valueOf((char)(rowIndex % 26 + 65)) + code;
            rowIndex = rowIndex / 26 - 1;
        }
        return code;
    }

    private static void checkLoggedIn() {
        if (openbis == null) {
            block19: {
                if (Login.OPENBIS_TOKEN_FILE.exists()) {
                    BufferedReader br = null;
                    try {
                        try {
                            br = new BufferedReader(new FileReader(Login.OPENBIS_TOKEN_FILE));
                            String token = br.readLine();
                            br.close();
                            br = new BufferedReader(new FileReader(Login.OPENBIS_SERVER_URL_FILE));
                            String serverUrl = br.readLine();
                            br.close();
                            br = null;
                            IScreeningOpenbisServiceFacade facade = facadeFactory.tryToCreate(token, serverUrl);
                            if (facade == null) {
                                throw new RuntimeException("Login failed.");
                            }
                            OpenBISScreeningML.init(facade);
                        }
                        catch (IOException ex) {
                            if (openbis == null) {
                                throw OpenBISScreeningML.createException("Login failed.", ex);
                            }
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (openbis == null) {
                throw new RuntimeException("Not logged in.");
            }
        }
    }

    private static interface ITileNumberIterable
    extends Iterable<Integer> {
        public void setMaximumNumberOfTiles(int var1);

        public int getMaximumNumberOfTiles();
    }

    private static final class ImageReferenceAndFile {
        private final PlateImageReference imageReference;
        private final File imageFile;
        private BufferedOutputStream outputStream;

        ImageReferenceAndFile(PlateImageReference imageReference, File imageFile) {
            this.imageReference = imageReference;
            this.imageFile = imageFile;
        }

        public PlateImageReference getImageReference() {
            return this.imageReference;
        }

        public File getImageFile() {
            return this.imageFile;
        }

        public OutputStream open() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.imageFile));
            }
            return this.outputStream;
        }

        public void close() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.outputStream = null;
        }
    }

    private static final class IndexSet<T extends Comparable<T>> {
        private final Map<T, Integer> indexMap = new HashMap<T, Integer>();
        private final Set<T> set = new TreeSet<T>();

        private IndexSet() {
        }

        public void add(T item) {
            this.set.add(item);
        }

        public int getIndex(T item) {
            Integer index;
            if (this.set.size() != this.indexMap.size()) {
                ArrayList<T> items = new ArrayList<T>(this.set);
                int i = 0;
                while (i < items.size()) {
                    this.indexMap.put((Comparable)items.get(i), i);
                    ++i;
                }
            }
            if ((index = this.indexMap.get(item)) == null) {
                throw new IllegalArgumentException("Unknown item: " + item);
            }
            return index;
        }

        public int size() {
            return this.set.size();
        }
    }
}

