/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.impl;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IFeatureDefinition;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureDefinition;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import java.util.ArrayList;
import java.util.List;

public class FeatureVectorDataSetInformation
extends DataSetInformation {
    private static final long serialVersionUID = 35L;
    private List<FeatureDefinition> features = new ArrayList<FeatureDefinition>();

    public void setAnalysisProcedure(String analysisProcedure) {
        this.getDataSetProperties().add(new NewProperty("$ANALYSIS_PROCEDURE", analysisProcedure));
    }

    public List<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<FeatureDefinition> features) {
        this.features = features;
    }

    public boolean isValid() {
        return this.features != null && this.features.size() > 0;
    }

    public IFeatureDefinition defineFeature(String featureCode) {
        assert (!StringUtils.isBlank((String)featureCode)) : "Feature code is blank " + featureCode;
        FeatureDefinition featureDefinitionValues = new FeatureDefinition(FeatureVectorDataSetInformation.createFeatureDefinition(featureCode));
        this.features.add(featureDefinitionValues);
        return featureDefinitionValues;
    }

    private static ImgFeatureDefDTO createFeatureDefinition(String featureCode) {
        ImgFeatureDefDTO dto = new ImgFeatureDefDTO();
        dto.setCode(featureCode);
        dto.setLabel(featureCode);
        return dto;
    }
}

