/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import java.awt.image.BufferedImage;

@JsonObject(value="BitShiftingImageTransformerFactory")
final class BitShiftingImageTransformerFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final int shiftBits;

    public BitShiftingImageTransformerFactory(int shiftBits) {
        this.shiftBits = shiftBits;
    }

    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            public BufferedImage transform(BufferedImage image) {
                if (IntensityRescaling.isNotGrayscale((BufferedImage)image)) {
                    return image;
                }
                return IntensityRescaling.rescaleIntensityBitShiftTo8Bits((BufferedImage)image, (int)BitShiftingImageTransformerFactory.this.shiftBits);
            }
        };
    }
}

