/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.featurevector;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CsvFileReaderHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

class FeatureVectorStorageProcessorConfiguration
implements CsvFileReaderHelper.ICsvFileReaderConfiguration {
    private static final String DEFAULT_COLUMNS_TO_BE_IGNORED = "barcode";
    @Private
    static final String COLUMNS_TO_BE_IGNORED_KEY = "columns-to-be-ignored";
    private static final String SEPARATOR_PROPERTY_KEY = "separator";
    private static final String IGNORE_COMMENTS_PROPERTY_KEY = "ignore-comments";
    private static final String WELL_NAME_ROW_PROPERTY_KEY = "well-name-row";
    private static final String WELL_NAME_COL_PROPERTY_KEY = "well-name-col";
    private static final char DEFAULT_DELIMITER = ';';
    private static final String DEFAULT_WELL_ROW = "WellName";
    private static final String DEFAULT_WELL_COL = "WellName";
    private final char columnDelimiter;
    private final boolean ignoreComments;
    private final char comment = (char)35;
    private final String wellRow;
    private final String wellColumn;
    private final Set<String> columnsToBeIgnored;

    FeatureVectorStorageProcessorConfiguration(Properties properties) {
        this.columnDelimiter = PropertyUtils.getChar((Properties)properties, (String)SEPARATOR_PROPERTY_KEY, (char)';');
        this.ignoreComments = PropertyUtils.getBoolean((Properties)properties, (String)IGNORE_COMMENTS_PROPERTY_KEY, (boolean)true);
        this.wellRow = properties.getProperty(WELL_NAME_ROW_PROPERTY_KEY, "WellName");
        this.wellColumn = properties.getProperty(WELL_NAME_COL_PROPERTY_KEY, "WellName");
        this.columnsToBeIgnored = new HashSet<String>(Arrays.asList(properties.getProperty(COLUMNS_TO_BE_IGNORED_KEY, DEFAULT_COLUMNS_TO_BE_IGNORED).split(", *")));
    }

    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public char getCommentDelimiter() {
        return this.comment;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public boolean isSkipEmptyRecords() {
        return true;
    }

    public String getWellRow() {
        return this.wellRow;
    }

    public String getWellColumn() {
        return this.wellColumn;
    }

    public final Set<String> getColumnsToBeIgnored() {
        return this.columnsToBeIgnored;
    }
}

