/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractImagesDownloadServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.IDatasetImageOverviewPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ImageChannelsUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageGenerationDescription;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ImageResolutionKind;
import java.io.IOException;
import java.util.Properties;

public class MergingImagesDownloadServlet
extends AbstractImagesDownloadServlet
implements IDatasetImageOverviewPlugin {
    private static final long serialVersionUID = 1L;
    private static final Size DEFAULT_THUMBNAIL_SIZE = new Size(200, 120);

    public MergingImagesDownloadServlet(Properties pluginProperties) {
    }

    public MergingImagesDownloadServlet() {
    }

    @Override
    protected final ResponseContentStream createImageResponse(ImageGenerationDescription params, IHierarchicalContentProvider contentProvider) throws IOException, EnvironmentFailureException {
        return ImageChannelsUtils.getImageStream(params, contentProvider);
    }

    public ResponseContentStream createImageOverview(String datasetCode, String datasetTypeCode, IHierarchicalContent datasetRoot, ImageResolutionKind resolution) {
        Size thumbnailSize = MergingImagesDownloadServlet.tryGetThumbnailSize(resolution);
        return ImageChannelsUtils.getRepresentativeImageStream(datasetRoot, datasetCode, null, thumbnailSize, null);
    }

    private static Size tryGetThumbnailSize(ImageResolutionKind resolution) {
        if (resolution == ImageResolutionKind.NORMAL) {
            return null;
        }
        return DEFAULT_THUMBNAIL_SIZE;
    }
}

