/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.image.MixColors;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.common.io.ByteArrayBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetLoaderFactory;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.IImagingLoaderStrategy;
import ch.systemsx.cisd.openbis.dss.etl.ImagingLoaderStrategyFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageTransfomationFactories;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.AutoRescaleIntensityImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ResponseContentStream;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ColorComponentImageChannelMerger;
import ch.systemsx.cisd.openbis.dss.generic.server.images.RepresentationUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.DatasetAcquiredImagesReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageGenerationDescription;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageTransformationParams;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImageChannelsUtils {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageChannelsUtils.class);
    public static final String IMAGES_CONTENT_TYPE = "image/png";
    private final IImagingLoaderStrategy imageLoaderStrategy;
    private final RequestedImageSize imageSizeLimit;
    private final String singleChannelTransformationCodeOrNull;

    @Private
    ImageChannelsUtils(IImagingLoaderStrategy imageLoaderStrategy, RequestedImageSize imageSizeLimit, String singleChannelTransformationCodeOrNull) {
        this.imageLoaderStrategy = imageLoaderStrategy;
        this.imageSizeLimit = imageSizeLimit;
        this.singleChannelTransformationCodeOrNull = singleChannelTransformationCodeOrNull;
    }

    @Private
    ImageChannelsUtils(IImagingLoaderStrategy imageLoaderStrategy, Size imageSizeLimitOrNull, String singleChannelTransformationCodeOrNull) {
        this(imageLoaderStrategy, new RequestedImageSize(imageSizeLimitOrNull, false), singleChannelTransformationCodeOrNull);
    }

    static IHierarchicalContentNode tryGetRawContentOfExistingThumbnail(ImageGenerationDescription params, ImageRepresentationFormat format) {
        String sessionToken = params.getSessionId();
        String dataSetCode = params.tryGetImageChannels().getDatasetCode();
        ImageChannelStackReference channelStackRef = params.tryGetImageChannels().getChannelStackReference();
        String transformation = params.tryGetSingleChannelTransformationCode();
        String channel = params.tryGetImageChannels().getChannelCodes(null).get(0);
        IHierarchicalContentProvider contentProvider = ServiceProvider.getHierarchicalContentProvider();
        OpenBISSessionHolder sessionTokenHolder = new OpenBISSessionHolder();
        sessionTokenHolder.setSessionToken(sessionToken);
        contentProvider = contentProvider.cloneFor((ISessionTokenProvider)sessionTokenHolder);
        IHierarchicalContent content = contentProvider.asContent(dataSetCode);
        IImagingDatasetLoader loader = HCSImageDatasetLoaderFactory.tryCreate(content, dataSetCode);
        if (format.isOriginal()) {
            return loader.tryGetImage(channel, channelStackRef, new RequestedImageSize(null, false, false), transformation).tryGetRawContent();
        }
        return loader.tryGetThumbnail(channel, channelStackRef, new RequestedImageSize(params.tryGetThumbnailSize(), false, false), transformation).tryGetRawContent();
    }

    public static ResponseContentStream getImageStream(ImageGenerationDescription params, IHierarchicalContentProvider contentProvider) {
        IHierarchicalContentNode content;
        Size thumbnailSizeOrNull = params.tryGetThumbnailSize();
        ImageRepresentationFormat existingRepresentationFormat = RepresentationUtil.tryGetRepresentationFormat(params);
        if (existingRepresentationFormat != null && (content = ImageChannelsUtils.tryGetRawContentOfExistingThumbnail(params, existingRepresentationFormat)) != null) {
            return ImageChannelsUtils.asResponseContentStream(content);
        }
        BufferedImage image = null;
        DatasetAcquiredImagesReference imageChannels = params.tryGetImageChannels();
        if (imageChannels != null) {
            RequestedImageSize imageSize = new RequestedImageSize(thumbnailSizeOrNull, false);
            image = ImageChannelsUtils.calculateBufferedImage(imageChannels, params.tryGetSingleChannelTransformationCode(), params.tryGetTransformationsPerChannel(), contentProvider, imageSize);
        }
        RequestedImageSize overlaySize = ImageChannelsUtils.calcOverlaySize(image, thumbnailSizeOrNull);
        for (DatasetAcquiredImagesReference overlayChannels : params.getOverlayChannels()) {
            List<ImageWithReference> overlayImages = ImageChannelsUtils.getSingleImagesSkipNonExisting(overlayChannels, overlaySize, params.tryGetSingleChannelTransformationCode(), contentProvider);
            for (ImageWithReference overlayImage : overlayImages) {
                if (image != null) {
                    ImageChannelsUtils.drawOverlay(image, overlayImage);
                    continue;
                }
                image = overlayImage.getBufferedImage();
            }
        }
        if (image == null) {
            throw new UserFailureException("No image is available for parameters: " + params);
        }
        return ImageChannelsUtils.createResponseContentStream(image, null);
    }

    private static List<ImageWithReference> getSingleImagesSkipNonExisting(DatasetAcquiredImagesReference imagesReference, RequestedImageSize imageSize, String singleChannelTransformationCodeOrNull, IHierarchicalContentProvider contentProvider) {
        ImageChannelsUtils utils = ImageChannelsUtils.createImageChannelsUtils(imagesReference, contentProvider, imageSize, singleChannelTransformationCodeOrNull);
        boolean mergeAllChannels = utils.isMergeAllChannels(imagesReference);
        ImageTransformationParams transformationInfo = new ImageTransformationParams(true, mergeAllChannels, null, new HashMap<String, String>());
        List<AbsoluteImageReference> imageContents = utils.fetchImageContents(imagesReference, mergeAllChannels, true, transformationInfo);
        return ImageChannelsUtils.calculateSingleImagesForDisplay(imageContents, transformationInfo, Float.valueOf(0.0f), null);
    }

    private static RequestedImageSize getSize(BufferedImage img, boolean highQuality) {
        return new RequestedImageSize(new Size(img.getWidth(), img.getHeight()), true, highQuality);
    }

    private static RequestedImageSize calcOverlaySize(BufferedImage imageOrNull, Size thumbnailSizeOrNull) {
        if (thumbnailSizeOrNull == null) {
            return RequestedImageSize.createOriginal();
        }
        boolean highQuality = true;
        if (imageOrNull != null) {
            return ImageChannelsUtils.getSize(imageOrNull, highQuality);
        }
        return new RequestedImageSize(thumbnailSizeOrNull, false, highQuality);
    }

    private static ResponseContentStream createResponseContentStream(BufferedImage image, String nameOrNull) {
        IHierarchicalContentNode imageContent = ImageChannelsUtils.createPngContent(image, nameOrNull);
        return ImageChannelsUtils.asResponseContentStream(imageContent);
    }

    private static BufferedImage calculateBufferedImage(DatasetAcquiredImagesReference imageChannels, String singleChannelTransformationCodeOrNull, Map<String, String> transformationsPerChannels, IHierarchicalContentProvider contentProvider, RequestedImageSize imageSizeLimit) {
        ImageChannelsUtils imageChannelsUtils = ImageChannelsUtils.createImageChannelsUtils(imageChannels, contentProvider, imageSizeLimit, singleChannelTransformationCodeOrNull);
        boolean useMergedChannelsTransformation = imageChannelsUtils.isMergeAllChannels(imageChannels);
        ImageTransformationParams transformationInfo = new ImageTransformationParams(true, useMergedChannelsTransformation, singleChannelTransformationCodeOrNull, transformationsPerChannels);
        return imageChannelsUtils.calculateBufferedImage(imageChannels, transformationInfo);
    }

    private static ImageChannelsUtils createImageChannelsUtils(DatasetAcquiredImagesReference imageChannels, IHierarchicalContentProvider contentProvider, RequestedImageSize imageSizeLimit, String singleChannelTransformationCodeOrNull) {
        IImagingDatasetLoader imageAccessor = ImageChannelsUtils.createImageAccessor(imageChannels, contentProvider);
        return new ImageChannelsUtils(ImagingLoaderStrategyFactory.createImageLoaderStrategy(imageAccessor), imageSizeLimit, singleChannelTransformationCodeOrNull);
    }

    @Private
    BufferedImage calculateBufferedImage(DatasetAcquiredImagesReference imageChannels, ImageTransformationParams transformationInfo) {
        boolean mergeAllChannels = this.isMergeAllChannels(imageChannels);
        List<AbsoluteImageReference> imageContents = this.fetchImageContents(imageChannels, mergeAllChannels, false, transformationInfo);
        return ImageChannelsUtils.calculateBufferedImage(imageContents, transformationInfo);
    }

    private boolean isMergeAllChannels(DatasetAcquiredImagesReference imageChannels) {
        return imageChannels.isMergeAllChannels(this.getAllChannelCodes());
    }

    private List<AbsoluteImageReference> fetchImageContents(DatasetAcquiredImagesReference imagesReference, boolean mergeAllChannels, boolean skipNonExisting, ImageTransformationParams transformationInfo) {
        AbsoluteImageReference allChannelsImageReference;
        List<String> channelCodes = imagesReference.getChannelCodes(this.getAllChannelCodes());
        ArrayList<AbsoluteImageReference> images = new ArrayList<AbsoluteImageReference>();
        for (String channelCode : channelCodes) {
            ImageChannelStackReference channelStackReference;
            AbsoluteImageReference image = this.imageLoaderStrategy.tryGetImage(channelCode, channelStackReference = imagesReference.getChannelStackReference(), this.imageSizeLimit, this.singleChannelTransformationCodeOrNull);
            if (image == null && !skipNonExisting) {
                throw this.createImageNotFoundException(channelStackReference, channelCode);
            }
            if (image == null) continue;
            images.add(image);
        }
        if (mergeAllChannels && !this.shouldApplySingleChannelsTransformations(transformationInfo) && (allChannelsImageReference = ImageChannelsUtils.tryCreateAllChannelsImageReference(images)) != null) {
            images.clear();
            images.add(allChannelsImageReference);
        }
        return images;
    }

    private boolean shouldApplySingleChannelsTransformations(ImageTransformationParams transformationInfo) {
        return transformationInfo != null && transformationInfo.tryGetTransformationCodeForChannels() != null && transformationInfo.tryGetTransformationCodeForChannels().size() != 0;
    }

    private static IImagingDatasetLoader createImageAccessor(DatasetAcquiredImagesReference imagesReference, IHierarchicalContentProvider contentProvider) {
        String datasetCode = imagesReference.getDatasetCode();
        IHierarchicalContent dataSetRoot = contentProvider.asContent(datasetCode);
        return ImageChannelsUtils.createDatasetLoader(dataSetRoot, datasetCode);
    }

    public static ResponseContentStream getRepresentativeImageStream(IHierarchicalContent dataSetRoot, String datasetCode, Location wellLocationOrNull, Size imageSizeLimitOrNull, String singleChannelTransformationCodeOrNull) {
        IImagingDatasetLoader imageAccessor = ImageChannelsUtils.createDatasetLoader(dataSetRoot, datasetCode);
        List<AbsoluteImageReference> imageReferences = new ImageChannelsUtils(ImagingLoaderStrategyFactory.createImageLoaderStrategy(imageAccessor), imageSizeLimitOrNull, singleChannelTransformationCodeOrNull).getRepresentativeImageReferences(wellLocationOrNull);
        BufferedImage image = ImageChannelsUtils.calculateBufferedImage(imageReferences, new ImageTransformationParams(true, true, null, new HashMap<String, String>()));
        String name = ImageChannelsUtils.createFileName(datasetCode, wellLocationOrNull, imageSizeLimitOrNull);
        return ImageChannelsUtils.createResponseContentStream(image, name);
    }

    private static IImagingDatasetLoader createDatasetLoader(IHierarchicalContent dataSetRoot, String datasetCode) {
        IImagingDatasetLoader loader = HCSImageDatasetLoaderFactory.tryCreate(dataSetRoot, datasetCode);
        if (loader == null) {
            throw new IllegalStateException(String.format("Dataset '%s' not found in the imaging database.", datasetCode));
        }
        return loader;
    }

    private static String createFileName(String datasetCode, Location wellLocationOrNull, Size imageSizeLimitOrNull) {
        String name = "dataset_" + datasetCode;
        if (wellLocationOrNull != null) {
            name = String.valueOf(name) + "_row" + wellLocationOrNull.getY();
            name = String.valueOf(name) + "_col" + wellLocationOrNull.getX();
        }
        if (imageSizeLimitOrNull != null) {
            name = String.valueOf(name) + "_small";
        }
        name = String.valueOf(name) + ".png";
        return name;
    }

    private static ResponseContentStream asResponseContentStream(IHierarchicalContentNode imageContent) {
        return ResponseContentStream.create((InputStream)imageContent.getInputStream(), (long)imageContent.getFileLength(), (String)IMAGES_CONTENT_TYPE, (String)imageContent.getName());
    }

    public static IHierarchicalContentNode getImage(IImagingLoaderStrategy imageLoaderStrategy, ImageChannelStackReference channelStackReference, String chosenChannelCode, Size imageSizeLimitOrNull, String singleChannelImageTransformationCodeOrNull, boolean convertToPng, boolean transform) {
        ImageTransformationParams transformationInfo;
        boolean mergeAllChannels;
        ImageChannelsUtils imageChannelsUtils = new ImageChannelsUtils(imageLoaderStrategy, imageSizeLimitOrNull, singleChannelImageTransformationCodeOrNull);
        DatasetAcquiredImagesReference imagesReference = ImageChannelsUtils.createDatasetAcquiredImagesReference(imageLoaderStrategy, channelStackReference, chosenChannelCode == null ? "Merged Channels" : chosenChannelCode);
        List<AbsoluteImageReference> imageContents = imageChannelsUtils.fetchImageContents(imagesReference, mergeAllChannels = imageChannelsUtils.isMergeAllChannels(imagesReference), false, transformationInfo = new ImageTransformationParams(transform, mergeAllChannels, singleChannelImageTransformationCodeOrNull, new HashMap<String, String>()));
        IHierarchicalContentNode contentNode = ImageChannelsUtils.tryGetRawContent(convertToPng, imageContents);
        if (contentNode != null) {
            return contentNode;
        }
        BufferedImage image = ImageChannelsUtils.calculateBufferedImage(imageContents, transformationInfo);
        return ImageChannelsUtils.createPngContent(image, null);
    }

    private static DatasetAcquiredImagesReference createDatasetAcquiredImagesReference(IImagingLoaderStrategy imageLoaderStrategy, ImageChannelStackReference channelStackReference, String chosenChannelCode) {
        String datasetCode = imageLoaderStrategy.getImageParameters().getDatasetCode();
        boolean isMergedChannels = "Merged Channels".equalsIgnoreCase(chosenChannelCode);
        if (isMergedChannels) {
            return DatasetAcquiredImagesReference.createForMergedChannels(datasetCode, channelStackReference);
        }
        return DatasetAcquiredImagesReference.createForSingleChannel(datasetCode, channelStackReference, chosenChannelCode);
    }

    private static IHierarchicalContentNode tryGetRawContent(boolean convertToPng, List<AbsoluteImageReference> imageContents) {
        if (imageContents.size() == 1 && !convertToPng) {
            AbsoluteImageReference imageReference = imageContents.get(0);
            return imageReference.tryGetRawContentForOriginalImage();
        }
        return null;
    }

    private List<AbsoluteImageReference> getRepresentativeImageReferences(Location wellLocationOrNull) {
        ArrayList<AbsoluteImageReference> images = new ArrayList<AbsoluteImageReference>();
        for (String chosenChannel : this.getAllChannelCodes()) {
            AbsoluteImageReference image = this.getRepresentativeImageReference(chosenChannel, wellLocationOrNull);
            images.add(image);
        }
        return images;
    }

    private List<String> getAllChannelCodes() {
        return this.imageLoaderStrategy.getImageParameters().getChannelsCodes();
    }

    private AbsoluteImageReference getRepresentativeImageReference(String channelCode, Location wellLocationOrNull) {
        AbsoluteImageReference image = this.imageLoaderStrategy.tryGetRepresentativeImage(channelCode, wellLocationOrNull, this.imageSizeLimit, this.singleChannelTransformationCodeOrNull);
        if (image != null) {
            return image;
        }
        throw EnvironmentFailureException.fromTemplate((String)("No representative " + (this.imageSizeLimit.isThumbnailRequired() ? "thumbnail" : "image") + " found for well %s and channel %s"), (Object[])new Object[]{wellLocationOrNull, channelCode});
    }

    private static BufferedImage calculateAndTransformSingleImageForDisplay(AbsoluteImageReference imageReference, ImageTransformationParams transformationInfo, Float threshold) {
        BufferedImage image = ImageChannelsUtils.calculateSingleImage(imageReference);
        image = ImageChannelsUtils.transform(image, imageReference, transformationInfo);
        image = threshold == null ? ImageUtil.convertForDisplayIfNecessary((BufferedImage)image) : ImageUtil.convertForDisplayIfNecessary((BufferedImage)image, (float)threshold.floatValue());
        return image;
    }

    private static BufferedImage calculateSingleImage(AbsoluteImageReference imageReference) {
        ColorComponent colorComponentOrNull;
        RequestedImageSize requestedSize;
        Size size;
        long start = operationLog.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        BufferedImage image = imageReference.getUnchangedImage();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Load original image: " + (System.currentTimeMillis() - start)));
        }
        if ((size = (requestedSize = imageReference.getRequestedSize()).tryGetThumbnailSize()) != null) {
            start = operationLog.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            image = ImageUtil.rescale((BufferedImage)image, (int)size.getWidth(), (int)size.getHeight(), (boolean)requestedSize.enlargeIfNecessary(), (boolean)requestedSize.isHighQualityRescalingRequired());
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)("Create thumbnail: " + (System.currentTimeMillis() - start)));
            }
        }
        if ((colorComponentOrNull = imageReference.tryGetColorComponent()) != null) {
            start = operationLog.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            image = ImageChannelsUtils.transformToChannel(image, colorComponentOrNull);
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)("Select single channel: " + (System.currentTimeMillis() - start)));
            }
        }
        return image;
    }

    private static BufferedImage calculateBufferedImage(List<AbsoluteImageReference> imageReferences, ImageTransformationParams transformationInfo) {
        AbsoluteImageReference singleImageReference = imageReferences.get(0);
        if (imageReferences.size() == 1) {
            return ImageChannelsUtils.calculateAndTransformSingleImageForDisplay(singleImageReference, transformationInfo, null);
        }
        IImageTransformerFactory mergedChannelTransformationOrNull = singleImageReference.getImageTransfomationFactories().tryGetForMerged();
        return ImageChannelsUtils.mergeChannels(imageReferences, transformationInfo, mergedChannelTransformationOrNull);
    }

    private static BufferedImage mergeChannels(List<AbsoluteImageReference> imageReferences, ImageTransformationParams transformationInfo, IImageTransformerFactory mergedChannelTransformationOrNull) {
        List<ImageWithReference> images = ImageChannelsUtils.calculateSingleImagesForDisplay(imageReferences, null, null, transformationInfo);
        BufferedImage mergedImage = ImageChannelsUtils.mergeImages(images);
        if (transformationInfo.isApplyNonImageLevelTransformation()) {
            mergedImage = ImageChannelsUtils.applyImageTransformation(mergedImage, mergedChannelTransformationOrNull);
        }
        return mergedImage;
    }

    private static BufferedImage transform(BufferedImage image, AbsoluteImageReference imageReference, ImageTransformationParams transformationInfo) {
        BufferedImage resultImage = image;
        ImageTransfomationFactories transfomations = imageReference.getImageTransfomationFactories();
        resultImage = ImageChannelsUtils.applyImageTransformation(resultImage, transfomations.tryGetForImage());
        if (!transformationInfo.isApplyNonImageLevelTransformation()) {
            return resultImage;
        }
        IImageTransformerFactory channelLevelTransformationOrNull = null;
        if (transformationInfo.isUseMergedChannelsTransformation()) {
            channelLevelTransformationOrNull = transfomations.tryGetForMerged();
        } else {
            String channelTransformationCode;
            String string = channelTransformationCode = transformationInfo.tryGetSingleChannelTransformationCode() == null ? transfomations.tryGetDefaultTransformationCode() : transformationInfo.tryGetSingleChannelTransformationCode();
            if (channelTransformationCode != null && !channelTransformationCode.equals(imageReference.tryGetSingleChannelTransformationCode())) {
                channelLevelTransformationOrNull = transfomations.tryGetForChannel(transformationInfo.tryGetSingleChannelTransformationCode());
            }
            if (channelLevelTransformationOrNull == null) {
                channelLevelTransformationOrNull = new AutoRescaleIntensityImageTransformerFactory(0.01f);
            }
        }
        return ImageChannelsUtils.applyImageTransformation(resultImage, channelLevelTransformationOrNull);
    }

    private static BufferedImage applyImageTransformation(BufferedImage image, IImageTransformerFactory transformerFactoryOrNull) {
        if (transformerFactoryOrNull == null) {
            return image;
        }
        return transformerFactoryOrNull.createTransformer().transform(image);
    }

    private static List<ImageWithReference> calculateSingleImagesForDisplay(List<AbsoluteImageReference> imageReferences, ImageTransformationParams transformationInfoOrNull, Float threshold, ImageTransformationParams transformationInfoForMergingOrNull) {
        ArrayList<ImageWithReference> images = new ArrayList<ImageWithReference>();
        for (AbsoluteImageReference imageRef : imageReferences) {
            BufferedImage image;
            if (transformationInfoOrNull != null) {
                image = ImageChannelsUtils.calculateAndTransformSingleImageForDisplay(imageRef, transformationInfoOrNull, threshold);
            } else if (transformationInfoForMergingOrNull != null && transformationInfoForMergingOrNull.tryGetTransformationCodeForChannel(imageRef.tryGetChannelCode()) != null) {
                String transformationCode = transformationInfoForMergingOrNull.tryGetTransformationCodeForChannel(imageRef.tryGetChannelCode());
                image = ImageChannelsUtils.calculateAndTransformSingleImageForDisplay(imageRef, new ImageTransformationParams(transformationInfoForMergingOrNull.isApplyNonImageLevelTransformation(), false, transformationCode, null), threshold);
            } else {
                image = ImageChannelsUtils.calculateSingleImage(imageRef);
                image = threshold == null ? ImageUtil.convertForDisplayIfNecessary((BufferedImage)image) : ImageUtil.convertForDisplayIfNecessary((BufferedImage)image, (float)threshold.floatValue());
            }
            images.add(new ImageWithReference(image, imageRef));
        }
        return images;
    }

    private static AbsoluteImageReference tryCreateAllChannelsImageReference(List<AbsoluteImageReference> imageReferences) {
        AbsoluteImageReference lastFound = null;
        for (AbsoluteImageReference image : imageReferences) {
            if (lastFound == null) {
                lastFound = image;
                continue;
            }
            if (ImageChannelsUtils.equals(image.tryGetImageID(), lastFound.tryGetImageID()) && image.getUniqueId().equals(lastFound.getUniqueId())) continue;
            return null;
        }
        if (lastFound != null) {
            return lastFound.createWithoutColorComponent();
        }
        return null;
    }

    private static boolean equals(String i1OrNull, String i2OrNull) {
        return i1OrNull == null ? i2OrNull == null : i1OrNull.equals(i2OrNull);
    }

    private static BufferedImage mergeImages(List<ImageWithReference> images) {
        BufferedImage[] bufferedImages = new BufferedImage[images.size()];
        Color[] colors = new Color[images.size()];
        int i = 0;
        while (i < images.size()) {
            ImageWithReference image = images.get(i);
            bufferedImages[i] = image.getBufferedImage();
            colors[i] = ImageChannelsUtils.getColor(image);
            ++i;
        }
        ColorComponent[] colorComponents = ImageChannelsUtils.tryExtractColorComponent(images);
        if (colorComponents != null) {
            return ColorComponentImageChannelMerger.mergeByExtractingComponents(bufferedImages, colorComponents);
        }
        return MixColors.mixImages((BufferedImage[])bufferedImages, (Color[])colors, (boolean)false, (float)0.0f);
    }

    private static Color getColor(ImageWithReference image) {
        return ImageChannelsUtils.getColor(image.getReference().getChannelColor());
    }

    private static Color getColor(ChannelColorRGB color) {
        return new Color(color.getR(), color.getG(), color.getB());
    }

    private static ColorComponent[] tryExtractColorComponent(List<ImageWithReference> images) {
        ColorComponent[] components = new ColorComponent[images.size()];
        int i = 0;
        for (ImageWithReference image : images) {
            ColorComponent colorComponent = image.getReference().tryGetColorComponent();
            if (colorComponent == null) {
                if (i == 0) {
                    return null;
                }
                throw new IllegalStateException("Some images have color component set and some have it unset.");
            }
            components[i++] = colorComponent;
        }
        return components;
    }

    private static void drawOverlay(BufferedImage image, ImageWithReference overlayImage) {
        BufferedImage overlayBufferedImage = overlayImage.getBufferedImage();
        if (ImageChannelsUtils.supportsTransparency(overlayImage)) {
            ImageChannelsUtils.drawTransparentOverlayFast(image, overlayBufferedImage);
        } else {
            ImageChannelsUtils.drawOverlaySlow(image, overlayBufferedImage);
        }
    }

    private static void drawTransparentOverlayFast(BufferedImage image, BufferedImage overlayBufferedImage) {
        Graphics2D graphics = image.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(3);
        graphics.setComposite(ac);
        graphics.drawImage(overlayBufferedImage, null, null);
    }

    private static void drawOverlaySlow(BufferedImage image, BufferedImage overlayImage) {
        int width = Math.min(image.getWidth(), overlayImage.getWidth());
        int height = Math.min(image.getHeight(), overlayImage.getHeight());
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int imageRGB = image.getRGB(x, y);
                int overlayRGB = overlayImage.getRGB(x, y);
                int overlayedRGB = ImageChannelsUtils.overlayRGBColor(imageRGB, overlayRGB);
                image.setRGB(x, y, overlayedRGB);
                ++x;
            }
            ++y;
        }
    }

    private static int overlayRGBColor(int imageRGB, int overlayRGB) {
        Color imageColor = new Color(imageRGB);
        Color overlayColor = new Color(overlayRGB, true);
        if (overlayColor.getAlpha() == 0) {
            return imageRGB;
        }
        int r = Math.max(imageColor.getRed(), overlayColor.getRed());
        int g = Math.max(imageColor.getGreen(), overlayColor.getGreen());
        int b = Math.max(imageColor.getBlue(), overlayColor.getBlue());
        return new Color(r, g, b).getRGB();
    }

    private static boolean supportsTransparency(ImageWithReference image) {
        return image.getBufferedImage().getColorModel().hasAlpha();
    }

    private EnvironmentFailureException createImageNotFoundException(ImageChannelStackReference channelStackReference, String chosenChannelCode) {
        return EnvironmentFailureException.fromTemplate((String)("No " + (this.imageSizeLimit.isThumbnailRequired() ? "thumbnail" : "image") + " found for channel stack %s and channel %s"), (Object[])new Object[]{channelStackReference, chosenChannelCode});
    }

    public static BufferedImage transformToChannel(BufferedImage bufferedImage, ColorComponent colorComponent) {
        BufferedImage newImage = ImageChannelsUtils.createNewRGBImage(bufferedImage);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int rgb = bufferedImage.getRGB(x, y);
                int channelColor = ImageChannelsUtils.extractSingleComponent(rgb, colorComponent);
                newImage.setRGB(x, y, channelColor);
                ++x;
            }
            ++y;
        }
        return newImage;
    }

    private static int extractSingleComponent(int rgb, ColorComponent colorComponent) {
        return colorComponent.extractSingleComponent(rgb).getRGB();
    }

    private static BufferedImage createNewRGBImage(RenderedImage bufferedImage) {
        BufferedImage newImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        return newImage;
    }

    private static IHierarchicalContentNode createPngContent(BufferedImage image, String nameOrNull) {
        byte[] output = ImageUtil.imageToPngFast((BufferedImage)image);
        return new ByteArrayBasedContentNode(output, nameOrNull);
    }

    public static interface IDatasetDirectoryProvider {
        public File getDatasetRoot(String var1);
    }

    private static class ImageWithReference {
        private final BufferedImage image;
        private final AbsoluteImageReference reference;

        public ImageWithReference(BufferedImage image, AbsoluteImageReference reference) {
            this.image = image;
            this.reference = reference;
        }

        public BufferedImage getBufferedImage() {
            return this.image;
        }

        public AbsoluteImageReference getReference() {
            return this.reference;
        }
    }
}

