/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.screening.shared.api.internal;

import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ITerminableFuture;
import ch.systemsx.cisd.common.concurrent.TerminableCallable;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningBatchResults;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.DssServiceRpcScreeningHolder;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningBatchHandler;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningFactory;
import ch.systemsx.cisd.openbis.dss.screening.shared.api.internal.IDssServiceRpcScreeningMultiplexer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class DssServiceRpcScreeningMultiplexer
implements IDssServiceRpcScreeningMultiplexer {
    private final IDssServiceRpcScreeningFactory dssServiceFactory;
    private final NamingThreadPoolExecutor executor;

    public DssServiceRpcScreeningMultiplexer(IDssServiceRpcScreeningFactory dssServiceFactory) {
        if (dssServiceFactory == null) {
            throw new IllegalArgumentException("Dss service factory cannot be null");
        }
        this.dssServiceFactory = dssServiceFactory;
        this.executor = new NamingThreadPoolExecutor("Dss service screening multiplexer").daemonize();
    }

    @Override
    public <R extends IDatasetIdentifier, V> DssServiceRpcScreeningBatchResults<V> process(List<? extends R> references, IDssServiceRpcScreeningBatchHandler<R, V> batchHandler) {
        Map<String, List<R>> referencesPerDataStore = DssServiceRpcScreeningMultiplexer.getReferencesPerDataStore(this.cast(references));
        Map<String, ITerminableFuture<List<V>>> futuresPerDataStore = this.submitReferencesToDataStores(referencesPerDataStore, batchHandler);
        return this.gatherResultsFromDataStores(futuresPerDataStore);
    }

    public static <R extends IDatasetIdentifier> Map<String, List<R>> getReferencesPerDataStore(List<R> references) {
        HashMap<String, List<R>> referencesPerDataStore = new HashMap<String, List<R>>();
        if (references != null) {
            for (IDatasetIdentifier reference : references) {
                String dataStoreUrl;
                if (reference == null || (dataStoreUrl = reference.getDatastoreServerUrl()) == null) continue;
                List<R> dataStoreReferences = referencesPerDataStore.get(dataStoreUrl);
                if (dataStoreReferences == null) {
                    dataStoreReferences = new ArrayList<R>();
                    referencesPerDataStore.put(dataStoreUrl, dataStoreReferences);
                }
                dataStoreReferences.add(reference);
            }
        }
        return referencesPerDataStore;
    }

    private <R extends IDatasetIdentifier, V> Map<String, ITerminableFuture<List<V>>> submitReferencesToDataStores(Map<String, List<R>> referencesPerDataStore, final IDssServiceRpcScreeningBatchHandler<R, V> batchHandler) {
        LinkedHashMap<String, ITerminableFuture<List<ITerminableFuture>>> futuresPerDataStore = new LinkedHashMap<String, ITerminableFuture<List<ITerminableFuture>>>();
        final long submitTime = System.currentTimeMillis();
        for (Map.Entry<String, List<R>> referencePerDataStore : referencesPerDataStore.entrySet()) {
            final String dataStoreUrl = referencePerDataStore.getKey();
            final List<R> dataStoreReferences = referencePerDataStore.getValue();
            ITerminableFuture dataStoreFuture = ConcurrencyUtilities.submit((ExecutorService)this.executor, (TerminableCallable.ICallable)new TerminableCallable.INamedCallable<List<V>>(){

                public List<V> call(TerminableCallable.IStoppableExecutor<List<V>> stoppableExecutor) throws Exception {
                    DssServiceRpcScreeningHolder dataStoreServiceHolder = DssServiceRpcScreeningMultiplexer.this.dssServiceFactory.createDssService(dataStoreUrl);
                    return batchHandler.handle(dataStoreServiceHolder, dataStoreReferences);
                }

                public String getCallableName() {
                    return String.valueOf(dataStoreUrl) + "(" + submitTime + ")";
                }
            });
            futuresPerDataStore.put(dataStoreUrl, dataStoreFuture);
        }
        return futuresPerDataStore;
    }

    /*
     * Unable to fully structure code
     */
    private <V> DssServiceRpcScreeningBatchResults<V> gatherResultsFromDataStores(Map<String, ITerminableFuture<List<V>>> futuresPerDataStore) {
        block4: {
            results = new DssServiceRpcScreeningBatchResults<T>();
            try {
                for (Map.Entry<String, ITerminableFuture<List<V>>> futurePerDataStore : futuresPerDataStore.entrySet()) {
                    dataStoreUrl = futurePerDataStore.getKey();
                    dataStoreFuture = futurePerDataStore.getValue();
                    dataStoreResults = (List)ConcurrencyUtilities.tryGetResult(dataStoreFuture, (long)-1L);
                    if (dataStoreResults == null) continue;
                    results.addDataStoreResults(dataStoreUrl, dataStoreResults);
                }
                break block4;
            }
            catch (RuntimeException e) {
                ** for (dataStoreFuture : futuresPerDataStore.values())
            }
lbl-1000:
            // 1 sources

            {
                dataStoreFuture.cancel(true);
                continue;
            }
lbl16:
            // 1 sources

            throw e;
        }
        return results;
    }

    private <R extends IDatasetIdentifier> List<R> cast(List<? extends R> references) {
        return references;
    }
}

