/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ContrastBrightness;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.gui.LutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class OperationPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ImageViewer imageViewer;
    private JTabbedPane operationTabPanel;
    private LutPanel lutPanel;
    private ContrastBrightness contrastBrightnessPanel;
    private ContrastBrightness colorPanel;
    private boolean isColorPanelDisplalyed = false;
    private JButton resetButton;
    private JButton revertButton;
    private JButton saveButton;

    public OperationPanel(ImageViewer imageViewer) {
        this.imageViewer = imageViewer;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.operationTabPanel = new JTabbedPane();
        this.operationTabPanel.setPreferredSize(new Dimension(350, 450));
        this.operationTabPanel.setFocusable(false);
        this.lutPanel = new LutPanel(imageViewer);
        this.lutPanel.setName("lut");
        this.operationTabPanel.addTab("LUT", this.lutPanel);
        this.operationTabPanel.setSelectedIndex(0);
        if (imageViewer.getImages().size() == 0) {
            this.operationTabPanel.setEnabledAt(0, false);
            Component[] componentsFromSelectedTab = ((Container)this.operationTabPanel.getSelectedComponent()).getComponents();
            for (int i = 0; i < componentsFromSelectedTab.length; ++i) {
                componentsFromSelectedTab[i].setVisible(false);
            }
        }
        this.add((Component)this.operationTabPanel, "Center");
        JPanel wrappingPanel = new JPanel(new FlowLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 4));
        this.resetButton = new JButton("Reset All");
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand("reset");
        this.resetButton.setToolTipText("Reset all transformations: remove lut operation, set default contrast/brighntess values");
        buttonPanel.add(this.resetButton);
        this.revertButton = new JButton("Revert All");
        this.revertButton.addActionListener(this);
        this.revertButton.setActionCommand("revert");
        this.resetButton.setToolTipText("Restore last saved modifications");
        buttonPanel.add(this.revertButton);
        buttonPanel.add(new JPanel());
        if (imageViewer.getMode() != SettingsUtil.LMCWorkflow) {
            this.saveButton = new JButton("Save");
            this.saveButton.addActionListener(this);
            this.saveButton.setActionCommand("save");
            this.resetButton.setToolTipText("Save changes permanently");
            buttonPanel.add(this.saveButton);
        }
        wrappingPanel.add(buttonPanel);
        this.add((Component)wrappingPanel, "South");
    }

    public void refreshGuiAfterImageSelection() {
        this.operationTabPanel.removeAll();
        this.lutPanel = new LutPanel(this.imageViewer);
        this.lutPanel.setName("lut");
        this.operationTabPanel.addTab("LUT", this.lutPanel);
        this.finish();
        this.contrastBrightnessPanel = new ContrastBrightness(this.imageViewer, false);
        this.contrastBrightnessPanel.setName("contrast");
        this.operationTabPanel.addTab("Contrast/Brightness", this.contrastBrightnessPanel);
        if (this.imageViewer.getImageHandler().getImage().getType() == 4) {
            this.colorPanel = new ContrastBrightness(this.imageViewer, true);
            this.colorPanel.setName("color");
            this.operationTabPanel.addTab("Color", this.colorPanel);
            this.isColorPanelDisplalyed = true;
        }
    }

    public void showColorPanel() {
        if (!this.isColorPanelDisplalyed) {
            this.isColorPanelDisplalyed = true;
            if (this.colorPanel != null) {
                this.colorPanel.finish();
            }
            this.colorPanel = new ContrastBrightness(this.imageViewer, true);
            this.colorPanel.setName("color");
            this.operationTabPanel.addTab("Color", this.colorPanel);
        }
    }

    public void hideColorPanel() {
        if (this.isColorPanelDisplalyed) {
            this.colorPanel.finish();
            this.operationTabPanel.remove(this.colorPanel);
            this.isColorPanelDisplalyed = false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("save")) {
                this.imageViewer.saveModifiedParameters();
            } else if (e.getActionCommand().equals("reset")) {
                this.imageViewer.resetAll();
            } else if (e.getActionCommand().equals("revert")) {
                this.imageViewer.restoreLastSaved();
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during processing image", t, true);
        }
    }

    public void finish() {
        if (this.contrastBrightnessPanel != null) {
            this.contrastBrightnessPanel.finish();
        }
        if (this.isColorPanelDisplalyed) {
            this.colorPanel.finish();
        }
    }

    public JTabbedPane getOperationTabPanel() {
        return this.operationTabPanel;
    }
}

