/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.processors;

import ch.systemsx.sybit.imageviewer.data.ImageHandler;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class LutProcessor {
    private int fire(byte[] reds, byte[] greens, byte[] blues) {
        int[] r = new int[]{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] g = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] b = new int[]{0, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        return r.length;
    }

    private int grays(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            reds[i] = (byte)i;
            greens[i] = (byte)i;
            blues[i] = (byte)i;
        }
        return 256;
    }

    private int primaryColor(int color, byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            if ((color & 4) != 0) {
                reds[i] = (byte)i;
            }
            if ((color & 2) != 0) {
                greens[i] = (byte)i;
            }
            if ((color & 1) == 0) continue;
            blues[i] = (byte)i;
        }
        return 256;
    }

    private int ice(byte[] reds, byte[] greens, byte[] blues) {
        int[] r = new int[]{0, 0, 0, 0, 0, 0, 19, 29, 50, 48, 79, 112, 134, 158, 186, 201, 217, 229, 242, 250, 250, 250, 250, 251, 250, 250, 250, 250, 251, 251, 243, 230};
        int[] g = new int[]{156, 165, 176, 184, 190, 196, 193, 184, 171, 162, 146, 125, 107, 93, 81, 87, 92, 97, 95, 93, 93, 90, 85, 69, 64, 54, 47, 35, 19, 0, 4, 0};
        int[] b = new int[]{140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251, 250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94, 84, 64, 26, 27};
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        return r.length;
    }

    private int spectrum(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            Color c = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
            reds[i] = (byte)c.getRed();
            greens[i] = (byte)c.getGreen();
            blues[i] = (byte)c.getBlue();
        }
        return 256;
    }

    private int rgb332(byte[] reds, byte[] greens, byte[] blues) {
        for (int i = 0; i < 256; ++i) {
            reds[i] = (byte)(i & 0xE0);
            greens[i] = (byte)(i << 3 & 0xE0);
            blues[i] = (byte)(i << 6 & 0xC0);
        }
        return 256;
    }

    private int redGreen(byte[] reds, byte[] greens, byte[] blues) {
        int i;
        for (i = 0; i < 128; ++i) {
            reds[i] = (byte)(i * 2);
            greens[i] = 0;
            blues[i] = 0;
        }
        for (i = 128; i < 256; ++i) {
            reds[i] = 0;
            greens[i] = (byte)(i * 2);
            blues[i] = 0;
        }
        return 256;
    }

    private void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / 256.0;
        for (int i = 0; i < 256; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }

    public boolean doOperation(String name, int slice, ImagePlus image, ColorModel originalColorModel) {
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        int nColors = 0;
        boolean clean = false;
        if (name.equals("fire")) {
            nColors = this.fire(reds, greens, blues);
        } else if (name.equals("grays")) {
            nColors = this.grays(reds, greens, blues);
        } else if (name.equals("ice")) {
            nColors = this.ice(reds, greens, blues);
        } else if (name.equals("spectrum")) {
            nColors = this.spectrum(reds, greens, blues);
        } else if (name.equals("3-3-2 RGB")) {
            nColors = this.rgb332(reds, greens, blues);
        } else if (name.equals("red")) {
            nColors = this.primaryColor(4, reds, greens, blues);
        } else if (name.equals("green")) {
            nColors = this.primaryColor(2, reds, greens, blues);
        } else if (name.equals("blue")) {
            nColors = this.primaryColor(1, reds, greens, blues);
        } else if (name.equals("cyan")) {
            nColors = this.primaryColor(3, reds, greens, blues);
        } else if (name.equals("magenta")) {
            nColors = this.primaryColor(5, reds, greens, blues);
        } else if (name.equals("yellow")) {
            nColors = this.primaryColor(6, reds, greens, blues);
        } else if (name.equals("redgreen")) {
            nColors = this.redGreen(reds, greens, blues);
        } else {
            clean = true;
        }
        if (nColors > 0) {
            if (image.getType() == 4 && image.lock()) {
                if (slice == -1) {
                    ImageConverter converter = new ImageConverter(image);
                    converter.convertToGray8();
                } else {
                    ImageConverter ic = new ImageConverter(image);
                    ic.convertToRGBStack();
                }
                image.unlock();
            }
            if (nColors < 256) {
                this.interpolate(reds, greens, blues, nColors);
            }
            ImageProcessor ip = image.getChannelProcessor();
            IndexColorModel cm = new IndexColorModel(8, 256, reds, greens, blues);
            if (image.isComposite()) {
                ((CompositeImage)image).setChannelColorModel(cm);
            } else {
                ip.setColorModel(cm);
            }
            if (image.getStackSize() > 1) {
                image.getStack().setColorModel(cm);
            }
        } else {
            ImageProcessor ip = image.getProcessor();
            if (image.getStack().isRGB()) {
                if (image.lock()) {
                    ImageConverter ic = new ImageConverter(image);
                    ic.convertRGBStackToRGB();
                    image.unlock();
                }
            } else {
                ip.setColorModel(originalColorModel);
                if (image.getStackSize() > 1) {
                    image.getStack().setColorModel(originalColorModel);
                }
            }
        }
        if (image.getStackSize() >= slice && slice != -1) {
            image.setSlice(slice);
        }
        return clean;
    }

    public void restoreOriginalImage(ImageHandler imageHandler) {
        imageHandler.setImage(null);
        imageHandler.setImage(ImageUtil.generateImageCopy(imageHandler.getOriginalImage()));
        imageHandler.setOriginalColorModel(imageHandler.getOriginalImage().getProcessor().getColorModel());
    }
}

