/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import java.io.File;
import java.util.List;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class ImageReaderTestCase
extends AssertJUnit {
    protected static final String IMAGES_DIR = "./sourceTest/resources/images/";
    protected static final String VALID_SUBDIR = "valid";
    protected static final String INVALID_SUBDIR = "invalid";
    private List<IImageReaderLibrary> libraries;

    @BeforeMethod
    public void setUp() {
        this.libraries = ImageReaderFactory.getLibraries();
    }

    @AfterMethod
    public void tearDown() {
        ImageReaderFactory.setLibraries(this.libraries);
    }

    protected File getImageFileForLibrary(String libraryName, String fileName) {
        return new File(this.getValidImagesDir(libraryName), fileName);
    }

    protected File getValidImagesDir(String libraryName) {
        return new File(IMAGES_DIR + libraryName.toLowerCase(), VALID_SUBDIR);
    }

    protected File getInvalidImagesDir(String libraryName) {
        return new File(IMAGES_DIR + libraryName.toLowerCase(), INVALID_SUBDIR);
    }
}

