/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDualBidiMap<K, V>
implements BidiMap<K, V> {
    protected transient Map<K, V> forwardMap;
    protected transient Map<V, K> inverseMap;
    protected transient BidiMap<V, K> inverseBidiMap = null;
    protected transient Set<K> keySet = null;
    protected transient Set<V> values = null;
    protected transient Set<Map.Entry<K, V>> entrySet = null;

    protected AbstractDualBidiMap() {
        this.forwardMap = this.createMap();
        this.inverseMap = this.createMap();
    }

    protected AbstractDualBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap) {
        this.forwardMap = normalMap;
        this.inverseMap = reverseMap;
    }

    protected AbstractDualBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap, BidiMap<V, K> inverseBidiMap) {
        this.forwardMap = normalMap;
        this.inverseMap = reverseMap;
        this.inverseBidiMap = inverseBidiMap;
    }

    protected Map createMap() {
        return null;
    }

    protected abstract <K, V> BidiMap<K, V> createBidiMap(Map<K, V> var1, Map<V, K> var2, BidiMap<V, K> var3);

    @Override
    public V get(Object key) {
        return this.forwardMap.get(key);
    }

    @Override
    public int size() {
        return this.forwardMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    @Override
    public boolean equals(Object obj) {
        return this.forwardMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.forwardMap.hashCode();
    }

    public String toString() {
        return this.forwardMap.toString();
    }

    @Override
    public V put(K key, V value) {
        if (this.forwardMap.containsKey(key)) {
            this.inverseMap.remove(this.forwardMap.get(key));
        }
        if (this.inverseMap.containsKey(value)) {
            this.forwardMap.remove(this.inverseMap.get(value));
        }
        V obj = this.forwardMap.put(key, value);
        this.inverseMap.put(value, key);
        return obj;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V value = null;
        if (this.forwardMap.containsKey(key)) {
            value = this.forwardMap.remove(key);
            this.inverseMap.remove(value);
        }
        return value;
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
        this.inverseMap.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverseMap.containsKey(value);
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        return new BidiMapIterator(this);
    }

    @Override
    public K getKey(Object value) {
        return this.inverseMap.get(value);
    }

    @Override
    public K removeValue(Object value) {
        K key = null;
        if (this.inverseMap.containsKey(value)) {
            key = this.inverseMap.remove(value);
            this.forwardMap.remove(key);
        }
        return key;
    }

    @Override
    public BidiMap<V, K> inverseBidiMap() {
        if (this.inverseBidiMap == null) {
            this.inverseBidiMap = this.createBidiMap(this.inverseMap, this.forwardMap, this);
        }
        return this.inverseBidiMap;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator<K> createKeySetIterator(Iterator<K> iterator) {
        return new KeySetIterator(iterator, this);
    }

    @Override
    public Set<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator<V> createValuesIterator(Iterator<V> iterator) {
        return new ValuesIterator(iterator, this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator(Iterator<Map.Entry<K, V>> iterator) {
        return new EntrySetIterator<K, V>(iterator, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BidiMapIterator<K, V>
    implements MapIterator<K, V>,
    ResettableIterator<K> {
        protected final AbstractDualBidiMap<K, V> parent;
        protected Iterator<Map.Entry<K, V>> iterator;
        protected Map.Entry<K, V> last = null;
        protected boolean canRemove = false;

        protected BidiMapIterator(AbstractDualBidiMap<K, V> parent) {
            this.parent = parent;
            this.iterator = parent.forwardMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.last = this.iterator.next();
            this.canRemove = true;
            return this.last.getKey();
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            V value = this.last.getValue();
            this.iterator.remove();
            this.parent.inverseMap.remove(value);
            this.last = null;
            this.canRemove = false;
        }

        @Override
        public K getKey() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.last.getKey();
        }

        @Override
        public V getValue() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.last.getValue();
        }

        @Override
        public V setValue(V value) {
            if (this.last == null) {
                throw new IllegalStateException("Iterator setValue() can only be called after next() and before remove()");
            }
            if (this.parent.inverseMap.containsKey(value) && this.parent.inverseMap.get(value) != this.last.getKey()) {
                throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
            }
            return this.parent.put(this.last.getKey(), value);
        }

        @Override
        public void reset() {
            this.iterator = this.parent.forwardMap.entrySet().iterator();
            this.last = null;
            this.canRemove = false;
        }

        public String toString() {
            if (this.last != null) {
                return "MapIterator[" + this.getKey() + "=" + this.getValue() + "]";
            }
            return "MapIterator[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EntrySet<K, V>
    extends View<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        protected EntrySet(AbstractDualBidiMap<K, V> parent) {
            super(parent.forwardMap.entrySet(), parent);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.parent.createEntrySetIterator(super.iterator());
        }

        @Override
        public boolean remove(Object obj) {
            Object value;
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object key = entry.getKey();
            if (this.parent.containsKey(key) && ((value = this.parent.forwardMap.get(key)) == null ? entry.getValue() == null : value.equals(entry.getValue()))) {
                this.parent.forwardMap.remove(key);
                this.parent.inverseMap.remove(value);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EntrySetIterator<K, V>
    extends AbstractIteratorDecorator<Map.Entry<K, V>> {
        protected final AbstractDualBidiMap<K, V> parent;
        protected Map.Entry<K, V> last = null;
        protected boolean canRemove = false;

        protected EntrySetIterator(Iterator<Map.Entry<K, V>> iterator, AbstractDualBidiMap<K, V> parent) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.last = new MapEntry<K, V>((Map.Entry)super.next(), this.parent);
            this.canRemove = true;
            return this.last;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            V value = this.last.getValue();
            super.remove();
            this.parent.inverseMap.remove(value);
            this.last = null;
            this.canRemove = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class KeySet<K, V>
    extends View<K, V, K>
    implements Set<K> {
        protected KeySet(AbstractDualBidiMap<K, V> parent) {
            super(parent.forwardMap.keySet(), parent);
        }

        @Override
        public Iterator<K> iterator() {
            return this.parent.createKeySetIterator(super.iterator());
        }

        @Override
        public boolean contains(Object key) {
            return this.parent.forwardMap.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            if (this.parent.forwardMap.containsKey(key)) {
                Object value = this.parent.forwardMap.remove(key);
                this.parent.inverseMap.remove(value);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class KeySetIterator<K, V>
    extends AbstractIteratorDecorator<K> {
        protected final AbstractDualBidiMap<K, V> parent;
        protected K lastKey = null;
        protected boolean canRemove = false;

        protected KeySetIterator(Iterator<K> iterator, AbstractDualBidiMap<K, V> parent) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        public K next() {
            this.lastKey = super.next();
            this.canRemove = true;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            Object value = this.parent.forwardMap.get(this.lastKey);
            super.remove();
            this.parent.inverseMap.remove(value);
            this.lastKey = null;
            this.canRemove = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapEntry<K, V>
    extends AbstractMapEntryDecorator<K, V> {
        protected final AbstractDualBidiMap<K, V> parent;

        protected MapEntry(Map.Entry<K, V> entry, AbstractDualBidiMap<K, V> parent) {
            super(entry);
            this.parent = parent;
        }

        @Override
        public V setValue(V value) {
            Object key = this.getKey();
            if (this.parent.inverseMap.containsKey(value) && this.parent.inverseMap.get(value) != key) {
                throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
            }
            this.parent.put(key, value);
            V oldValue = super.setValue(value);
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Values<K, V>
    extends View<K, V, V>
    implements Set<V> {
        protected Values(AbstractDualBidiMap<K, V> parent) {
            super(parent.forwardMap.values(), parent);
        }

        @Override
        public Iterator<V> iterator() {
            return this.parent.createValuesIterator(super.iterator());
        }

        @Override
        public boolean contains(Object value) {
            return this.parent.inverseMap.containsKey(value);
        }

        @Override
        public boolean remove(Object value) {
            if (this.parent.inverseMap.containsKey(value)) {
                Object key = this.parent.inverseMap.remove(value);
                this.parent.forwardMap.remove(key);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ValuesIterator<K, V>
    extends AbstractIteratorDecorator<V> {
        protected final AbstractDualBidiMap<K, V> parent;
        protected V lastValue = null;
        protected boolean canRemove = false;

        protected ValuesIterator(Iterator<V> iterator, AbstractDualBidiMap<K, V> parent) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        public V next() {
            this.lastValue = super.next();
            this.canRemove = true;
            return this.lastValue;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Iterator remove() can only be called once after next()");
            }
            super.remove();
            this.parent.inverseMap.remove(this.lastValue);
            this.lastValue = null;
            this.canRemove = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class View<K, V, E>
    extends AbstractCollectionDecorator<E> {
        protected final AbstractDualBidiMap<K, V> parent;

        protected View(Collection<E> coll, AbstractDualBidiMap<K, V> parent) {
            super(coll);
            this.parent = parent;
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            if (this.parent.isEmpty() || coll.isEmpty()) {
                return false;
            }
            boolean modified = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!coll.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            if (this.parent.isEmpty()) {
                return false;
            }
            if (coll.isEmpty()) {
                this.parent.clear();
                return true;
            }
            boolean modified = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (coll.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public void clear() {
            this.parent.clear();
        }
    }
}

