/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.set.AbstractSetDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInputCheckedMapDecorator<K, V>
extends AbstractMapDecorator<K, V> {
    protected AbstractInputCheckedMapDecorator() {
    }

    protected AbstractInputCheckedMapDecorator(Map<K, V> map) {
        super(map);
    }

    protected abstract V checkSetValue(V var1);

    protected boolean isSetValueChecking() {
        return true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isSetValueChecking()) {
            return new EntrySet(this.map.entrySet(), this);
        }
        return this.map.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntrySet<K, V>
    extends AbstractSetDecorator<Map.Entry<K, V>> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected EntrySet(Set<Map.Entry<K, V>> set, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(set);
            this.parent = parent;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.collection.iterator(), this.parent);
        }

        @Override
        public Object[] toArray() {
            Object[] array = this.collection.toArray();
            int i = 0;
            while (i < array.length) {
                array[i] = new MapEntry<K, V>((Map.Entry)array[i], this.parent);
                ++i;
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Object[] result = array;
            if (array.length > 0) {
                result = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
            }
            result = this.collection.toArray(result);
            int i = 0;
            while (i < result.length) {
                result[i] = new MapEntry<K, V>((Map.Entry)result[i], this.parent);
                ++i;
            }
            if (result.length > array.length) {
                return result;
            }
            System.arraycopy(result, 0, array, 0, result.length);
            if (array.length > result.length) {
                array[result.length] = null;
            }
            return array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntrySetIterator<K, V>
    extends AbstractIteratorDecorator<Map.Entry<K, V>> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected EntrySetIterator(Iterator<Map.Entry<K, V>> iterator, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new MapEntry<K, V>(entry, this.parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapEntry<K, V>
    extends AbstractMapEntryDecorator<K, V> {
        private final AbstractInputCheckedMapDecorator<K, V> parent;

        protected MapEntry(Map.Entry<K, V> entry, AbstractInputCheckedMapDecorator<K, V> parent) {
            super(entry);
            this.parent = parent;
        }

        @Override
        public V setValue(V value) {
            value = this.parent.checkSetValue(value);
            return this.entry.setValue(value);
        }
    }
}

