/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.BitSetConversionUtils;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.IHDF5BooleanReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.BitSet;
import ncsa.hdf.hdf5lib.exceptions.HDF5DatatypeInterfaceException;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDF5BooleanReader
implements IHDF5BooleanReader {
    private final HDF5BaseReader baseReader;

    HDF5BooleanReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public boolean getAttr(final String objectPath, final String attributeName) throws HDF5JavaException {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Boolean> writeRunnable = new ICallableWithCleanUp<Boolean>(){

            @Override
            public Boolean call(ICleanUpRegistry registry) {
                byte[] data;
                int objectId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.openObject(((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int nativeDataTypeId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.getNativeDataTypeForAttribute(attributeId, registry);
                Boolean value = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.tryGetBooleanValue(nativeDataTypeId, (data = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, 1))[0]);
                if (value == null) {
                    throw new HDF5JavaException("Attribute " + attributeName + " of path " + objectPath + " needs to be a Boolean.");
                }
                return value;
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public boolean read(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Boolean> writeRunnable = new ICallableWithCleanUp<Boolean>(){

            @Override
            public Boolean call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.openDataSet(((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.fileId, objectPath, registry);
                int nativeDataTypeId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                byte[] data = new byte[1];
                ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, data);
                Boolean value = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.tryGetBooleanValue(nativeDataTypeId, data[0]);
                if (value == null) {
                    throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a Boolean.");
                }
                return value;
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public BitSet readBitField(String objectPath) throws HDF5DatatypeInterfaceException {
        this.baseReader.checkOpen();
        return BitSetConversionUtils.fromStorageForm(this.readBitFieldStorageForm(objectPath));
    }

    private long[] readBitFieldStorageForm(final String objectPath) {
        assert (objectPath != null);
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.openDataSet(((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5BooleanReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_B64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public BitSet readBitFieldBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readBitFieldBlockWithOffset(objectPath, blockSize, (long)blockSize * blockNumber);
    }

    private long[] readBitFieldStorageForm(final String objectPath, final int blockSize, final long offset, final boolean nullWhenOutside) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.openDataSet(((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParamsOrNull = HDF5BooleanReader.this.baseReader.tryGetSpaceParameters(dataSetId, offset, blockSize, nullWhenOutside, registry);
                if (spaceParamsOrNull == null) {
                    return null;
                }
                long[] data = new long[spaceParamsOrNull.blockSize];
                ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_B64, spaceParamsOrNull.memorySpaceId, spaceParamsOrNull.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public BitSet readBitFieldBlockWithOffset(String objectPath, int blockSize, long offset) {
        this.baseReader.checkOpen();
        return BitSetConversionUtils.fromStorageForm(this.readBitFieldStorageForm(objectPath, blockSize, offset, false));
    }

    @Override
    public boolean isBitSet(String objectPath, int bitIndex) {
        int wordIndex = BitSetConversionUtils.getWordIndex(bitIndex);
        long[] storageFormOrNull = this.readBitFieldStorageForm(objectPath, 1, wordIndex, true);
        if (storageFormOrNull == null) {
            return false;
        }
        long word = storageFormOrNull[0];
        return (word & BitSetConversionUtils.getBitMaskInWord(bitIndex)) != 0L;
    }

    @Override
    public BitSet[] readBitFieldArray(String objectPath) {
        this.baseReader.checkOpen();
        return BitSetConversionUtils.fromStorageForm2D(this.readBitFieldArrayStorageForm(objectPath));
    }

    private MDLongArray readBitFieldArrayStorageForm(final String objectPath) {
        assert (objectPath != null);
        ICallableWithCleanUp<MDLongArray> readCallable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.openDataSet(((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5BooleanReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5BooleanReader)HDF5BooleanReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_B64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return new MDLongArray(data, spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }
}

