/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumReader;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueMDArray;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5EnumWriter;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5EnumWriter
extends HDF5EnumReader
implements IHDF5EnumWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5EnumWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        this.baseWriter = baseWriter;
    }

    @Override
    public HDF5EnumerationValue newVal(String typeName, String[] options, String value) {
        return new HDF5EnumerationValue(this.getType(typeName, options), value);
    }

    @Override
    public HDF5EnumerationValue newVal(String typeName, String[] options, int value) {
        return new HDF5EnumerationValue(this.getType(typeName, options), value);
    }

    @Override
    public HDF5EnumerationValue newVal(String typeName, String[] options, short value) {
        return new HDF5EnumerationValue(this.getType(typeName, options), value);
    }

    @Override
    public HDF5EnumerationValue newVal(String typeName, String[] options, byte value) {
        return new HDF5EnumerationValue(this.getType(typeName, options), value);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValue newVal(String typeName, Enum<T> value) {
        return new HDF5EnumerationValue(this.getType(typeName, this.getEnumClass(value)), value);
    }

    @Override
    public HDF5EnumerationValueArray newArray(String typeName, String[] options, String[] values) {
        return new HDF5EnumerationValueArray(this.getType(typeName, options), values);
    }

    @Override
    public HDF5EnumerationValueArray newArray(String typeName, String[] options, int[] values) {
        return new HDF5EnumerationValueArray(this.getType(typeName, options), values);
    }

    @Override
    public HDF5EnumerationValueArray newArray(String typeName, String[] options, short[] values) {
        return new HDF5EnumerationValueArray(this.getType(typeName, options), values);
    }

    @Override
    public HDF5EnumerationValueArray newArray(String typeName, String[] options, byte[] values) {
        return new HDF5EnumerationValueArray(this.getType(typeName, options), values);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValueArray newArray(String typeName, Enum<T>[] values) {
        return new HDF5EnumerationValueArray(this.getType(typeName, this.getEnumClass(values)), values);
    }

    @Override
    public HDF5EnumerationValueMDArray newMDArray(String typeName, String[] options, MDArray<String> values) {
        return new HDF5EnumerationValueMDArray(this.getType(typeName, options), (MDAbstractArray<?>)values);
    }

    @Override
    public HDF5EnumerationValueMDArray newMDArray(String typeName, String[] options, MDIntArray values) {
        return new HDF5EnumerationValueMDArray(this.getType(typeName, options), values);
    }

    @Override
    public HDF5EnumerationValueMDArray newMDArray(String typeName, String[] options, MDShortArray values) {
        return new HDF5EnumerationValueMDArray(this.getType(typeName, options), values);
    }

    @Override
    public HDF5EnumerationValueMDArray newMDArray(String typeName, String[] options, MDByteArray values) {
        return new HDF5EnumerationValueMDArray(this.getType(typeName, options), values);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValueMDArray newMDArray(String typeName, MDArray<Enum<T>> values) {
        return new HDF5EnumerationValueMDArray(this.getType(typeName, this.getEnumClass(values)), (MDAbstractArray<?>)values);
    }

    @Override
    public HDF5EnumerationValue newAnonVal(String[] options, String value) {
        return new HDF5EnumerationValue(this.getAnonType(options), value);
    }

    @Override
    public HDF5EnumerationValue newAnonVal(String[] options, int value) {
        return new HDF5EnumerationValue(this.getAnonType(options), value);
    }

    @Override
    public HDF5EnumerationValue newAnonVal(String[] options, short value) {
        return new HDF5EnumerationValue(this.getAnonType(options), value);
    }

    @Override
    public HDF5EnumerationValue newAnonVal(String[] options, byte value) {
        return new HDF5EnumerationValue(this.getAnonType(options), value);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValue newAnonVal(Enum<T> value) {
        return new HDF5EnumerationValue(this.getAnonType(this.getEnumClass(value)), value);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValue newVal(Enum<T> value) {
        return new HDF5EnumerationValue(this.getType(this.getEnumClass(value)), value);
    }

    @Override
    public HDF5EnumerationValueArray newAnonArray(String[] options, String[] values) {
        return new HDF5EnumerationValueArray(this.getAnonType(options), values);
    }

    @Override
    public HDF5EnumerationValueArray newAnonArray(String[] options, int[] values) {
        return new HDF5EnumerationValueArray(this.getAnonType(options), values);
    }

    @Override
    public HDF5EnumerationValueArray newAnonArray(String[] options, short[] values) {
        return new HDF5EnumerationValueArray(this.getAnonType(options), values);
    }

    @Override
    public HDF5EnumerationValueArray newAnonArray(String[] options, byte[] values) {
        return new HDF5EnumerationValueArray(this.getAnonType(options), values);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValueArray newAnonArray(Enum<T>[] values) {
        return new HDF5EnumerationValueArray(this.getAnonType(this.getEnumClass(values)), values);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValueArray newArray(Enum<T>[] values) {
        return new HDF5EnumerationValueArray(this.getType(this.getEnumClass(values)), values);
    }

    @Override
    public HDF5EnumerationValueMDArray newAnonMDArray(String[] options, MDArray<String> values) {
        return new HDF5EnumerationValueMDArray(this.getAnonType(options), (MDAbstractArray<?>)values);
    }

    @Override
    public HDF5EnumerationValueMDArray newAnonMDArray(String[] options, MDIntArray values) {
        return new HDF5EnumerationValueMDArray(this.getAnonType(options), values);
    }

    @Override
    public HDF5EnumerationValueMDArray newAnonMDArray(String[] options, MDShortArray values) {
        return new HDF5EnumerationValueMDArray(this.getAnonType(options), values);
    }

    @Override
    public HDF5EnumerationValueMDArray newAnonMDArray(String[] options, MDByteArray values) {
        return new HDF5EnumerationValueMDArray(this.getAnonType(options), values);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValueMDArray newAnonMDArray(MDArray<Enum<T>> values) {
        return new HDF5EnumerationValueMDArray(this.getAnonType(this.getEnumClass(values)), (MDAbstractArray<?>)values);
    }

    @Override
    public <T extends Enum<T>> HDF5EnumerationValueMDArray newMDArray(MDArray<Enum<T>> values) {
        return new HDF5EnumerationValueMDArray(this.getType(this.getEnumClass(values)), (MDAbstractArray<?>)values);
    }

    private <T extends Enum<T>> Class<Enum<T>> getEnumClass(Enum<T> value) {
        return value.getClass();
    }

    private <T extends Enum<T>> Class<Enum<T>> getEnumClass(Enum<T>[] data) {
        return data.getClass().getComponentType();
    }

    private <T extends Enum<T>> Class<Enum<T>> getEnumClass(MDArray<Enum<T>> data) {
        return ((Enum[])data.getAsFlatArray()).getClass().getComponentType();
    }

    @Override
    public HDF5EnumerationType getAnonType(String[] values) throws HDF5JavaException {
        return this.getType(null, values, false);
    }

    @Override
    public HDF5EnumerationType getAnonType(Class<? extends Enum<?>> enumClass) throws HDF5JavaException {
        return this.getType(null, ReflectionUtils.getEnumOptions(enumClass));
    }

    @Override
    public HDF5EnumerationType getType(String name, String[] values) throws HDF5JavaException {
        return this.getType(name, values, true);
    }

    @Override
    public HDF5EnumerationType getType(String nameOrNull, String[] values, boolean check) throws HDF5JavaException {
        this.baseWriter.checkOpen();
        int storageDataTypeId = this.getOrCreateEnumDataType(nameOrNull, values, this.baseWriter.keepDataSetIfExists, check);
        int nativeDataTypeId = this.baseWriter.h5.getNativeDataType(storageDataTypeId, this.baseWriter.fileRegistry);
        return new HDF5EnumerationType(this.baseWriter.fileId, storageDataTypeId, nativeDataTypeId, nameOrNull == null ? "__anonymous__" : nameOrNull, values, this.baseWriter);
    }

    @Override
    public HDF5EnumerationType getType(String name, Class<? extends Enum<?>> enumClass) throws HDF5JavaException {
        return this.getType(name, ReflectionUtils.getEnumOptions(enumClass), true);
    }

    @Override
    public <T extends Enum<?>> HDF5EnumerationType getType(String name, Class<T> enumClass, boolean check) throws HDF5JavaException {
        return this.getType(name, ReflectionUtils.getEnumOptions(enumClass), check);
    }

    @Override
    public <T extends Enum<?>> HDF5EnumerationType getType(Class<T> enumClass) throws HDF5JavaException {
        return this.getType(enumClass.getSimpleName(), ReflectionUtils.getEnumOptions(enumClass), true);
    }

    @Override
    public HDF5EnumerationType getType(Class<? extends Enum<?>> enumClass, boolean check) throws HDF5JavaException {
        return this.getType(enumClass.getSimpleName(), ReflectionUtils.getEnumOptions(enumClass), check);
    }

    private int getOrCreateEnumDataType(String dataTypeNameOrNull, String[] values, boolean committedDataTypeHasPreference, boolean checkIfExists) {
        boolean commitType;
        String dataTypePathOrNull = dataTypeNameOrNull == null ? null : HDF5Utils.createDataTypePath("Enum_", this.baseWriter.houseKeepingNameSuffix, dataTypeNameOrNull);
        int committedStorageDataTypeId = dataTypePathOrNull == null ? -1 : this.baseWriter.getDataTypeId(dataTypePathOrNull);
        boolean typeExists = committedStorageDataTypeId >= 0;
        int storageDataTypeId = committedStorageDataTypeId;
        if (!typeExists || !committedDataTypeHasPreference) {
            storageDataTypeId = this.baseWriter.h5.createDataTypeEnum(values, this.baseWriter.fileRegistry);
            boolean typesAreEqual = typeExists && this.baseWriter.h5.dataTypesAreEqual(committedStorageDataTypeId, storageDataTypeId);
            boolean bl = commitType = dataTypeNameOrNull != null && (!typeExists || !typesAreEqual);
            if (typeExists && commitType) {
                String replacementDataTypePath = this.baseWriter.moveLinkOutOfTheWay(dataTypePathOrNull);
                this.baseWriter.renameNamedDataType(dataTypePathOrNull, replacementDataTypePath);
            }
            if (typesAreEqual) {
                storageDataTypeId = committedStorageDataTypeId;
            }
        } else {
            commitType = false;
            if (checkIfExists) {
                this.baseWriter.checkEnumValues(storageDataTypeId, values, dataTypeNameOrNull);
            }
        }
        if (commitType) {
            this.baseWriter.commitDataType(dataTypePathOrNull, storageDataTypeId);
        }
        return storageDataTypeId;
    }

    @Override
    public void setAttr(String objectPath, String name, HDF5EnumerationValue value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        value.getType().check(this.baseWriter.fileId);
        int storageDataTypeId = value.getType().getStorageTypeId();
        int nativeDataTypeId = value.getType().getNativeTypeId();
        this.baseWriter.setAttribute(objectPath, name, storageDataTypeId, nativeDataTypeId, value.toStorageForm());
    }

    @Override
    public void setAttr(String objectPath, String name, Enum<?> value) throws HDF5JavaException {
        this.setAttr(objectPath, name, new HDF5EnumerationValue(this.getType(this.getEnumClass(value)), value));
    }

    @Override
    public void setArrayAttr(String objectPath, String name, HDF5EnumerationValueArray value) {
        this.baseWriter.setEnumArrayAttribute(objectPath, name, value);
    }

    @Override
    public void setMDArrayAttr(String objectPath, String name, HDF5EnumerationValueMDArray value) {
        this.baseWriter.setEnumMDArrayAttribute(objectPath, name, value);
    }

    @Override
    public void write(String objectPath, HDF5EnumerationValue value) throws HDF5JavaException {
        assert (objectPath != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        value.getType().check(this.baseWriter.fileId);
        int storageDataTypeId = value.getType().getStorageTypeId();
        int nativeDataTypeId = value.getType().getNativeTypeId();
        this.baseWriter.writeScalar(objectPath, storageDataTypeId, nativeDataTypeId, value.toStorageForm());
    }

    @Override
    public void write(String objectPath, Enum<?> value) throws HDF5JavaException {
        this.write(objectPath, new HDF5EnumerationValue(this.getType(this.getEnumClass(value)), value));
    }

    @Override
    public void writeArray(String objectPath, HDF5EnumerationValueArray data) throws HDF5JavaException {
        this.writeArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final HDF5EnumerationValueArray data, final HDF5IntStorageFeatures features) throws HDF5JavaException {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        data.getType().check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.isScaling()) {
                    features.checkScalingOK(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileFormat);
                    HDF5IntStorageFeatures actualFeatures = HDF5IntStorageFeatures.createDeflateAndIntegerScaling(features.getDeflateLevel(), data.getType().getNumberOfBits(), HDF5EnumWriter.this.baseWriter.keepDataIfExists(features));
                    int dataSetId = HDF5EnumWriter.this.baseWriter.getOrCreateDataSetId(objectPath, data.getType().getIntStorageTypeId(), new long[]{data.getLength()}, data.getStorageForm().getStorageSize(), actualFeatures, registry);
                    H5D.H5Dwrite(dataSetId, data.getType().getIntNativeTypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.toStorageForm());
                    HDF5EnumWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.ENUM, registry);
                    HDF5EnumWriter.this.baseWriter.setStringAttribute(dataSetId, HDF5Utils.getEnumTypeNameAttributeName(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.houseKeepingNameSuffix), data.getType().getName(), data.getType().getName().length(), true, registry);
                } else {
                    int dataSetId = HDF5EnumWriter.this.baseWriter.getOrCreateDataSetId(objectPath, data.getType().getStorageTypeId(), new long[]{data.getLength()}, data.getStorageForm().getStorageSize(), features, registry);
                    H5D.H5Dwrite(dataSetId, data.getType().getNativeTypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.toStorageForm());
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public HDF5EnumerationType createArray(String objectPath, HDF5EnumerationType enumType, int size) {
        return this.createArray(objectPath, enumType, (long)size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5EnumerationType createArray(String objectPath, HDF5EnumerationType enumType, long size, int blockSize) {
        return this.createArray(objectPath, enumType, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5EnumerationType createArray(final String objectPath, final HDF5EnumerationType enumType, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        this.baseWriter.checkOpen();
        enumType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.isScaling()) {
                    features.checkScalingOK(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileFormat);
                    HDF5IntStorageFeatures actualCompression = HDF5IntStorageFeatures.createDeflateAndIntegerScaling(features.getDeflateLevel(), enumType.getNumberOfBits());
                    int dataSetId = HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getIntStorageTypeId(), actualCompression, new long[]{size}, new long[]{blockSize}, enumType.getStorageForm().getStorageSize(), registry);
                    HDF5EnumWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.ENUM, registry);
                    HDF5EnumWriter.this.baseWriter.setStringAttribute(dataSetId, HDF5Utils.getEnumTypeNameAttributeName(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.houseKeepingNameSuffix), enumType.getName(), enumType.getName().length(), true, registry);
                } else {
                    HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getStorageTypeId(), features, new long[]{size}, new long[]{blockSize}, enumType.getStorageForm().getStorageSize(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
        return enumType;
    }

    @Override
    public HDF5EnumerationType createArray(final String objectPath, final HDF5EnumerationType enumType, final long size, final HDF5IntStorageFeatures features) {
        this.baseWriter.checkOpen();
        enumType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    this.create(new long[1], new long[]{size}, registry);
                } else {
                    this.create(new long[]{size}, null, registry);
                }
                return null;
            }

            private void create(long[] dimensions, long[] blockDimensionsOrNull, ICleanUpRegistry registry) {
                if (features.isScaling()) {
                    features.checkScalingOK(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileFormat);
                    HDF5IntStorageFeatures actualCompression = HDF5IntStorageFeatures.createDeflateAndIntegerScaling(features.getDeflateLevel(), enumType.getNumberOfBits());
                    int dataSetId = HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getIntStorageTypeId(), actualCompression, dimensions, blockDimensionsOrNull, enumType.getStorageForm().getStorageSize(), registry);
                    HDF5EnumWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.ENUM, registry);
                    HDF5EnumWriter.this.baseWriter.setStringAttribute(dataSetId, HDF5Utils.getEnumTypeNameAttributeName(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.houseKeepingNameSuffix), enumType.getName(), enumType.getName().length(), true, registry);
                } else {
                    HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getStorageTypeId(), features, dimensions, blockDimensionsOrNull, enumType.getStorageForm().getStorageSize(), registry);
                }
            }
        };
        this.baseWriter.runner.call(createRunnable);
        return enumType;
    }

    @Override
    public void writeArrayBlock(String objectPath, HDF5EnumerationValueArray data, long blockNumber) {
        assert (objectPath != null);
        assert (data != null);
        this.writeArrayBlockWithOffset(objectPath, data, data.getLength(), (long)data.getLength() * blockNumber);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final HDF5EnumerationValueArray data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        data.getType().check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileId, objectPath, ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                if (HDF5EnumWriter.this.baseWriter.isScaledEnum(dataSetId, registry)) {
                    H5D.H5Dwrite(dataSetId, data.getType().getIntNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.toStorageForm());
                    HDF5EnumWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.ENUM, registry);
                    HDF5EnumWriter.this.baseWriter.setStringAttribute(dataSetId, HDF5Utils.getEnumTypeNameAttributeName(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.houseKeepingNameSuffix), data.getType().getName(), data.getType().getName().length(), true, registry);
                } else {
                    H5D.H5Dwrite(dataSetId, data.getType().getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.toStorageForm());
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArray(String objectPath, HDF5EnumerationValueMDArray data) throws HDF5JavaException {
        this.writeMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeMDArray(final String objectPath, final HDF5EnumerationValueMDArray data, final HDF5IntStorageFeatures features) throws HDF5JavaException {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        data.getType().check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.isScaling()) {
                    features.checkScalingOK(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileFormat);
                    HDF5IntStorageFeatures actualFeatures = HDF5IntStorageFeatures.createDeflateAndIntegerScaling(features.getDeflateLevel(), data.getType().getNumberOfBits(), HDF5EnumWriter.this.baseWriter.keepDataIfExists(features));
                    int dataSetId = HDF5EnumWriter.this.baseWriter.getOrCreateDataSetId(objectPath, data.getType().getIntStorageTypeId(), data.longDimensions(), data.getStorageForm().getStorageSize(), actualFeatures, registry);
                    H5D.H5Dwrite(dataSetId, data.getType().getIntNativeTypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.toStorageForm());
                    HDF5EnumWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.ENUM, registry);
                    HDF5EnumWriter.this.baseWriter.setStringAttribute(dataSetId, HDF5Utils.getEnumTypeNameAttributeName(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.houseKeepingNameSuffix), data.getType().getName(), data.getType().getName().length(), true, registry);
                } else {
                    int dataSetId = HDF5EnumWriter.this.baseWriter.getOrCreateDataSetId(objectPath, data.getType().getStorageTypeId(), data.longDimensions(), data.getStorageForm().getStorageSize(), features, registry);
                    H5D.H5Dwrite(dataSetId, data.getType().getNativeTypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.toStorageForm());
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    private <T> void writeEnumMDArrayBlockWithOffset(final String objectPath, final HDF5EnumerationType enumType, final byte[] data, final long[] dimensions, final long[] offset, final long[] dataSetDimensions) {
        assert (objectPath != null);
        assert (enumType != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        enumType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileId, objectPath, ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5EnumWriter)HDF5EnumWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5D.H5Dwrite(dataSetId, enumType.getNativeTypeId(), memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlockWithOffset(String objectPath, HDF5EnumerationValueMDArray data, long[] offset) {
        long[] dimensions = data.longDimensions();
        long[] dataSetDimensions = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            dataSetDimensions[i] = offset[i] + dimensions[i];
            ++i;
        }
        this.writeEnumMDArrayBlockWithOffset(objectPath, data.getType(), data.toStorageForm(), dimensions, offset, dataSetDimensions);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, HDF5EnumerationValueMDArray data, long[] blockNumber) {
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        long[] dataSetDimensions = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            dataSetDimensions[i] = offset[i] + dimensions[i];
            ++i;
        }
        this.writeEnumMDArrayBlockWithOffset(objectPath, data.getType(), data.toStorageForm(), dimensions, offset, dataSetDimensions);
    }

    @Override
    public HDF5EnumerationType createMDArray(String objectPath, HDF5EnumerationType enumType, int[] dimensions) {
        return this.createMDArray(objectPath, enumType, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5EnumerationType createMDArray(String objectPath, HDF5EnumerationType enumType, long[] dimensions, int[] blockDimensions) {
        return this.createMDArray(objectPath, enumType, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public HDF5EnumerationType createMDArray(final String objectPath, final HDF5EnumerationType enumType, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (enumType != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        enumType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getStorageTypeId(), features, dimensions, MDAbstractArray.toLong((int[])blockDimensions), enumType.getStorageForm().getStorageSize(), registry);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
        return enumType;
    }

    @Override
    public HDF5EnumerationType createMDArray(final String objectPath, final HDF5EnumerationType enumType, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (enumType != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        enumType.check(this.baseWriter.fileId);
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getStorageTypeId(), features, nullDimensions, MDAbstractArray.toLong((int[])dimensions), enumType.getStorageForm().getStorageSize(), registry);
                } else {
                    HDF5EnumWriter.this.baseWriter.createDataSet(objectPath, enumType.getStorageTypeId(), features, MDAbstractArray.toLong((int[])dimensions), null, enumType.getStorageForm().getStorageSize(), registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
        return enumType;
    }
}

