/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDF5OpaqueReader
implements IHDF5OpaqueReader {
    private final HDF5BaseReader baseReader;

    HDF5OpaqueReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public String tryGetOpaqueTag(final String objectPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readTagCallable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openDataSet(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                return ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.tryGetOpaqueTag(dataTypeId);
            }
        };
        return this.baseReader.runner.call(readTagCallable);
    }

    @Override
    public HDF5OpaqueType tryGetOpaqueType(final String objectPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5OpaqueType> readTagCallable = new ICallableWithCleanUp<HDF5OpaqueType>(){

            @Override
            public HDF5OpaqueType call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openDataSet(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileRegistry);
                String opaqueTagOrNull = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.tryGetOpaqueTag(dataTypeId);
                if (opaqueTagOrNull == null) {
                    return null;
                }
                return new HDF5OpaqueType(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, dataTypeId, opaqueTagOrNull, HDF5OpaqueReader.this.baseReader);
            }
        };
        return this.baseReader.runner.call(readTagCallable);
    }

    @Override
    public byte[] readArray(final String objectPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                byte[] data;
                boolean isString;
                int dataSetId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openDataSet(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5OpaqueReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                int nativeDataTypeId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                boolean bl = isString = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getClassType(nativeDataTypeId) == HDF5Constants.H5T_STRING;
                if (isString) {
                    if (((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.isVariableLengthString(nativeDataTypeId)) {
                        String[] value = new String[1];
                        ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.readDataSetVL(dataSetId, nativeDataTypeId, value);
                        try {
                            data = value[0].getBytes(CharacterEncoding.ASCII.getCharSetName());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            data = value[0].getBytes();
                        }
                    } else {
                        int size = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                        data = new byte[size];
                        ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, nativeDataTypeId, data);
                    }
                } else {
                    int elementSize = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                    data = new byte[spaceParams.blockSize * elementSize];
                    ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                }
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] getArrayAttr(final String objectPath, final String attributeName) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int objectId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openObject(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                return HDF5OpaqueReader.this.baseReader.getAttributeAsByteArray(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] readArrayBlock(final String objectPath, final int blockSize, final long blockNumber) throws HDF5JavaException {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openDataSet(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5OpaqueReader.this.baseReader.getSpaceParameters(dataSetId, blockNumber * (long)blockSize, blockSize, registry);
                int nativeDataTypeId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                HDF5OpaqueReader.this.checkNotAString(objectPath, nativeDataTypeId);
                int elementSize = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                byte[] data = new byte[elementSize * spaceParams.blockSize];
                ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public byte[] readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) throws HDF5JavaException {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<byte[]> readCallable = new ICallableWithCleanUp<byte[]>(){

            @Override
            public byte[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openDataSet(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5OpaqueReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                int nativeDataTypeId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                HDF5OpaqueReader.this.checkNotAString(objectPath, nativeDataTypeId);
                int elementSize = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                byte[] data = new byte[elementSize * spaceParams.blockSize];
                ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int readArrayToBlockWithOffset(final String objectPath, final byte[] buffer, final int blockSize, final long offset, final int memoryOffset) throws HDF5JavaException {
        if (blockSize + memoryOffset > buffer.length) {
            throw new HDF5JavaException("Buffer not large enough for blockSize and memoryOffset");
        }
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Integer> readCallable = new ICallableWithCleanUp<Integer>(){

            @Override
            public Integer call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.openDataSet(((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5OpaqueReader.this.baseReader.getSpaceParameters(dataSetId, memoryOffset, offset, blockSize, false, registry);
                int nativeDataTypeId = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                HDF5OpaqueReader.this.checkNotAString(objectPath, nativeDataTypeId);
                int elementSize = ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.getDataTypeSize(nativeDataTypeId);
                if ((blockSize + memoryOffset) * elementSize > buffer.length) {
                    throw new HDF5JavaException("Buffer not large enough for blockSize and memoryOffset");
                }
                ((HDF5OpaqueReader)HDF5OpaqueReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, buffer);
                return spaceParams.blockSize;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<byte[]>>(){

            @Override
            public Iterator<HDF5DataBlock<byte[]>> iterator() {
                return new Iterator<HDF5DataBlock<byte[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<byte[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        byte[] block = HDF5OpaqueReader.this.readArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<byte[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void checkNotAString(String objectPath, int nativeDataTypeId) {
        boolean isString;
        boolean bl = isString = this.baseReader.h5.getClassType(nativeDataTypeId) == HDF5Constants.H5T_STRING;
        if (isString) {
            throw new HDF5JavaException(String.valueOf(objectPath) + " cannot be a String.");
        }
    }
}

