/*
 * Decompiled with CFR 0.152.
 */
package loci.common.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import loci.common.RandomAccessInputStream;
import loci.common.xml.MetadataHandler;
import loci.common.xml.ParserErrorHandler;
import loci.common.xml.ValidationErrorHandler;
import loci.common.xml.ValidationSAXHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLTools {
    static final Logger LOGGER = LoggerFactory.getLogger(XMLTools.class);
    private static final String XML_SCHEMA_PATH = "http://www.w3.org/2001/XMLSchema";
    private static final SchemaFactory FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static ThreadLocal<HashMap<URI, Schema>> schemas = new ThreadLocal<HashMap<URI, Schema>>(){

        @Override
        protected HashMap<URI, Schema> initialValue() {
            return new HashMap<URI, Schema>();
        }
    };

    private XMLTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDOM(File file2) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream is = new FileInputStream(file2);
        try {
            Document doc;
            Document document = doc = XMLTools.parseDOM(is);
            return document;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDOM(String xml) throws ParserConfigurationException, SAXException, IOException {
        byte[] bytes = xml.getBytes("UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            Document doc;
            Document document = doc = XMLTools.parseDOM(is);
            return document;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static Document parseDOM(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        db.setErrorHandler(new ParserErrorHandler());
        return db.parse(is);
    }

    public static String getXML(Document doc) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setErrorListener(new XMLListener());
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    public static String sanitizeXML(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isISOControl(c[i]) || !Character.isDefined(c[i])) {
                c[i] = 32;
            }
            if (i <= 0 || c[i - 1] != '&' || c[i] != '#') continue;
            c[i - 1] = 32;
        }
        return new String(c);
    }

    public static String escapeXML(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String indentXML(String xml) {
        return XMLTools.indentXML(xml, 3, false);
    }

    public static String indentXML(String xml, int spacing) {
        return XMLTools.indentXML(xml, spacing, false);
    }

    public static String indentXML(String xml, boolean preserveCData) {
        return XMLTools.indentXML(xml, 3, preserveCData);
    }

    public static String indentXML(String xml, int spacing, boolean preserveCData) {
        if (xml == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(xml, "<>", true);
        int indent = 0;
        int noSpace = 0;
        boolean first = true;
        boolean element = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals("")) continue;
            if (token.equals("<")) {
                element = true;
                continue;
            }
            if (element && token.equals(">")) {
                element = false;
                continue;
            }
            if (!element && preserveCData) {
                noSpace = 2;
            }
            if (noSpace == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
            }
            if (element && token.startsWith("/")) {
                indent -= spacing;
            }
            if (noSpace == 0) {
                for (int j = 0; j < indent; ++j) {
                    sb.append(" ");
                }
            }
            if (element) {
                sb.append("<");
            }
            sb.append(token);
            if (element) {
                sb.append(">");
            }
            if (!(noSpace != 0 || !element || token.startsWith("?") || token.startsWith("/") || token.endsWith("/") || token.startsWith("!"))) {
                indent += spacing;
            }
            if (noSpace <= 0) continue;
            --noSpace;
        }
        sb.append("\n");
        return sb.toString();
    }

    public static Hashtable<String, String> parseXML(String xml) throws IOException {
        MetadataHandler handler = new MetadataHandler();
        XMLTools.parseXML(xml, (DefaultHandler)handler);
        return handler.getMetadata();
    }

    public static void parseXML(String xml, DefaultHandler handler) throws IOException {
        XMLTools.parseXML(xml.getBytes("UTF-8"), handler);
    }

    public static void parseXML(RandomAccessInputStream stream, DefaultHandler handler) throws IOException {
        XMLTools.parseXML((InputStream)stream, handler);
    }

    public static void parseXML(byte[] xml, DefaultHandler handler) throws IOException {
        XMLTools.parseXML(new ByteArrayInputStream(xml), handler);
    }

    public static void parseXML(InputStream xml, DefaultHandler handler) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(xml, handler);
        }
        catch (ParserConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        catch (SAXException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Templates getStylesheet(String resourcePath, Class<?> sourceClass) {
        InputStream xsltStream;
        if (sourceClass == null) {
            try {
                xsltStream = new FileInputStream(resourcePath);
            }
            catch (IOException exc) {
                LOGGER.debug("Could not open file", exc);
                return null;
            }
        } else {
            xsltStream = sourceClass.getResourceAsStream(resourcePath);
        }
        try {
            StreamSource xsltSource = new StreamSource(xsltStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(new XMLListener());
            Templates templates = transformerFactory.newTemplates(xsltSource);
            return templates;
        }
        catch (TransformerConfigurationException exc) {
            LOGGER.debug("Could not construct template", exc);
        }
        finally {
            try {
                if (xsltStream != null) {
                    xsltStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("Could not close file", e);
            }
        }
        return null;
    }

    public static String avoidUndeclaredNamespaces(String xml) {
        int gt = xml.indexOf(62);
        if (gt > 0 && xml.startsWith("<?xml ")) {
            gt = xml.indexOf(62, gt + 1);
        }
        if (gt > 0) {
            String firstTag = xml.substring(0, gt + 1).toLowerCase();
            while (firstTag.endsWith("-->")) {
                gt = xml.indexOf(62, gt + 1);
                firstTag = xml.substring(0, gt + 1).toLowerCase();
            }
            HashSet<String> namespaces = new HashSet<String>();
            Pattern pattern = Pattern.compile(" xmlns:(\\w+)");
            Matcher matcher = pattern.matcher(firstTag);
            while (matcher.find()) {
                namespaces.add(matcher.group(1));
            }
            pattern = Pattern.compile("</?(\\w+):");
            matcher = pattern.matcher(xml);
            while (matcher.find()) {
                String namespace = matcher.group(1);
                if (namespace.equalsIgnoreCase("OME") || namespace.startsWith("ns") || namespaces.contains(namespace.toLowerCase())) continue;
                int end = matcher.end();
                xml = xml.substring(0, end - 1) + "_" + xml.substring(end);
            }
            Pattern emptyNamespaces = Pattern.compile(" xmlns:(\\w+)=\"\"");
            matcher = emptyNamespaces.matcher(firstTag);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                xml = xml.substring(0, start + 1) + xml.substring(end);
            }
        }
        return xml;
    }

    public static String transformXML(String xml, Templates xslt) throws IOException {
        xml = XMLTools.avoidUndeclaredNamespaces(xml);
        return XMLTools.transformXML(new StreamSource(new StringReader(xml)), xslt);
    }

    public static String transformXML(Source xmlSource, Templates xslt) throws IOException {
        Transformer trans;
        try {
            trans = xslt.newTransformer();
            trans.setErrorListener(new XMLListener());
        }
        catch (TransformerConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        StringWriter xmlWriter = new StringWriter();
        StreamResult xmlResult = new StreamResult(xmlWriter);
        try {
            trans.transform(xmlSource, xmlResult);
        }
        catch (TransformerException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        return xmlWriter.toString();
    }

    public static boolean validateXML(String xml) {
        return XMLTools.validateXML(xml, null);
    }

    public static boolean validateXML(String xml, String label) {
        if (label == null) {
            label = "XML";
        }
        Exception exception = null;
        LOGGER.info("Parsing schema path");
        ValidationSAXHandler saxHandler = new ValidationSAXHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            saxParser.parse((InputStream)is, (DefaultHandler)saxHandler);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.warn("Error parsing schema path from {}", (Object)label, (Object)exception);
            return false;
        }
        String schemaPath = saxHandler.getSchemaPath();
        if (schemaPath == null) {
            LOGGER.error("No schema path found. Validation cannot continue.");
            return false;
        }
        LOGGER.info(schemaPath);
        LOGGER.info("Validating {}", (Object)label);
        URI schemaLocation = null;
        try {
            schemaLocation = new URI(schemaPath);
        }
        catch (URISyntaxException exc) {
            LOGGER.info("Error accessing schema at {}", (Object)schemaPath, (Object)exc);
            return false;
        }
        Schema schema = schemas.get().get(schemaLocation);
        if (schema == null) {
            try {
                schema = FACTORY.newSchema(schemaLocation.toURL());
                schemas.get().put(schemaLocation, schema);
            }
            catch (MalformedURLException exc) {
                LOGGER.info("Error parsing schema at {}", (Object)schemaPath, (Object)exc);
                return false;
            }
            catch (SAXException exc) {
                LOGGER.info("Error parsing schema at {}", (Object)schemaPath, (Object)exc);
                return false;
            }
        }
        Validator validator = schema.newValidator();
        StringReader reader = new StringReader(xml);
        InputSource is = new InputSource(reader);
        SAXSource source = new SAXSource(is);
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(source);
        }
        catch (IOException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        int errors = errorHandler.getErrorCount();
        if (errors > 0) {
            LOGGER.info("Error validating document: {} errors found", errors);
            return false;
        }
        LOGGER.info("No validation errors found.");
        return errorHandler.ok();
    }

    static class XMLListener
    implements ErrorListener {
        XMLListener() {
        }

        public void error(TransformerException e) {
            LOGGER.debug("", e);
        }

        public void fatalError(TransformerException e) {
            LOGGER.debug("", e);
        }

        public void warning(TransformerException e) {
            LOGGER.debug("", e);
        }
    }
}

