/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FEITiffReader
extends BaseTiffReader {
    public static final int SFEG_TAG = 34680;
    public static final int HELIOS_TAG = 34682;
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss a";
    private static final double MAG_MULTIPLIER = 0.0024388925;
    private String imageName;
    private String imageDescription;
    private String date;
    private String userName;
    private String microscopeModel;
    private Double stageX;
    private Double stageY;
    private Double stageZ;
    private Double sizeX;
    private Double sizeY;
    private Double timeIncrement;
    private ArrayList<String> detectors;
    private int magnification;

    public FEITiffReader() {
        super("FEI TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(34680) || ifd.containsKey(34682);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageName = null;
            this.imageDescription = null;
            this.date = null;
            this.userName = null;
            this.microscopeModel = null;
            this.stageZ = null;
            this.stageY = null;
            this.stageX = null;
            this.timeIncrement = null;
            this.sizeY = null;
            this.sizeX = null;
            this.detectors = null;
            this.magnification = 0;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        boolean helios = ((IFD)this.ifds.get(0)).containsKey(34682);
        this.addGlobalMeta("Software", helios ? "Helios NanoLab" : "S-FEG");
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(helios ? 34682 : 34680);
        tag = tag.trim();
        if (tag.startsWith("<")) {
            XMLTools.parseXML(tag, (DefaultHandler)new FEIHandler());
        } else {
            IniParser parser = new IniParser();
            IniList ini = parser.parseINI(new BufferedReader(new StringReader(tag)));
            this.detectors = new ArrayList();
            if (helios) {
                IniTable userTable = ini.getTable("User");
                this.date = (String)userTable.get("Date") + " " + (String)userTable.get("Time");
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    String beamTableName;
                    IniTable beamTable;
                    this.userName = (String)userTable.get("User");
                    IniTable systemTable = ini.getTable("System");
                    if (systemTable == null) {
                        systemTable = ini.getTable("SYSTEM");
                    }
                    if (systemTable != null) {
                        this.microscopeModel = (String)systemTable.get("SystemType");
                    }
                    if ((beamTable = ini.getTable("Beam")) != null && (beamTableName = (String)beamTable.get("Beam")) != null) {
                        beamTable = ini.getTable(beamTableName);
                    }
                    if (beamTable != null) {
                        String beamX = (String)beamTable.get("StageX");
                        String beamY = (String)beamTable.get("StageY");
                        String beamZ = (String)beamTable.get("StageZ");
                        IniTable stageTable = ini.getTable("Stage");
                        if (beamX != null) {
                            this.stageX = new Double(beamX);
                        } else if (stageTable != null) {
                            this.stageX = new Double((String)stageTable.get("StageX"));
                        }
                        if (beamY != null) {
                            this.stageY = new Double(beamY);
                        } else if (stageTable != null) {
                            this.stageY = new Double((String)stageTable.get("StageY"));
                        }
                        if (beamZ != null) {
                            this.stageZ = new Double(beamZ);
                        } else if (stageTable != null) {
                            this.stageZ = new Double((String)stageTable.get("StageZ"));
                        }
                    }
                    IniTable scanTable = ini.getTable("Scan");
                    this.sizeX = new Double((String)scanTable.get("PixelWidth")) * 1000000.0;
                    this.sizeY = new Double((String)scanTable.get("PixelHeight")) * 1000000.0;
                    this.timeIncrement = new Double((String)scanTable.get("FrameTime"));
                }
            } else {
                IniTable dataTable = ini.getTable("DatabarData");
                this.imageName = (String)dataTable.get("ImageName");
                this.imageDescription = (String)dataTable.get("szUserText");
                String magnification = (String)ini.getTable("Vector").get("Magnification");
                this.sizeX = new Double(magnification) * 0.0024388925;
                this.sizeY = new Double(magnification) * 0.0024388925;
                IniTable scanTable = ini.getTable("Vector.Sysscan");
                this.stageX = new Double((String)scanTable.get("PositionX"));
                this.stageY = new Double((String)scanTable.get("PositionY"));
                IniTable detectorTable = ini.getTable("Vector.Video.Detectors");
                int detectorCount = Integer.parseInt((String)detectorTable.get("NrDetectorsConnected"));
                for (int i = 0; i < detectorCount; ++i) {
                    this.detectors.add((String)detectorTable.get("Detector_" + i + "_Name"));
                }
            }
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                HashMap<String, String> iniMap = ini.flattenIntoHashMap();
                this.metadata.putAll(iniMap);
            }
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.date != null) {
            this.date = DateTools.formatDate(this.date, DATE_FORMAT);
            if (this.date != null) {
                store.setImageAcquisitionDate(new Timestamp(this.date), 0);
            }
        }
        if (this.imageName != null) {
            store.setImageName(this.imageName, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument;
            if (this.imageDescription != null) {
                store.setImageDescription(this.imageDescription, 0);
            }
            if (this.userName != null) {
                store.setExperimenterID(MetadataTools.createLSID("Experimenter", 0), 0);
                store.setExperimenterLastName(this.userName, 0);
            }
            if (this.microscopeModel != null) {
                instrument = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                store.setMicroscopeModel(this.microscopeModel, 0);
            }
            if (this.detectors != null && this.detectors.size() > 0) {
                instrument = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                for (int i = 0; i < this.detectors.size(); ++i) {
                    String detectorID = MetadataTools.createLSID("Detector", 0, i);
                    store.setDetectorID(detectorID, 0, i);
                    store.setDetectorModel(this.detectors.get(i), 0, i);
                    store.setDetectorType(this.getDetectorType("Other"), 0, i);
                }
            }
            if (this.magnification > 0) {
                store.setObjectiveID(MetadataTools.createLSID("Objective", 0, 0), 0, 0);
                store.setObjectiveNominalMagnification(new PositiveInteger(this.magnification), 0, 0);
                store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
                store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            }
            store.setStageLabelX(this.stageX, 0);
            store.setStageLabelY(this.stageY, 0);
            store.setStageLabelZ(this.stageZ, 0);
            store.setStageLabelName("", 0);
            if (this.sizeX != null && this.sizeX > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.sizeX), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", this.sizeX);
            }
            if (this.sizeY != null && this.sizeY > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.sizeY), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", this.sizeY);
            }
            store.setPixelsTimeIncrement(this.timeIncrement, 0);
        }
    }

    class FEIHandler
    extends BaseHandler {
        private String key;
        private String value;
        private String qName;

        FEIHandler() {
        }

        public void characters(char[] data, int start, int len) {
            if (this.qName.equals("Label")) {
                this.key = new String(data, start, len);
                this.value = null;
            } else if (this.qName.equals("Value")) {
                this.value = new String(data, start, len);
            }
            if (this.key != null && this.value != null) {
                FEITiffReader.this.addGlobalMeta(this.key, this.value);
                if (this.key.equals("Stage X")) {
                    FEITiffReader.this.stageX = new Double(this.value);
                } else if (this.key.equals("Stage Y")) {
                    FEITiffReader.this.stageY = new Double(this.value);
                } else if (this.key.equals("Stage Z")) {
                    FEITiffReader.this.stageZ = new Double(this.value);
                } else if (this.key.equals("Microscope")) {
                    FEITiffReader.this.microscopeModel = this.value;
                } else if (this.key.equals("User")) {
                    FEITiffReader.this.userName = this.value;
                } else if (this.key.equals("Magnification")) {
                    FEITiffReader.this.magnification = (int)Double.parseDouble(this.value);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.qName = qName;
        }
    }
}

