/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WcsRequest {
    private Operation operation;
    private String version;
    private String datasetPath;
    private GridDataset dataset;
    private List<String> availableCoverageNames;

    WcsRequest(Operation operation, String version, String datasetPath, GridDataset dataset) {
        this.operation = operation;
        this.version = version;
        this.datasetPath = datasetPath;
        this.dataset = dataset;
        this.availableCoverageNames = new ArrayList<String>();
        for (GridDataset.Gridset curGridset : this.dataset.getGridsets()) {
            for (GridDatatype curGridDatatype : curGridset.getGrids()) {
                this.availableCoverageNames.add(curGridDatatype.getName());
            }
        }
        if (operation == null) {
            throw new IllegalArgumentException("Non-null operation required.");
        }
        if (this.datasetPath == null) {
            throw new IllegalArgumentException("Non-null dataset path required.");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDatasetPath() {
        return this.datasetPath;
    }

    public GridDataset getDataset() {
        return this.dataset;
    }

    public List<String> getAvailableCoverageNames() {
        return Collections.unmodifiableList(this.availableCoverageNames);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        NONE,
        GeoTIFF,
        GeoTIFF_Float,
        NetCDF3;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestEncoding {
        GET_KVP,
        POST_XML,
        POST_SOAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        GetCapabilities,
        DescribeCoverage,
        GetCoverage;

    }
}

