/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.bioformats.BioFormatsReaderLibrary;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.List;
import org.testng.annotations.Test;

public class BioFormatsReaderLibraryTest
extends ImageReaderTestCase {
    @Test
    public void testTIFF() throws FileNotFoundException {
        BioFormatsReaderLibrary library = new BioFormatsReaderLibrary();
        String libraryName = library.getName();
        File imageFile = this.getImageFileForLibrary(libraryName, "multi-page.tif");
        IImageReader reader = library.tryGetReaderForFile(imageFile.getPath());
        List imageIDs = reader.getImageIDs(imageFile);
        BioFormatsReaderLibraryTest.assertEquals((String)"[0-0-0-0, 0-1-0-0]", (String)imageIDs.toString());
        BufferedImage image0 = reader.readImage(imageFile, (ImageID)imageIDs.get(0), null);
        BioFormatsReaderLibraryTest.assertEquals((int)459, (int)image0.getWidth());
        BioFormatsReaderLibraryTest.assertEquals((int)435, (int)image0.getHeight());
        BufferedImage image1 = reader.readImage(imageFile, (ImageID)imageIDs.get(1), null);
        BioFormatsReaderLibraryTest.assertEquals((int)459, (int)image1.getWidth());
        BioFormatsReaderLibraryTest.assertEquals((int)435, (int)image1.getHeight());
        int depth = reader.readColorDepth((IRandomAccessFile)new RandomAccessFileImpl(new RandomAccessFile(imageFile, "r")), (ImageID)imageIDs.get(0));
        BioFormatsReaderLibraryTest.assertEquals((int)8, (int)depth);
        depth = reader.readColorDepth((IRandomAccessFile)new RandomAccessFileImpl(new RandomAccessFile(imageFile, "r")), (ImageID)imageIDs.get(1));
        BioFormatsReaderLibraryTest.assertEquals((int)8, (int)depth);
    }
}

