/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.filesystem.StoreItem;

public interface IDirectoryScanningHandler {
    public void init(DirectoryScanningTimerTask.IScannedStore var1);

    public void beforeHandle(DirectoryScanningTimerTask.IScannedStore var1);

    public HandleInstruction mayHandle(DirectoryScanningTimerTask.IScannedStore var1, StoreItem var2);

    public Status finishItemHandle(DirectoryScanningTimerTask.IScannedStore var1, StoreItem var2);

    public static class HandleInstruction {
        public static final HandleInstruction PROCESS = new HandleInstruction(HandleInstructionFlag.PROCESS, null);
        public static final HandleInstruction IGNORE = new HandleInstruction(HandleInstructionFlag.IGNORE, null);
        private final HandleInstructionFlag flag;
        private final String messageOrNull;

        public static HandleInstruction createError() {
            return new HandleInstruction(HandleInstructionFlag.ERROR, null);
        }

        public static HandleInstruction createError(String message) {
            assert (message != null);
            return new HandleInstruction(HandleInstructionFlag.ERROR, message);
        }

        public static HandleInstruction createError(String messageTemplate, Object ... args) {
            assert (messageTemplate != null);
            return new HandleInstruction(HandleInstructionFlag.ERROR, String.format(messageTemplate, args));
        }

        private HandleInstruction(HandleInstructionFlag flag, String messageOrNull) {
            assert (flag != null);
            this.flag = flag;
            this.messageOrNull = messageOrNull;
        }

        public final HandleInstructionFlag getFlag() {
            return this.flag;
        }

        public final String tryGetMessage() {
            return this.messageOrNull;
        }
    }

    public static enum HandleInstructionFlag {
        PROCESS,
        IGNORE,
        ERROR;

    }
}

