/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import java.io.File;
import java.util.Properties;

public abstract class DelegatingStorageProcessorWithDropbox
extends AbstractDelegatingStorageProcessor {
    protected final Properties properties;
    protected final IFileOperations fileOperations;

    public abstract IPostRegistrationDatasetHandler createPostRegistrationDataSetHandler();

    public DelegatingStorageProcessorWithDropbox(Properties properties) {
        this(properties, AbstractDelegatingStorageProcessor.createDelegateStorageProcessor(properties), FileOperations.getInstance());
    }

    @Private
    DelegatingStorageProcessorWithDropbox(Properties properties, IStorageProcessorTransactional delegateStorageProcessor, IFileOperations fileOperations) {
        super(delegateStorageProcessor);
        this.properties = properties;
        this.fileOperations = fileOperations;
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        IStorageProcessorTransactional.IStorageProcessorTransaction superTransaction = super.createTransaction(parameters);
        IPostRegistrationDatasetHandler dropboxHandler = this.createPostRegistrationDataSetHandler();
        return new StorageProcessorWithDropboxTransaction(parameters, superTransaction, dropboxHandler);
    }

    public static final class StorageProcessorWithDropboxTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final transient IPostRegistrationDatasetHandler dropboxHandler;

        private StorageProcessorWithDropboxTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction transaction, IPostRegistrationDatasetHandler dropboxHandler) {
            super(parameters, transaction);
            this.dropboxHandler = dropboxHandler;
        }

        @Override
        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            File originalData = this.nestedTransaction.tryGetProprietaryData();
            this.dropboxHandler.handle(originalData, this.dataSetInformation, null);
            return this.nestedTransaction.getStoredDataDirectory();
        }

        @Override
        protected void executeCommit() {
            this.nestedTransaction.commit();
        }

        @Override
        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            if (this.dropboxHandler != null) {
                this.dropboxHandler.undoLastOperation();
            }
            return this.nestedTransaction.rollback(ex);
        }

        public IPostRegistrationDatasetHandler getPostReigstrationHandler() {
            return this.dropboxHandler;
        }
    }
}

