/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.etlserver.IStoreRootDirectoryHolder;
import java.io.File;
import org.apache.log4j.Logger;

public class TopLevelDataSetChecker {
    private final Logger operationLog;
    private final IStoreRootDirectoryHolder storeRootDirectoryHolder;
    private final IFileOperations fileOperations;

    public TopLevelDataSetChecker(Logger operationLog, IStoreRootDirectoryHolder storeRootDirectoryHolder, IFileOperations fileOperations) {
        this.operationLog = operationLog;
        this.storeRootDirectoryHolder = storeRootDirectoryHolder;
        this.fileOperations = fileOperations;
    }

    public void runCheck() {
        String errorMessage;
        File storeRootDirectory = this.storeRootDirectoryHolder.getStoreRootDirectory();
        storeRootDirectory.mkdirs();
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Checking store root directory '" + storeRootDirectory.getAbsolutePath() + "'."));
        }
        if ((errorMessage = this.fileOperations.checkDirectoryFullyAccessible(storeRootDirectory, "store root")) != null) {
            if (!this.fileOperations.exists(storeRootDirectory)) {
                throw EnvironmentFailureException.fromTemplate("Store root directory '%s' does not exist.", storeRootDirectory.getAbsolutePath());
            }
            throw new ConfigurationFailureException(errorMessage);
        }
    }
}

