/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.etlserver.BaseDirectoryHolder;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.FileRenamer;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.TransferredDataSetHandler;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.v2.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.types.DataSetTypeCode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DataSetStorageRollbacker {
    private final AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorContext;
    private final Logger operationLog;
    private final IStorageProcessorTransactional.UnstoreDataAction unstoreAction;
    private final DataSetFile incomingDataSetFile;
    private final String dataSetTypeCodeOrNull;
    private final Throwable errorOrNull;
    private final IDataSetOnErrorActionDecision.ErrorType errorTypeOrNull;
    private BaseDirectoryHolder baseDirectoryHolder;

    public DataSetStorageRollbacker(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorContext, Logger operationLog, IStorageProcessorTransactional.UnstoreDataAction unstoreAction, DataSetFile incomingDataSetFile, String dataSetTypeCodeOrNull, Throwable errorOrNull) {
        this(registratorContext, operationLog, unstoreAction, incomingDataSetFile, dataSetTypeCodeOrNull, errorOrNull, null);
    }

    public DataSetStorageRollbacker(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorContext, Logger operationLog, IStorageProcessorTransactional.UnstoreDataAction unstoreAction, DataSetFile incomingDataSetFile, String dataSetTypeCodeOrNull, Throwable errorOrNull, IDataSetOnErrorActionDecision.ErrorType errorTypeOrNull) {
        this.registratorContext = registratorContext;
        this.operationLog = operationLog;
        this.unstoreAction = unstoreAction;
        this.incomingDataSetFile = incomingDataSetFile;
        this.dataSetTypeCodeOrNull = dataSetTypeCodeOrNull;
        this.errorOrNull = errorOrNull;
        this.errorTypeOrNull = errorTypeOrNull;
    }

    public String getErrorMessageForLog() {
        if (this.errorTypeOrNull != null) {
            return "Responding to error [" + (Object)((Object)this.errorTypeOrNull) + "] by performing action " + (Object)((Object)this.unstoreAction) + " on " + this.incomingDataSetFile.getRealIncomingFile();
        }
        return "Performing action " + (Object)((Object)this.unstoreAction) + " on " + this.incomingDataSetFile.getRealIncomingFile();
    }

    public File doRollback(DssRegistrationLogger dssRegistrationLog) {
        dssRegistrationLog.log(this.getErrorMessageForLog());
        if (this.incomingDataSetFile.isLogicalFileSpecified()) {
            FileUtilities.deleteRecursively(this.incomingDataSetFile.getLogicalIncomingFile().getParentFile());
        }
        if (this.unstoreAction == IStorageProcessorTransactional.UnstoreDataAction.MOVE_TO_ERROR) {
            File newLocation = this.moveIncomingToError();
            if (this.errorOrNull != null) {
                this.writeThrowable();
            }
            StringBuilder moveMessage = new StringBuilder();
            moveMessage.append("File has been moved to ");
            moveMessage.append(newLocation.getAbsolutePath());
            dssRegistrationLog.log(moveMessage.toString());
            return newLocation;
        }
        if (this.unstoreAction == IStorageProcessorTransactional.UnstoreDataAction.DELETE) {
            dssRegistrationLog.log("File has been deleted.");
            FileUtilities.deleteRecursively(this.incomingDataSetFile.getRealIncomingFile(), new Log4jSimpleLogger(this.operationLog));
            return null;
        }
        StringBuilder untouchedMessage = new StringBuilder();
        untouchedMessage.append("File has been left untouched ");
        untouchedMessage.append(this.incomingDataSetFile.getRealIncomingFile().getAbsolutePath());
        dssRegistrationLog.log(untouchedMessage.toString());
        return this.incomingDataSetFile.getRealIncomingFile();
    }

    public File moveIncomingToError() {
        DataSetInformation dataSetInfo = new DataSetInformation();
        dataSetInfo.setShareId(this.registratorContext.getGlobalState().getShareId());
        if (this.dataSetTypeCodeOrNull == null) {
            dataSetInfo.setDataSetType(new DataSetType(DataSetTypeCode.UNKNOWN.getCode()));
        } else {
            dataSetInfo.setDataSetType(new DataSetType(this.dataSetTypeCodeOrNull));
        }
        File baseDirectory = DataSetStorageAlgorithm.createBaseDirectory(TransferredDataSetHandler.ERROR_DATA_STRATEGY, this.registratorContext.getStorageProcessor().getStoreRootDirectory(), this.registratorContext.getFileOperations(), dataSetInfo, dataSetInfo.getDataSetType(), this.incomingDataSetFile.getRealIncomingFile());
        this.baseDirectoryHolder = new BaseDirectoryHolder(TransferredDataSetHandler.ERROR_DATA_STRATEGY, baseDirectory, this.incomingDataSetFile.getRealIncomingFile());
        FileRenamer.renameAndLog(this.incomingDataSetFile.getRealIncomingFile(), this.baseDirectoryHolder.getTargetFile());
        return this.baseDirectoryHolder.getTargetFile();
    }

    private void writeThrowable() {
        block6: {
            assert (this.errorOrNull != null);
            String fileName = String.valueOf(this.incomingDataSetFile.getRealIncomingFile().getName()) + ".exception";
            File file = new File(this.baseDirectoryHolder.getTargetFile().getParentFile(), fileName);
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    this.errorOrNull.printStackTrace(new PrintWriter(writer));
                }
                catch (IOException e) {
                    this.operationLog.warn((Object)String.format("Could not write out the exception '%s' in file '%s'.", fileName, file.getAbsolutePath()), (Throwable)e);
                    IOUtils.closeQuietly((Writer)writer);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

