/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.io.HDF5DataSetRandomAccessFile;
import ch.systemsx.cisd.hdf5.io.HDF5IOAdapterFactory;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalDirectoryContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalFileContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IFileContentProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class HDF5ContainerBasedHierarchicalContentNode
extends DefaultFileBasedHierarchicalContentNode {
    private final HDF5Container hdf5Container;

    public HDF5ContainerBasedHierarchicalContentNode(IHierarchicalContent root, File hdf5ContainerFile) {
        super(root, hdf5ContainerFile);
        this.hdf5Container = new HDF5Container(hdf5ContainerFile);
    }

    private IHDF5ContainerReader createReader() {
        return this.hdf5Container.createSimpleReader();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public List<IHierarchicalContentNode> doGetChildNodes() {
        IHDF5ContainerReader reader = this.createReader();
        try {
            List<ArchiveEntry> entries = reader.getGroupMembers("/");
            ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
            for (ArchiveEntry entry : entries) {
                result.add(this.getChildNode(entry));
            }
            ArrayList<IHierarchicalContentNode> arrayList = result;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    private IHierarchicalContentNode getChildNode(ArchiveEntry entry) {
        if (entry.isDirectory()) {
            return new HDF5GroupNode(this, entry);
        }
        return new HDF5FileNode(this, entry);
    }

    public IHierarchicalContentNode tryGetChildNode(String childPath) {
        IHDF5ContainerReader reader = this.createReader();
        try {
            ArchiveEntry childEntry = reader.tryGetEntry(childPath);
            if (childEntry == null) {
                return null;
            }
            if (childEntry.isDirectory()) {
                HDF5GroupNode hDF5GroupNode = new HDF5GroupNode(this, childEntry);
                return hDF5GroupNode;
            }
            HDF5FileNode hDF5FileNode = new HDF5FileNode(this, childEntry);
            return hDF5FileNode;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public String toString() {
        return "HDF5ContainerBasedHierarchicalContentNode [root=" + this.root + ", container=" + this.hdf5Container.getHDF5File() + "]";
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.hdf5Container.getHDF5File().hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HDF5ContainerBasedHierarchicalContentNode)) {
            return false;
        }
        HDF5ContainerBasedHierarchicalContentNode other = (HDF5ContainerBasedHierarchicalContentNode)obj;
        if (!this.hdf5Container.getHDF5File().equals(other.hdf5Container.getHDF5File())) {
            return false;
        }
        return this.root.equals(other.root);
    }

    private static HDF5DataSetBasedContent extractFileContent(File hdf5File, String path) {
        return new HDF5DataSetBasedContent(hdf5File, path);
    }

    public static class HDF5DataSetBasedContent
    implements IFileContentProvider,
    Closeable {
        private final File hdf5File;
        private final String path;
        private final List<HDF5DataSetRandomAccessFile> randomAccessFiles;

        public HDF5DataSetBasedContent(File hdf5File, String path) {
            this.hdf5File = hdf5File;
            this.path = path;
            this.randomAccessFiles = new ArrayList<HDF5DataSetRandomAccessFile>();
        }

        @Override
        public IRandomAccessFile getReadOnlyRandomAccessFile() {
            HDF5DataSetRandomAccessFile randomAccessFile = HDF5IOAdapterFactory.asRandomAccessFileReadOnly((File)this.hdf5File, (String)this.path);
            this.randomAccessFiles.add(randomAccessFile);
            return randomAccessFile;
        }

        @Override
        public InputStream getInputStream() {
            return new AdapterIInputStreamToInputStream((IInputStream)this.getReadOnlyRandomAccessFile());
        }

        @Override
        public void close() {
            for (HDF5DataSetRandomAccessFile raFile : this.randomAccessFiles) {
                raFile.close();
            }
        }
    }

    class HDF5FileNode
    extends AbstractHierarchicalFileContentNode {
        private final ArchiveEntry entry;
        private HDF5DataSetBasedContent contentOrNull;
        private final HDF5ContainerBasedHierarchicalContentNode containerNode;
        private Integer checksum;

        public HDF5FileNode(HDF5ContainerBasedHierarchicalContentNode containerNode, ArchiveEntry entry) {
            this.containerNode = containerNode;
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String doGetRelativePath() {
            return String.valueOf(this.containerNode.getRelativePath()) + this.entry.getPath();
        }

        @Override
        public boolean exists() {
            return this.entry.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public long getLastModified() {
            return this.entry.getLastModified() < 0L ? HDF5ContainerBasedHierarchicalContentNode.this.file.lastModified() : this.entry.getLastModified() * 1000L;
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("This is not a normal file node.");
        }

        @Override
        public File tryGetFile() {
            return null;
        }

        @Override
        protected long doGetFileLength() {
            return this.entry.getSize();
        }

        @Override
        protected int doGetChecksumCRC32() {
            if (this.checksum != null) {
                return this.checksum;
            }
            this.checksum = this.isChecksumCRC32Precalculated() ? Integer.valueOf(this.entry.getCrc32()) : Integer.valueOf(IOUtilities.getChecksumCRC32(this.doGetInputStream()));
            return this.checksum;
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return this.entry.hasChecksum();
        }

        @Override
        protected IRandomAccessFile doGetFileContent() {
            return this.getContent().getReadOnlyRandomAccessFile();
        }

        @Override
        protected InputStream doGetInputStream() {
            return this.getContent().getInputStream();
        }

        private HDF5DataSetBasedContent getContent() {
            if (this.contentOrNull == null) {
                this.contentOrNull = HDF5ContainerBasedHierarchicalContentNode.extractFileContent(HDF5ContainerBasedHierarchicalContentNode.this.file, this.entry.getPath());
            }
            return this.contentOrNull;
        }

        public String toString() {
            return "HDF5FileNode [containerPath=" + this.containerNode.getRelativePath() + ", relativePath=" + this.entry.getPath() + ", fileName=" + this.entry.getName() + "]";
        }
    }

    class HDF5GroupNode
    extends AbstractHierarchicalDirectoryContentNode {
        private final ArchiveEntry entry;
        private final HDF5ContainerBasedHierarchicalContentNode containerNode;

        public HDF5GroupNode(HDF5ContainerBasedHierarchicalContentNode containerNode, ArchiveEntry entry) {
            this.containerNode = containerNode;
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String doGetRelativePath() {
            return String.valueOf(this.containerNode.getRelativePath()) + this.entry.getPath();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public long getLastModified() {
            return this.entry.getLastModified() < 0L ? HDF5ContainerBasedHierarchicalContentNode.this.file.lastModified() : this.entry.getLastModified() * 1000L;
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("This is not a normal directory node.");
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return false;
        }

        @Override
        public File tryGetFile() {
            return null;
        }

        @Override
        protected List<IHierarchicalContentNode> doGetChildNodes() {
            IHDF5ContainerReader reader = HDF5ContainerBasedHierarchicalContentNode.this.createReader();
            try {
                ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
                List<ArchiveEntry> children = reader.getGroupMembers(this.entry.getPath());
                for (ArchiveEntry childEntry : children) {
                    if (childEntry.isDirectory()) {
                        result.add(new HDF5GroupNode(this.containerNode, childEntry));
                        continue;
                    }
                    result.add(new HDF5FileNode(this.containerNode, childEntry));
                }
                ArrayList<IHierarchicalContentNode> arrayList = result;
                return arrayList;
            }
            finally {
                reader.close();
            }
        }

        public String toString() {
            return "HDF5GroupNode [containerPath=" + this.containerNode.getRelativePath() + ", relativePath=" + this.entry.getPath() + ", groupName=" + this.entry.getName() + "]";
        }
    }
}

